/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.BaseFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.Nested;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PodDNSConfig;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PodDNSConfigOption;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PodDNSConfigOptionBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PodDNSConfigOptionFluent;

public class PodDNSConfigFluent<A extends PodDNSConfigFluent<A>>
extends BaseFluent<A> {
    private List<String> nameservers = new ArrayList<String>();
    private ArrayList<PodDNSConfigOptionBuilder> options = new ArrayList();
    private List<String> searches = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public PodDNSConfigFluent() {
    }

    public PodDNSConfigFluent(PodDNSConfig instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(PodDNSConfig instance) {
        PodDNSConfig podDNSConfig = instance = instance != null ? instance : new PodDNSConfig();
        if (instance != null) {
            this.withNameservers(instance.getNameservers());
            this.withOptions(instance.getOptions());
            this.withSearches(instance.getSearches());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToNameservers(int index, String item) {
        if (this.nameservers == null) {
            this.nameservers = new ArrayList<String>();
        }
        this.nameservers.add(index, item);
        return (A)this;
    }

    public A setToNameservers(int index, String item) {
        if (this.nameservers == null) {
            this.nameservers = new ArrayList<String>();
        }
        this.nameservers.set(index, item);
        return (A)this;
    }

    public A addToNameservers(String ... items) {
        if (this.nameservers == null) {
            this.nameservers = new ArrayList<String>();
        }
        for (String item : items) {
            this.nameservers.add(item);
        }
        return (A)this;
    }

    public A addAllToNameservers(Collection<String> items) {
        if (this.nameservers == null) {
            this.nameservers = new ArrayList<String>();
        }
        for (String item : items) {
            this.nameservers.add(item);
        }
        return (A)this;
    }

    public A removeFromNameservers(String ... items) {
        if (this.nameservers == null) {
            return (A)this;
        }
        for (String item : items) {
            this.nameservers.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromNameservers(Collection<String> items) {
        if (this.nameservers == null) {
            return (A)this;
        }
        for (String item : items) {
            this.nameservers.remove(item);
        }
        return (A)this;
    }

    public List<String> getNameservers() {
        return this.nameservers;
    }

    public String getNameserver(int index) {
        return this.nameservers.get(index);
    }

    public String getFirstNameserver() {
        return this.nameservers.get(0);
    }

    public String getLastNameserver() {
        return this.nameservers.get(this.nameservers.size() - 1);
    }

    public String getMatchingNameserver(Predicate<String> predicate) {
        for (String item : this.nameservers) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingNameserver(Predicate<String> predicate) {
        for (String item : this.nameservers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withNameservers(List<String> nameservers) {
        if (nameservers != null) {
            this.nameservers = new ArrayList<String>();
            for (String item : nameservers) {
                this.addToNameservers(item);
            }
        } else {
            this.nameservers = null;
        }
        return (A)this;
    }

    public A withNameservers(String ... nameservers) {
        if (this.nameservers != null) {
            this.nameservers.clear();
            this._visitables.remove("nameservers");
        }
        if (nameservers != null) {
            for (String item : nameservers) {
                this.addToNameservers(item);
            }
        }
        return (A)this;
    }

    public boolean hasNameservers() {
        return this.nameservers != null && !this.nameservers.isEmpty();
    }

    public A addToOptions(int index, PodDNSConfigOption item) {
        if (this.options == null) {
            this.options = new ArrayList();
        }
        PodDNSConfigOptionBuilder builder = new PodDNSConfigOptionBuilder(item);
        if (index < 0 || index >= this.options.size()) {
            this._visitables.get("options").add(builder);
            this.options.add(builder);
        } else {
            this._visitables.get("options").add(builder);
            this.options.add(index, builder);
        }
        return (A)this;
    }

    public A setToOptions(int index, PodDNSConfigOption item) {
        if (this.options == null) {
            this.options = new ArrayList();
        }
        PodDNSConfigOptionBuilder builder = new PodDNSConfigOptionBuilder(item);
        if (index < 0 || index >= this.options.size()) {
            this._visitables.get("options").add(builder);
            this.options.add(builder);
        } else {
            this._visitables.get("options").add(builder);
            this.options.set(index, builder);
        }
        return (A)this;
    }

    public A addToOptions(PodDNSConfigOption ... items) {
        if (this.options == null) {
            this.options = new ArrayList();
        }
        for (PodDNSConfigOption item : items) {
            PodDNSConfigOptionBuilder builder = new PodDNSConfigOptionBuilder(item);
            this._visitables.get("options").add(builder);
            this.options.add(builder);
        }
        return (A)this;
    }

    public A addAllToOptions(Collection<PodDNSConfigOption> items) {
        if (this.options == null) {
            this.options = new ArrayList();
        }
        for (PodDNSConfigOption item : items) {
            PodDNSConfigOptionBuilder builder = new PodDNSConfigOptionBuilder(item);
            this._visitables.get("options").add(builder);
            this.options.add(builder);
        }
        return (A)this;
    }

    public A removeFromOptions(PodDNSConfigOption ... items) {
        if (this.options == null) {
            return (A)this;
        }
        for (PodDNSConfigOption item : items) {
            PodDNSConfigOptionBuilder builder = new PodDNSConfigOptionBuilder(item);
            this._visitables.get("options").remove(builder);
            this.options.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromOptions(Collection<PodDNSConfigOption> items) {
        if (this.options == null) {
            return (A)this;
        }
        for (PodDNSConfigOption item : items) {
            PodDNSConfigOptionBuilder builder = new PodDNSConfigOptionBuilder(item);
            this._visitables.get("options").remove(builder);
            this.options.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromOptions(Predicate<PodDNSConfigOptionBuilder> predicate) {
        if (this.options == null) {
            return (A)this;
        }
        Iterator<PodDNSConfigOptionBuilder> each = this.options.iterator();
        Object visitables = this._visitables.get("options");
        while (each.hasNext()) {
            PodDNSConfigOptionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<PodDNSConfigOption> buildOptions() {
        return this.options != null ? PodDNSConfigFluent.build(this.options) : null;
    }

    public PodDNSConfigOption buildOption(int index) {
        return this.options.get(index).build();
    }

    public PodDNSConfigOption buildFirstOption() {
        return this.options.get(0).build();
    }

    public PodDNSConfigOption buildLastOption() {
        return this.options.get(this.options.size() - 1).build();
    }

    public PodDNSConfigOption buildMatchingOption(Predicate<PodDNSConfigOptionBuilder> predicate) {
        for (PodDNSConfigOptionBuilder item : this.options) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingOption(Predicate<PodDNSConfigOptionBuilder> predicate) {
        for (PodDNSConfigOptionBuilder item : this.options) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withOptions(List<PodDNSConfigOption> options) {
        if (this.options != null) {
            this._visitables.get("options").clear();
        }
        if (options != null) {
            this.options = new ArrayList();
            for (PodDNSConfigOption item : options) {
                this.addToOptions(item);
            }
        } else {
            this.options = null;
        }
        return (A)this;
    }

    public A withOptions(PodDNSConfigOption ... options) {
        if (this.options != null) {
            this.options.clear();
            this._visitables.remove("options");
        }
        if (options != null) {
            for (PodDNSConfigOption item : options) {
                this.addToOptions(item);
            }
        }
        return (A)this;
    }

    public boolean hasOptions() {
        return this.options != null && !this.options.isEmpty();
    }

    public A addNewOption(String name, String value) {
        return this.addToOptions(new PodDNSConfigOption(name, value));
    }

    public OptionsNested<A> addNewOption() {
        return new OptionsNested(-1, null);
    }

    public OptionsNested<A> addNewOptionLike(PodDNSConfigOption item) {
        return new OptionsNested(-1, item);
    }

    public OptionsNested<A> setNewOptionLike(int index, PodDNSConfigOption item) {
        return new OptionsNested(index, item);
    }

    public OptionsNested<A> editOption(int index) {
        if (this.options.size() <= index) {
            throw new RuntimeException("Can't edit options. Index exceeds size.");
        }
        return this.setNewOptionLike(index, this.buildOption(index));
    }

    public OptionsNested<A> editFirstOption() {
        if (this.options.size() == 0) {
            throw new RuntimeException("Can't edit first options. The list is empty.");
        }
        return this.setNewOptionLike(0, this.buildOption(0));
    }

    public OptionsNested<A> editLastOption() {
        int index = this.options.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last options. The list is empty.");
        }
        return this.setNewOptionLike(index, this.buildOption(index));
    }

    public OptionsNested<A> editMatchingOption(Predicate<PodDNSConfigOptionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.options.size(); ++i) {
            if (!predicate.test(this.options.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching options. No match found.");
        }
        return this.setNewOptionLike(index, this.buildOption(index));
    }

    public A addToSearches(int index, String item) {
        if (this.searches == null) {
            this.searches = new ArrayList<String>();
        }
        this.searches.add(index, item);
        return (A)this;
    }

    public A setToSearches(int index, String item) {
        if (this.searches == null) {
            this.searches = new ArrayList<String>();
        }
        this.searches.set(index, item);
        return (A)this;
    }

    public A addToSearches(String ... items) {
        if (this.searches == null) {
            this.searches = new ArrayList<String>();
        }
        for (String item : items) {
            this.searches.add(item);
        }
        return (A)this;
    }

    public A addAllToSearches(Collection<String> items) {
        if (this.searches == null) {
            this.searches = new ArrayList<String>();
        }
        for (String item : items) {
            this.searches.add(item);
        }
        return (A)this;
    }

    public A removeFromSearches(String ... items) {
        if (this.searches == null) {
            return (A)this;
        }
        for (String item : items) {
            this.searches.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromSearches(Collection<String> items) {
        if (this.searches == null) {
            return (A)this;
        }
        for (String item : items) {
            this.searches.remove(item);
        }
        return (A)this;
    }

    public List<String> getSearches() {
        return this.searches;
    }

    public String getSearch(int index) {
        return this.searches.get(index);
    }

    public String getFirstSearch() {
        return this.searches.get(0);
    }

    public String getLastSearch() {
        return this.searches.get(this.searches.size() - 1);
    }

    public String getMatchingSearch(Predicate<String> predicate) {
        for (String item : this.searches) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingSearch(Predicate<String> predicate) {
        for (String item : this.searches) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSearches(List<String> searches) {
        if (searches != null) {
            this.searches = new ArrayList<String>();
            for (String item : searches) {
                this.addToSearches(item);
            }
        } else {
            this.searches = null;
        }
        return (A)this;
    }

    public A withSearches(String ... searches) {
        if (this.searches != null) {
            this.searches.clear();
            this._visitables.remove("searches");
        }
        if (searches != null) {
            for (String item : searches) {
                this.addToSearches(item);
            }
        }
        return (A)this;
    }

    public boolean hasSearches() {
        return this.searches != null && !this.searches.isEmpty();
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PodDNSConfigFluent that = (PodDNSConfigFluent)o;
        if (!Objects.equals(this.nameservers, that.nameservers)) {
            return false;
        }
        if (!Objects.equals(this.options, that.options)) {
            return false;
        }
        if (!Objects.equals(this.searches, that.searches)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.nameservers, this.options, this.searches, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.nameservers != null && !this.nameservers.isEmpty()) {
            sb.append("nameservers:");
            sb.append(String.valueOf(this.nameservers) + ",");
        }
        if (this.options != null && !this.options.isEmpty()) {
            sb.append("options:");
            sb.append(String.valueOf(this.options) + ",");
        }
        if (this.searches != null && !this.searches.isEmpty()) {
            sb.append("searches:");
            sb.append(String.valueOf(this.searches) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class OptionsNested<N>
    extends PodDNSConfigOptionFluent<OptionsNested<N>>
    implements Nested<N> {
        PodDNSConfigOptionBuilder builder;
        int index;

        OptionsNested(int index, PodDNSConfigOption item) {
            this.index = index;
            this.builder = new PodDNSConfigOptionBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PodDNSConfigFluent.this.setToOptions(this.index, this.builder.build());
        }

        public N endOption() {
            return this.and();
        }
    }
}

