/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.Builder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.Editable;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.VisitableBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.VisitableMap;

public class BaseFluent<F> {
    public static final String VISIT = "visit";
    public final VisitableMap _visitables = new VisitableMap();

    public static <T> VisitableBuilder<T, ?> builderOf(T item) {
        Object editor;
        if (item instanceof Editable && (editor = ((Editable)item).edit()) instanceof VisitableBuilder) {
            return (VisitableBuilder)editor;
        }
        try {
            return (VisitableBuilder)Class.forName(item.getClass().getName() + "Builder", true, item.getClass().getClassLoader()).getConstructor(item.getClass()).newInstance(item);
        }
        catch (Exception e) {
            try {
                return (VisitableBuilder)Class.forName(item.getClass().getName() + "Builder").getConstructor(item.getClass()).newInstance(item);
            }
            catch (Exception e1) {
                throw new IllegalStateException("Failed to create builder for: " + String.valueOf(item.getClass()), e1);
            }
        }
    }

    public static <T> List<T> build(List<? extends Builder<? extends T>> list) {
        return list == null ? null : list.stream().map(Builder::build).collect(Collectors.toList());
    }

    public static <T> Set<T> build(Set<? extends Builder<? extends T>> set) {
        return set == null ? null : new LinkedHashSet(set.stream().map(Builder::build).collect(Collectors.toSet()));
    }

    public static <T> List<T> aggregate(List<? extends T> ... lists) {
        return new ArrayList(Arrays.stream(lists).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    public static <T> Set<T> aggregate(Set<? extends T> ... sets) {
        return new LinkedHashSet(Arrays.stream(sets).filter(Objects::nonNull).collect(Collectors.toSet()));
    }

    public Optional<VisitableMap> getVisitableMap() {
        return Optional.of(this._visitables);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + 0;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }
}

