/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.kubeclient.services;

import org.apache.flink.kubernetes.kubeclient.decorators.InternalServiceDecorator;
import org.apache.flink.kubernetes.kubeclient.parameters.KubernetesJobManagerParameters;
import org.apache.flink.kubernetes.kubeclient.services.ClusterIPService;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Service;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ServiceBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ServiceFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ServiceSpecFluent;

public class HeadlessClusterIPService
extends ClusterIPService {
    public static final HeadlessClusterIPService INSTANCE = new HeadlessClusterIPService();
    public static final String HEADLESS_CLUSTER_IP = "None";

    @Override
    public Service buildUpExternalRestService(KubernetesJobManagerParameters kubernetesJobManagerParameters) {
        Service service = super.buildUpExternalRestService(kubernetesJobManagerParameters);
        service.getSpec().setClusterIP(HEADLESS_CLUSTER_IP);
        return service;
    }

    @Override
    public Service buildUpInternalService(KubernetesJobManagerParameters kubernetesJobManagerParameters) {
        String serviceName = InternalServiceDecorator.getInternalServiceName(kubernetesJobManagerParameters.getClusterId());
        return ((ServiceBuilder)((ServiceFluent.SpecNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceFluent.SpecNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceBuilder)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)((ServiceBuilder)new ServiceBuilder().withApiVersion("v1")).withNewMetadata().withName(serviceName)).addToLabels(kubernetesJobManagerParameters.getCommonLabels())).addToLabels(kubernetesJobManagerParameters.getInternalServiceLabels())).withAnnotations(kubernetesJobManagerParameters.getInternalServiceAnnotations())).endMetadata()).withNewSpec().withClusterIP(HEADLESS_CLUSTER_IP)).withSelector(kubernetesJobManagerParameters.getSelectors())).addNewPort().withName("jobmanager-rpc")).withPort(kubernetesJobManagerParameters.getRPCPort())).endPort()).addNewPort().withName("blobserver")).withPort(kubernetesJobManagerParameters.getBlobServerPort())).endPort()).endSpec()).build();
    }
}

