/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.okhttp;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.KubernetesClientException;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.http.AsyncBody;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.http.HttpRequest;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.http.HttpResponse;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.http.StandardHttpClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.http.StandardHttpRequest;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.http.StandardWebSocketBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.http.WebSocket;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.http.WebSocketResponse;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.okhttp.OkHttpClientBuilderImpl;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.okhttp.OkHttpClientFactory;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.okhttp.OkHttpWebSocketImpl;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.utils.Utils;
import org.apache.flink.kubernetes.shaded.okhttp3.Call;
import org.apache.flink.kubernetes.shaded.okhttp3.Callback;
import org.apache.flink.kubernetes.shaded.okhttp3.ConnectionPool;
import org.apache.flink.kubernetes.shaded.okhttp3.Dispatcher;
import org.apache.flink.kubernetes.shaded.okhttp3.MediaType;
import org.apache.flink.kubernetes.shaded.okhttp3.OkHttpClient;
import org.apache.flink.kubernetes.shaded.okhttp3.Request;
import org.apache.flink.kubernetes.shaded.okhttp3.RequestBody;
import org.apache.flink.kubernetes.shaded.okhttp3.Response;
import org.apache.flink.kubernetes.shaded.okhttp3.ResponseBody;
import org.apache.flink.kubernetes.shaded.okhttp3.internal.http.HttpMethod;
import org.apache.flink.kubernetes.shaded.okio.Buffer;
import org.apache.flink.kubernetes.shaded.okio.BufferedSink;
import org.apache.flink.kubernetes.shaded.okio.BufferedSource;
import org.apache.flink.kubernetes.shaded.okio.Okio;
import org.apache.flink.kubernetes.shaded.okio.Source;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkHttpClientImpl
extends StandardHttpClient<OkHttpClientImpl, OkHttpClientFactory, OkHttpClientBuilderImpl> {
    static final transient Logger LOG = LoggerFactory.getLogger(OkHttpClientImpl.class);
    static final Map<String, MediaType> MEDIA_TYPES = new ConcurrentHashMap<String, MediaType>();
    public static final MediaType JSON = OkHttpClientImpl.parseMediaType("application/json");
    private final OkHttpClient httpClient;

    static MediaType parseMediaType(String contentType) {
        MediaType result = MediaType.parse(contentType);
        MEDIA_TYPES.put(contentType, result);
        return result;
    }

    public OkHttpClientImpl(OkHttpClient client, OkHttpClientBuilderImpl builder, AtomicBoolean closed) {
        super(builder, closed);
        this.httpClient = client;
    }

    @Override
    public void doClose() {
        ExecutorService executorService;
        ConnectionPool connectionPool = this.httpClient.connectionPool();
        Dispatcher dispatcher = this.httpClient.dispatcher();
        ExecutorService executorService2 = executorService = this.httpClient.dispatcher() != null ? this.httpClient.dispatcher().executorService() : null;
        if (dispatcher != null) {
            dispatcher.cancelAll();
        }
        if (connectionPool != null) {
            connectionPool.evictAll();
        }
        if (executorService != null) {
            executorService.shutdownNow();
        }
    }

    private CompletableFuture<HttpResponse<AsyncBody>> sendAsync(StandardHttpRequest request, final Function<BufferedSource, AsyncBody> handler) {
        final CompletableFuture<HttpResponse<AsyncBody>> future = new CompletableFuture<HttpResponse<AsyncBody>>();
        OkHttpClient.Builder clientBuilder = null;
        if (request.getTimeout() != null) {
            clientBuilder = this.httpClient.newBuilder();
            clientBuilder.callTimeout(request.getTimeout());
        }
        if (request.isForStreaming()) {
            if (clientBuilder == null) {
                clientBuilder = this.httpClient.newBuilder();
            }
            clientBuilder.cache(null);
        }
        Call call = Optional.ofNullable(clientBuilder).map(OkHttpClient.Builder::build).orElse(this.httpClient).newCall(this.requestBuilder(request).build());
        try {
            call.enqueue(new Callback(){

                @Override
                public void onResponse(Call call, Response response) {
                    BufferedSource source = response.body().source();
                    AsyncBody asyncBody = (AsyncBody)handler.apply(source);
                    future.complete(new OkHttpResponseImpl<AsyncBody>(response, asyncBody));
                }

                @Override
                public void onFailure(Call call, IOException e) {
                    Exception t = e;
                    if (e instanceof InterruptedIOException && e.getCause() instanceof RejectedExecutionException) {
                        t = OkHttpClientImpl.this.wrapRejected((RejectedExecutionException)e.getCause());
                    }
                    future.completeExceptionally(t);
                }
            });
        }
        catch (RejectedExecutionException e) {
            throw this.wrapRejected(e);
        }
        future.whenComplete((r, t) -> {
            if (future.isCancelled()) {
                call.cancel();
            }
        });
        return future;
    }

    private KubernetesClientException wrapRejected(RejectedExecutionException e) {
        return new KubernetesClientException("The okhttp client executor has been shutdown.  More than likely this is because the KubernetesClient.close method (see debug logging) has been called - please ensure that is intentional. Dispatcher: " + String.valueOf(this.httpClient.dispatcher()), e);
    }

    public OkHttpClient getOkHttpClient() {
        return this.httpClient;
    }

    private Request.Builder newRequestBuilder() {
        return new Request.Builder();
    }

    @Override
    public CompletableFuture<HttpResponse<AsyncBody>> consumeBytesDirect(StandardHttpRequest request, AsyncBody.Consumer<List<ByteBuffer>> consumer) {
        Function<BufferedSource, AsyncBody> handler = s -> new OkHttpAsyncBody<List<ByteBuffer>>(consumer, s, (Executor)this.httpClient.dispatcher().executorService()){

            @Override
            protected List<ByteBuffer> process(BufferedSource source) throws IOException {
                return Collections.singletonList(ByteBuffer.wrap(source.readByteArray(source.buffer().size())));
            }
        };
        return this.sendAsync(request, handler);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Request.Builder requestBuilder(StandardHttpRequest request) {
        Request.Builder requestBuilder = this.newRequestBuilder();
        StandardHttpRequest.BodyContent body = request.body();
        if (body != null) {
            final String contentType = request.getContentType();
            if (body instanceof StandardHttpRequest.StringBodyContent) {
                requestBuilder.method(request.method(), RequestBody.create(OkHttpClientImpl.parseMediaType(contentType), ((StandardHttpRequest.StringBodyContent)body).getContent()));
            } else if (body instanceof StandardHttpRequest.ByteArrayBodyContent) {
                requestBuilder.method(request.method(), RequestBody.create(OkHttpClientImpl.parseMediaType(contentType), ((StandardHttpRequest.ByteArrayBodyContent)body).getContent()));
            } else {
                if (!(body instanceof StandardHttpRequest.InputStreamBodyContent)) throw new AssertionError((Object)"Unsupported body content");
                final StandardHttpRequest.InputStreamBodyContent bodyContent = (StandardHttpRequest.InputStreamBodyContent)body;
                requestBuilder.method(request.method(), new RequestBody(){

                    @Override
                    public void writeTo(BufferedSink sink) throws IOException {
                        try (BufferedInputStream bis = new BufferedInputStream(bodyContent.getContent());
                             Source source = Okio.source(bis);){
                            sink.writeAll(source);
                        }
                    }

                    @Override
                    public MediaType contentType() {
                        return OkHttpClientImpl.parseMediaType(contentType);
                    }

                    @Override
                    public long contentLength() {
                        return bodyContent.getLength();
                    }
                });
            }
        } else if (Utils.isNotNullOrEmpty(request.method())) {
            requestBuilder.method(request.method(), HttpMethod.requiresRequestBody(request.method()) ? RequestBody.create(null, new byte[0]) : null);
        }
        request.headers().entrySet().stream().forEach(e -> ((List)e.getValue()).stream().forEach(v -> requestBuilder.addHeader((String)e.getKey(), (String)v)));
        try {
            requestBuilder.url(request.uri().toURL());
        }
        catch (MalformedURLException e2) {
            throw new IllegalArgumentException(request.uri().toString(), e2);
        }
        if (!request.isExpectContinue()) return requestBuilder;
        requestBuilder.header("Expect", "100-continue");
        return requestBuilder;
    }

    @Override
    public CompletableFuture<WebSocketResponse> buildWebSocketDirect(StandardWebSocketBuilder standardWebSocketBuilder, WebSocket.Listener listener) {
        StandardHttpRequest fabric8Request = standardWebSocketBuilder.asHttpRequest();
        Request.Builder requestBuilder = this.requestBuilder(fabric8Request);
        if (standardWebSocketBuilder.getSubprotocol() != null) {
            requestBuilder.header("Sec-WebSocket-Protocol", standardWebSocketBuilder.getSubprotocol());
        }
        return OkHttpWebSocketImpl.buildAsync(this.httpClient, fabric8Request, requestBuilder.build(), listener);
    }

    static class OkHttpResponseImpl<T>
    implements HttpResponse<T> {
        private final Response response;
        private T body;
        private Class<T> type;

        public OkHttpResponseImpl(Response response, T body) {
            this.response = response;
            this.body = body;
        }

        public OkHttpResponseImpl(Response response, Class<T> type) throws IOException {
            this.response = response;
            this.type = type;
            ResponseBody responseBody = response.body();
            if (responseBody != null) {
                if (type == null) {
                    responseBody.close();
                } else {
                    this.body = type == String.class ? responseBody.string() : (type == Reader.class ? responseBody.charStream() : (type == byte[].class ? (T)responseBody.bytes() : responseBody.byteStream()));
                }
            }
        }

        @Override
        public int code() {
            return this.response.code();
        }

        @Override
        public T body() {
            return this.body;
        }

        @Override
        public HttpRequest request() {
            String bodyString = null;
            Request request = this.response.request();
            if (request.body() != null) {
                Buffer buffer = new Buffer();
                try {
                    request.body().writeTo(buffer);
                    bodyString = buffer.readUtf8();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return new StandardHttpRequest(request.headers().toMultimap(), request.url().uri(), request.method(), bodyString);
        }

        @Override
        public Optional<HttpResponse<?>> previousResponse() {
            Response previous = this.response.priorResponse() != null ? this.response.priorResponse() : this.response;
            previous = previous.networkResponse() != null ? previous.networkResponse() : previous;
            try {
                return Optional.ofNullable(previous == this.response ? null : new OkHttpResponseImpl<T>(previous, this.type));
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }

        @Override
        public List<String> headers(String key) {
            return this.response.headers(key);
        }

        @Override
        public Map<String, List<String>> headers() {
            return this.response.headers().toMultimap();
        }
    }

    static abstract class OkHttpAsyncBody<T>
    implements AsyncBody {
        private final AsyncBody.Consumer<T> consumer;
        private final BufferedSource source;
        private final CompletableFuture<Void> done = new CompletableFuture();
        private boolean consuming;
        private boolean requested;
        private final Executor executor;

        OkHttpAsyncBody(AsyncBody.Consumer<T> consumer, BufferedSource source, Executor executor) {
            this.consumer = consumer;
            this.source = source;
            this.executor = executor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void consume() {
            OkHttpAsyncBody okHttpAsyncBody = this;
            synchronized (okHttpAsyncBody) {
                this.requested = true;
                if (this.consuming) {
                    return;
                }
                this.consuming = true;
            }
            try {
                this.executor.execute(this::doConsume);
            }
            catch (Exception e) {
                Utils.closeQuietly(this.source);
                this.done.completeExceptionally(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doConsume() {
            try {
                while (true) {
                    OkHttpAsyncBody okHttpAsyncBody = this;
                    synchronized (okHttpAsyncBody) {
                        if (!this.requested || this.done.isDone()) {
                            this.consuming = false;
                            return;
                        }
                        this.requested = false;
                    }
                    if (!this.source.exhausted()) {
                        T value = this.process(this.source);
                        this.consumer.consume(value, this);
                        continue;
                    }
                    this.source.close();
                    this.done.complete(null);
                }
            }
            catch (Exception e) {
                Utils.closeQuietly(this.source);
                this.done.completeExceptionally(e);
                return;
            }
        }

        @Override
        public CompletableFuture<Void> done() {
            return this.done;
        }

        protected abstract T process(BufferedSource var1) throws IOException;

        @Override
        public void cancel() {
            this.executor.execute(() -> Utils.closeQuietly(this.source));
            this.done.cancel(false);
        }
    }
}

