/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.admissionregistration.v1;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.BaseFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.Nested;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.LabelSelector;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.admissionregistration.v1.MatchCondition;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.admissionregistration.v1.MatchConditionBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.admissionregistration.v1.MatchConditionFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.admissionregistration.v1.RuleWithOperations;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.admissionregistration.v1.RuleWithOperationsBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.admissionregistration.v1.RuleWithOperationsFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.admissionregistration.v1.ValidatingWebhook;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.admissionregistration.v1.WebhookClientConfig;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.admissionregistration.v1.WebhookClientConfigBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.admissionregistration.v1.WebhookClientConfigFluent;

public class ValidatingWebhookFluent<A extends ValidatingWebhookFluent<A>>
extends BaseFluent<A> {
    private List<String> admissionReviewVersions = new ArrayList<String>();
    private WebhookClientConfigBuilder clientConfig;
    private String failurePolicy;
    private ArrayList<MatchConditionBuilder> matchConditions = new ArrayList();
    private String matchPolicy;
    private String name;
    private LabelSelectorBuilder namespaceSelector;
    private LabelSelectorBuilder objectSelector;
    private ArrayList<RuleWithOperationsBuilder> rules = new ArrayList();
    private String sideEffects;
    private Integer timeoutSeconds;
    private Map<String, Object> additionalProperties;

    public ValidatingWebhookFluent() {
    }

    public ValidatingWebhookFluent(ValidatingWebhook instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ValidatingWebhook instance) {
        ValidatingWebhook validatingWebhook = instance = instance != null ? instance : new ValidatingWebhook();
        if (instance != null) {
            this.withAdmissionReviewVersions(instance.getAdmissionReviewVersions());
            this.withClientConfig(instance.getClientConfig());
            this.withFailurePolicy(instance.getFailurePolicy());
            this.withMatchConditions(instance.getMatchConditions());
            this.withMatchPolicy(instance.getMatchPolicy());
            this.withName(instance.getName());
            this.withNamespaceSelector(instance.getNamespaceSelector());
            this.withObjectSelector(instance.getObjectSelector());
            this.withRules(instance.getRules());
            this.withSideEffects(instance.getSideEffects());
            this.withTimeoutSeconds(instance.getTimeoutSeconds());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToAdmissionReviewVersions(int index, String item) {
        if (this.admissionReviewVersions == null) {
            this.admissionReviewVersions = new ArrayList<String>();
        }
        this.admissionReviewVersions.add(index, item);
        return (A)this;
    }

    public A setToAdmissionReviewVersions(int index, String item) {
        if (this.admissionReviewVersions == null) {
            this.admissionReviewVersions = new ArrayList<String>();
        }
        this.admissionReviewVersions.set(index, item);
        return (A)this;
    }

    public A addToAdmissionReviewVersions(String ... items) {
        if (this.admissionReviewVersions == null) {
            this.admissionReviewVersions = new ArrayList<String>();
        }
        for (String item : items) {
            this.admissionReviewVersions.add(item);
        }
        return (A)this;
    }

    public A addAllToAdmissionReviewVersions(Collection<String> items) {
        if (this.admissionReviewVersions == null) {
            this.admissionReviewVersions = new ArrayList<String>();
        }
        for (String item : items) {
            this.admissionReviewVersions.add(item);
        }
        return (A)this;
    }

    public A removeFromAdmissionReviewVersions(String ... items) {
        if (this.admissionReviewVersions == null) {
            return (A)this;
        }
        for (String item : items) {
            this.admissionReviewVersions.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromAdmissionReviewVersions(Collection<String> items) {
        if (this.admissionReviewVersions == null) {
            return (A)this;
        }
        for (String item : items) {
            this.admissionReviewVersions.remove(item);
        }
        return (A)this;
    }

    public List<String> getAdmissionReviewVersions() {
        return this.admissionReviewVersions;
    }

    public String getAdmissionReviewVersion(int index) {
        return this.admissionReviewVersions.get(index);
    }

    public String getFirstAdmissionReviewVersion() {
        return this.admissionReviewVersions.get(0);
    }

    public String getLastAdmissionReviewVersion() {
        return this.admissionReviewVersions.get(this.admissionReviewVersions.size() - 1);
    }

    public String getMatchingAdmissionReviewVersion(Predicate<String> predicate) {
        for (String item : this.admissionReviewVersions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingAdmissionReviewVersion(Predicate<String> predicate) {
        for (String item : this.admissionReviewVersions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withAdmissionReviewVersions(List<String> admissionReviewVersions) {
        if (admissionReviewVersions != null) {
            this.admissionReviewVersions = new ArrayList<String>();
            for (String item : admissionReviewVersions) {
                this.addToAdmissionReviewVersions(item);
            }
        } else {
            this.admissionReviewVersions = null;
        }
        return (A)this;
    }

    public A withAdmissionReviewVersions(String ... admissionReviewVersions) {
        if (this.admissionReviewVersions != null) {
            this.admissionReviewVersions.clear();
            this._visitables.remove("admissionReviewVersions");
        }
        if (admissionReviewVersions != null) {
            for (String item : admissionReviewVersions) {
                this.addToAdmissionReviewVersions(item);
            }
        }
        return (A)this;
    }

    public boolean hasAdmissionReviewVersions() {
        return this.admissionReviewVersions != null && !this.admissionReviewVersions.isEmpty();
    }

    public WebhookClientConfig buildClientConfig() {
        return this.clientConfig != null ? this.clientConfig.build() : null;
    }

    public A withClientConfig(WebhookClientConfig clientConfig) {
        this._visitables.remove("clientConfig");
        if (clientConfig != null) {
            this.clientConfig = new WebhookClientConfigBuilder(clientConfig);
            this._visitables.get("clientConfig").add(this.clientConfig);
        } else {
            this.clientConfig = null;
            this._visitables.get("clientConfig").remove(this.clientConfig);
        }
        return (A)this;
    }

    public boolean hasClientConfig() {
        return this.clientConfig != null;
    }

    public ClientConfigNested<A> withNewClientConfig() {
        return new ClientConfigNested(null);
    }

    public ClientConfigNested<A> withNewClientConfigLike(WebhookClientConfig item) {
        return new ClientConfigNested(item);
    }

    public ClientConfigNested<A> editClientConfig() {
        return this.withNewClientConfigLike(Optional.ofNullable(this.buildClientConfig()).orElse(null));
    }

    public ClientConfigNested<A> editOrNewClientConfig() {
        return this.withNewClientConfigLike(Optional.ofNullable(this.buildClientConfig()).orElse(new WebhookClientConfigBuilder().build()));
    }

    public ClientConfigNested<A> editOrNewClientConfigLike(WebhookClientConfig item) {
        return this.withNewClientConfigLike(Optional.ofNullable(this.buildClientConfig()).orElse(item));
    }

    public String getFailurePolicy() {
        return this.failurePolicy;
    }

    public A withFailurePolicy(String failurePolicy) {
        this.failurePolicy = failurePolicy;
        return (A)this;
    }

    public boolean hasFailurePolicy() {
        return this.failurePolicy != null;
    }

    public A addToMatchConditions(int index, MatchCondition item) {
        if (this.matchConditions == null) {
            this.matchConditions = new ArrayList();
        }
        MatchConditionBuilder builder = new MatchConditionBuilder(item);
        if (index < 0 || index >= this.matchConditions.size()) {
            this._visitables.get("matchConditions").add(builder);
            this.matchConditions.add(builder);
        } else {
            this._visitables.get("matchConditions").add(builder);
            this.matchConditions.add(index, builder);
        }
        return (A)this;
    }

    public A setToMatchConditions(int index, MatchCondition item) {
        if (this.matchConditions == null) {
            this.matchConditions = new ArrayList();
        }
        MatchConditionBuilder builder = new MatchConditionBuilder(item);
        if (index < 0 || index >= this.matchConditions.size()) {
            this._visitables.get("matchConditions").add(builder);
            this.matchConditions.add(builder);
        } else {
            this._visitables.get("matchConditions").add(builder);
            this.matchConditions.set(index, builder);
        }
        return (A)this;
    }

    public A addToMatchConditions(MatchCondition ... items) {
        if (this.matchConditions == null) {
            this.matchConditions = new ArrayList();
        }
        for (MatchCondition item : items) {
            MatchConditionBuilder builder = new MatchConditionBuilder(item);
            this._visitables.get("matchConditions").add(builder);
            this.matchConditions.add(builder);
        }
        return (A)this;
    }

    public A addAllToMatchConditions(Collection<MatchCondition> items) {
        if (this.matchConditions == null) {
            this.matchConditions = new ArrayList();
        }
        for (MatchCondition item : items) {
            MatchConditionBuilder builder = new MatchConditionBuilder(item);
            this._visitables.get("matchConditions").add(builder);
            this.matchConditions.add(builder);
        }
        return (A)this;
    }

    public A removeFromMatchConditions(MatchCondition ... items) {
        if (this.matchConditions == null) {
            return (A)this;
        }
        for (MatchCondition item : items) {
            MatchConditionBuilder builder = new MatchConditionBuilder(item);
            this._visitables.get("matchConditions").remove(builder);
            this.matchConditions.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromMatchConditions(Collection<MatchCondition> items) {
        if (this.matchConditions == null) {
            return (A)this;
        }
        for (MatchCondition item : items) {
            MatchConditionBuilder builder = new MatchConditionBuilder(item);
            this._visitables.get("matchConditions").remove(builder);
            this.matchConditions.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromMatchConditions(Predicate<MatchConditionBuilder> predicate) {
        if (this.matchConditions == null) {
            return (A)this;
        }
        Iterator<MatchConditionBuilder> each = this.matchConditions.iterator();
        Object visitables = this._visitables.get("matchConditions");
        while (each.hasNext()) {
            MatchConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<MatchCondition> buildMatchConditions() {
        return this.matchConditions != null ? ValidatingWebhookFluent.build(this.matchConditions) : null;
    }

    public MatchCondition buildMatchCondition(int index) {
        return this.matchConditions.get(index).build();
    }

    public MatchCondition buildFirstMatchCondition() {
        return this.matchConditions.get(0).build();
    }

    public MatchCondition buildLastMatchCondition() {
        return this.matchConditions.get(this.matchConditions.size() - 1).build();
    }

    public MatchCondition buildMatchingMatchCondition(Predicate<MatchConditionBuilder> predicate) {
        for (MatchConditionBuilder item : this.matchConditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingMatchCondition(Predicate<MatchConditionBuilder> predicate) {
        for (MatchConditionBuilder item : this.matchConditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withMatchConditions(List<MatchCondition> matchConditions) {
        if (this.matchConditions != null) {
            this._visitables.get("matchConditions").clear();
        }
        if (matchConditions != null) {
            this.matchConditions = new ArrayList();
            for (MatchCondition item : matchConditions) {
                this.addToMatchConditions(item);
            }
        } else {
            this.matchConditions = null;
        }
        return (A)this;
    }

    public A withMatchConditions(MatchCondition ... matchConditions) {
        if (this.matchConditions != null) {
            this.matchConditions.clear();
            this._visitables.remove("matchConditions");
        }
        if (matchConditions != null) {
            for (MatchCondition item : matchConditions) {
                this.addToMatchConditions(item);
            }
        }
        return (A)this;
    }

    public boolean hasMatchConditions() {
        return this.matchConditions != null && !this.matchConditions.isEmpty();
    }

    public A addNewMatchCondition(String expression, String name) {
        return this.addToMatchConditions(new MatchCondition(expression, name));
    }

    public MatchConditionsNested<A> addNewMatchCondition() {
        return new MatchConditionsNested(-1, null);
    }

    public MatchConditionsNested<A> addNewMatchConditionLike(MatchCondition item) {
        return new MatchConditionsNested(-1, item);
    }

    public MatchConditionsNested<A> setNewMatchConditionLike(int index, MatchCondition item) {
        return new MatchConditionsNested(index, item);
    }

    public MatchConditionsNested<A> editMatchCondition(int index) {
        if (this.matchConditions.size() <= index) {
            throw new RuntimeException("Can't edit matchConditions. Index exceeds size.");
        }
        return this.setNewMatchConditionLike(index, this.buildMatchCondition(index));
    }

    public MatchConditionsNested<A> editFirstMatchCondition() {
        if (this.matchConditions.size() == 0) {
            throw new RuntimeException("Can't edit first matchConditions. The list is empty.");
        }
        return this.setNewMatchConditionLike(0, this.buildMatchCondition(0));
    }

    public MatchConditionsNested<A> editLastMatchCondition() {
        int index = this.matchConditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last matchConditions. The list is empty.");
        }
        return this.setNewMatchConditionLike(index, this.buildMatchCondition(index));
    }

    public MatchConditionsNested<A> editMatchingMatchCondition(Predicate<MatchConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.matchConditions.size(); ++i) {
            if (!predicate.test(this.matchConditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching matchConditions. No match found.");
        }
        return this.setNewMatchConditionLike(index, this.buildMatchCondition(index));
    }

    public String getMatchPolicy() {
        return this.matchPolicy;
    }

    public A withMatchPolicy(String matchPolicy) {
        this.matchPolicy = matchPolicy;
        return (A)this;
    }

    public boolean hasMatchPolicy() {
        return this.matchPolicy != null;
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public LabelSelector buildNamespaceSelector() {
        return this.namespaceSelector != null ? this.namespaceSelector.build() : null;
    }

    public A withNamespaceSelector(LabelSelector namespaceSelector) {
        this._visitables.remove("namespaceSelector");
        if (namespaceSelector != null) {
            this.namespaceSelector = new LabelSelectorBuilder(namespaceSelector);
            this._visitables.get("namespaceSelector").add(this.namespaceSelector);
        } else {
            this.namespaceSelector = null;
            this._visitables.get("namespaceSelector").remove(this.namespaceSelector);
        }
        return (A)this;
    }

    public boolean hasNamespaceSelector() {
        return this.namespaceSelector != null;
    }

    public NamespaceSelectorNested<A> withNewNamespaceSelector() {
        return new NamespaceSelectorNested(null);
    }

    public NamespaceSelectorNested<A> withNewNamespaceSelectorLike(LabelSelector item) {
        return new NamespaceSelectorNested(item);
    }

    public NamespaceSelectorNested<A> editNamespaceSelector() {
        return this.withNewNamespaceSelectorLike(Optional.ofNullable(this.buildNamespaceSelector()).orElse(null));
    }

    public NamespaceSelectorNested<A> editOrNewNamespaceSelector() {
        return this.withNewNamespaceSelectorLike(Optional.ofNullable(this.buildNamespaceSelector()).orElse(new LabelSelectorBuilder().build()));
    }

    public NamespaceSelectorNested<A> editOrNewNamespaceSelectorLike(LabelSelector item) {
        return this.withNewNamespaceSelectorLike(Optional.ofNullable(this.buildNamespaceSelector()).orElse(item));
    }

    public LabelSelector buildObjectSelector() {
        return this.objectSelector != null ? this.objectSelector.build() : null;
    }

    public A withObjectSelector(LabelSelector objectSelector) {
        this._visitables.remove("objectSelector");
        if (objectSelector != null) {
            this.objectSelector = new LabelSelectorBuilder(objectSelector);
            this._visitables.get("objectSelector").add(this.objectSelector);
        } else {
            this.objectSelector = null;
            this._visitables.get("objectSelector").remove(this.objectSelector);
        }
        return (A)this;
    }

    public boolean hasObjectSelector() {
        return this.objectSelector != null;
    }

    public ObjectSelectorNested<A> withNewObjectSelector() {
        return new ObjectSelectorNested(null);
    }

    public ObjectSelectorNested<A> withNewObjectSelectorLike(LabelSelector item) {
        return new ObjectSelectorNested(item);
    }

    public ObjectSelectorNested<A> editObjectSelector() {
        return this.withNewObjectSelectorLike(Optional.ofNullable(this.buildObjectSelector()).orElse(null));
    }

    public ObjectSelectorNested<A> editOrNewObjectSelector() {
        return this.withNewObjectSelectorLike(Optional.ofNullable(this.buildObjectSelector()).orElse(new LabelSelectorBuilder().build()));
    }

    public ObjectSelectorNested<A> editOrNewObjectSelectorLike(LabelSelector item) {
        return this.withNewObjectSelectorLike(Optional.ofNullable(this.buildObjectSelector()).orElse(item));
    }

    public A addToRules(int index, RuleWithOperations item) {
        if (this.rules == null) {
            this.rules = new ArrayList();
        }
        RuleWithOperationsBuilder builder = new RuleWithOperationsBuilder(item);
        if (index < 0 || index >= this.rules.size()) {
            this._visitables.get("rules").add(builder);
            this.rules.add(builder);
        } else {
            this._visitables.get("rules").add(builder);
            this.rules.add(index, builder);
        }
        return (A)this;
    }

    public A setToRules(int index, RuleWithOperations item) {
        if (this.rules == null) {
            this.rules = new ArrayList();
        }
        RuleWithOperationsBuilder builder = new RuleWithOperationsBuilder(item);
        if (index < 0 || index >= this.rules.size()) {
            this._visitables.get("rules").add(builder);
            this.rules.add(builder);
        } else {
            this._visitables.get("rules").add(builder);
            this.rules.set(index, builder);
        }
        return (A)this;
    }

    public A addToRules(RuleWithOperations ... items) {
        if (this.rules == null) {
            this.rules = new ArrayList();
        }
        for (RuleWithOperations item : items) {
            RuleWithOperationsBuilder builder = new RuleWithOperationsBuilder(item);
            this._visitables.get("rules").add(builder);
            this.rules.add(builder);
        }
        return (A)this;
    }

    public A addAllToRules(Collection<RuleWithOperations> items) {
        if (this.rules == null) {
            this.rules = new ArrayList();
        }
        for (RuleWithOperations item : items) {
            RuleWithOperationsBuilder builder = new RuleWithOperationsBuilder(item);
            this._visitables.get("rules").add(builder);
            this.rules.add(builder);
        }
        return (A)this;
    }

    public A removeFromRules(RuleWithOperations ... items) {
        if (this.rules == null) {
            return (A)this;
        }
        for (RuleWithOperations item : items) {
            RuleWithOperationsBuilder builder = new RuleWithOperationsBuilder(item);
            this._visitables.get("rules").remove(builder);
            this.rules.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromRules(Collection<RuleWithOperations> items) {
        if (this.rules == null) {
            return (A)this;
        }
        for (RuleWithOperations item : items) {
            RuleWithOperationsBuilder builder = new RuleWithOperationsBuilder(item);
            this._visitables.get("rules").remove(builder);
            this.rules.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromRules(Predicate<RuleWithOperationsBuilder> predicate) {
        if (this.rules == null) {
            return (A)this;
        }
        Iterator<RuleWithOperationsBuilder> each = this.rules.iterator();
        Object visitables = this._visitables.get("rules");
        while (each.hasNext()) {
            RuleWithOperationsBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<RuleWithOperations> buildRules() {
        return this.rules != null ? ValidatingWebhookFluent.build(this.rules) : null;
    }

    public RuleWithOperations buildRule(int index) {
        return this.rules.get(index).build();
    }

    public RuleWithOperations buildFirstRule() {
        return this.rules.get(0).build();
    }

    public RuleWithOperations buildLastRule() {
        return this.rules.get(this.rules.size() - 1).build();
    }

    public RuleWithOperations buildMatchingRule(Predicate<RuleWithOperationsBuilder> predicate) {
        for (RuleWithOperationsBuilder item : this.rules) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingRule(Predicate<RuleWithOperationsBuilder> predicate) {
        for (RuleWithOperationsBuilder item : this.rules) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withRules(List<RuleWithOperations> rules) {
        if (this.rules != null) {
            this._visitables.get("rules").clear();
        }
        if (rules != null) {
            this.rules = new ArrayList();
            for (RuleWithOperations item : rules) {
                this.addToRules(item);
            }
        } else {
            this.rules = null;
        }
        return (A)this;
    }

    public A withRules(RuleWithOperations ... rules) {
        if (this.rules != null) {
            this.rules.clear();
            this._visitables.remove("rules");
        }
        if (rules != null) {
            for (RuleWithOperations item : rules) {
                this.addToRules(item);
            }
        }
        return (A)this;
    }

    public boolean hasRules() {
        return this.rules != null && !this.rules.isEmpty();
    }

    public RulesNested<A> addNewRule() {
        return new RulesNested(-1, null);
    }

    public RulesNested<A> addNewRuleLike(RuleWithOperations item) {
        return new RulesNested(-1, item);
    }

    public RulesNested<A> setNewRuleLike(int index, RuleWithOperations item) {
        return new RulesNested(index, item);
    }

    public RulesNested<A> editRule(int index) {
        if (this.rules.size() <= index) {
            throw new RuntimeException("Can't edit rules. Index exceeds size.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    public RulesNested<A> editFirstRule() {
        if (this.rules.size() == 0) {
            throw new RuntimeException("Can't edit first rules. The list is empty.");
        }
        return this.setNewRuleLike(0, this.buildRule(0));
    }

    public RulesNested<A> editLastRule() {
        int index = this.rules.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last rules. The list is empty.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    public RulesNested<A> editMatchingRule(Predicate<RuleWithOperationsBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.rules.size(); ++i) {
            if (!predicate.test(this.rules.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching rules. No match found.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    public String getSideEffects() {
        return this.sideEffects;
    }

    public A withSideEffects(String sideEffects) {
        this.sideEffects = sideEffects;
        return (A)this;
    }

    public boolean hasSideEffects() {
        return this.sideEffects != null;
    }

    public Integer getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    public A withTimeoutSeconds(Integer timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
        return (A)this;
    }

    public boolean hasTimeoutSeconds() {
        return this.timeoutSeconds != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ValidatingWebhookFluent that = (ValidatingWebhookFluent)o;
        if (!Objects.equals(this.admissionReviewVersions, that.admissionReviewVersions)) {
            return false;
        }
        if (!Objects.equals(this.clientConfig, that.clientConfig)) {
            return false;
        }
        if (!Objects.equals(this.failurePolicy, that.failurePolicy)) {
            return false;
        }
        if (!Objects.equals(this.matchConditions, that.matchConditions)) {
            return false;
        }
        if (!Objects.equals(this.matchPolicy, that.matchPolicy)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.namespaceSelector, that.namespaceSelector)) {
            return false;
        }
        if (!Objects.equals(this.objectSelector, that.objectSelector)) {
            return false;
        }
        if (!Objects.equals(this.rules, that.rules)) {
            return false;
        }
        if (!Objects.equals(this.sideEffects, that.sideEffects)) {
            return false;
        }
        if (!Objects.equals(this.timeoutSeconds, that.timeoutSeconds)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.admissionReviewVersions, this.clientConfig, this.failurePolicy, this.matchConditions, this.matchPolicy, this.name, this.namespaceSelector, this.objectSelector, this.rules, this.sideEffects, this.timeoutSeconds, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.admissionReviewVersions != null && !this.admissionReviewVersions.isEmpty()) {
            sb.append("admissionReviewVersions:");
            sb.append(String.valueOf(this.admissionReviewVersions) + ",");
        }
        if (this.clientConfig != null) {
            sb.append("clientConfig:");
            sb.append(String.valueOf(this.clientConfig) + ",");
        }
        if (this.failurePolicy != null) {
            sb.append("failurePolicy:");
            sb.append(this.failurePolicy + ",");
        }
        if (this.matchConditions != null && !this.matchConditions.isEmpty()) {
            sb.append("matchConditions:");
            sb.append(String.valueOf(this.matchConditions) + ",");
        }
        if (this.matchPolicy != null) {
            sb.append("matchPolicy:");
            sb.append(this.matchPolicy + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.namespaceSelector != null) {
            sb.append("namespaceSelector:");
            sb.append(String.valueOf(this.namespaceSelector) + ",");
        }
        if (this.objectSelector != null) {
            sb.append("objectSelector:");
            sb.append(String.valueOf(this.objectSelector) + ",");
        }
        if (this.rules != null && !this.rules.isEmpty()) {
            sb.append("rules:");
            sb.append(String.valueOf(this.rules) + ",");
        }
        if (this.sideEffects != null) {
            sb.append("sideEffects:");
            sb.append(this.sideEffects + ",");
        }
        if (this.timeoutSeconds != null) {
            sb.append("timeoutSeconds:");
            sb.append(this.timeoutSeconds + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class RulesNested<N>
    extends RuleWithOperationsFluent<RulesNested<N>>
    implements Nested<N> {
        RuleWithOperationsBuilder builder;
        int index;

        RulesNested(int index, RuleWithOperations item) {
            this.index = index;
            this.builder = new RuleWithOperationsBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ValidatingWebhookFluent.this.setToRules(this.index, this.builder.build());
        }

        public N endRule() {
            return this.and();
        }
    }

    public class ObjectSelectorNested<N>
    extends LabelSelectorFluent<ObjectSelectorNested<N>>
    implements Nested<N> {
        LabelSelectorBuilder builder;

        ObjectSelectorNested(LabelSelector item) {
            this.builder = new LabelSelectorBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ValidatingWebhookFluent.this.withObjectSelector(this.builder.build());
        }

        public N endObjectSelector() {
            return this.and();
        }
    }

    public class NamespaceSelectorNested<N>
    extends LabelSelectorFluent<NamespaceSelectorNested<N>>
    implements Nested<N> {
        LabelSelectorBuilder builder;

        NamespaceSelectorNested(LabelSelector item) {
            this.builder = new LabelSelectorBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ValidatingWebhookFluent.this.withNamespaceSelector(this.builder.build());
        }

        public N endNamespaceSelector() {
            return this.and();
        }
    }

    public class MatchConditionsNested<N>
    extends MatchConditionFluent<MatchConditionsNested<N>>
    implements Nested<N> {
        MatchConditionBuilder builder;
        int index;

        MatchConditionsNested(int index, MatchCondition item) {
            this.index = index;
            this.builder = new MatchConditionBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ValidatingWebhookFluent.this.setToMatchConditions(this.index, this.builder.build());
        }

        public N endMatchCondition() {
            return this.and();
        }
    }

    public class ClientConfigNested<N>
    extends WebhookClientConfigFluent<ClientConfigNested<N>>
    implements Nested<N> {
        WebhookClientConfigBuilder builder;

        ClientConfigNested(WebhookClientConfig item) {
            this.builder = new WebhookClientConfigBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ValidatingWebhookFluent.this.withClientConfig(this.builder.build());
        }

        public N endClientConfig() {
            return this.and();
        }
    }
}

