/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.fs.hdfs;

import java.net.URI;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ConfigurationUtils;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.LimitedConnectionsFileSystem;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class LimitedConnectionsConfigurationTest {
    LimitedConnectionsConfigurationTest() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testConfiguration() throws Exception {
        FileSystem hdfs = FileSystem.get((URI)URI.create("hdfs://localhost:12345/a/b/c"));
        FileSystem ftpfs = FileSystem.get((URI)URI.create("ftp://localhost:12345/a/b/c"));
        Assertions.assertThat((Object)hdfs).isNotInstanceOf(LimitedConnectionsFileSystem.class);
        Assertions.assertThat((Object)ftpfs).isNotInstanceOf(LimitedConnectionsFileSystem.class);
        Configuration config = new Configuration();
        config.set(ConfigurationUtils.getIntConfigOption((String)"fs.hdfs.limit.total"), (Object)40);
        config.set(ConfigurationUtils.getIntConfigOption((String)"fs.hdfs.limit.input"), (Object)39);
        config.set(ConfigurationUtils.getIntConfigOption((String)"fs.hdfs.limit.output"), (Object)38);
        config.set(ConfigurationUtils.getIntConfigOption((String)"fs.hdfs.limit.timeout"), (Object)23456);
        config.set(ConfigurationUtils.getIntConfigOption((String)"fs.hdfs.limit.stream-timeout"), (Object)34567);
        try {
            FileSystem.initialize((Configuration)config);
            hdfs = FileSystem.get((URI)URI.create("hdfs://localhost:12345/a/b/c"));
            ftpfs = FileSystem.get((URI)URI.create("ftp://localhost:12345/a/b/c"));
            Assertions.assertThat((Object)hdfs).isInstanceOf(LimitedConnectionsFileSystem.class);
            Assertions.assertThat((Object)ftpfs).isNotInstanceOf(LimitedConnectionsFileSystem.class);
            LimitedConnectionsFileSystem limitedFs = (LimitedConnectionsFileSystem)hdfs;
            Assertions.assertThat((int)limitedFs.getMaxNumOpenStreamsTotal()).isEqualTo(40);
            Assertions.assertThat((int)limitedFs.getMaxNumOpenInputStreams()).isEqualTo(39);
            Assertions.assertThat((int)limitedFs.getMaxNumOpenOutputStreams()).isEqualTo(38);
            Assertions.assertThat((long)limitedFs.getStreamOpenTimeout()).isEqualTo(23456L);
            Assertions.assertThat((long)limitedFs.getStreamInactivityTimeout()).isEqualTo(34567L);
        }
        finally {
            FileSystem.initialize((Configuration)new Configuration());
        }
    }
}

