/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.fs.hdfs;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.runtime.util.HadoopUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class HadoopConfigLoadingTest {
    private static final String IN_CP_CONFIG_KEY = "cp_conf_key";
    private static final String IN_CP_CONFIG_VALUE = "oompf!";

    HadoopConfigLoadingTest() {
    }

    @Test
    void loadFromClasspathByDefault() {
        org.apache.hadoop.conf.Configuration hadoopConf = HadoopUtils.getHadoopConfiguration((Configuration)new Configuration());
        Assertions.assertThat((String)hadoopConf.get(IN_CP_CONFIG_KEY, null)).isEqualTo(IN_CP_CONFIG_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void loadFromEnvVariables(@TempDir File hadoopConfDir, @TempDir File hadoopHome) throws Exception {
        org.apache.hadoop.conf.Configuration hadoopConf;
        String k1 = "where?";
        String v1 = "I'm on a boat";
        String k2 = "when?";
        String v2 = "midnight";
        String k3 = "why?";
        String v3 = "what do you think?";
        String k4 = "which way?";
        String v4 = "south, always south...";
        String k5 = "how long?";
        String v5 = "an eternity";
        String k6 = "for real?";
        String v6 = "quite so...";
        File hadoopHomeConf = new File(hadoopHome, "conf");
        File hadoopHomeEtc = new File(hadoopHome, "etc/hadoop");
        Assertions.assertThat((boolean)hadoopHomeConf.mkdirs()).isTrue();
        Assertions.assertThat((boolean)hadoopHomeEtc.mkdirs()).isTrue();
        File file1 = new File(hadoopConfDir, "core-site.xml");
        File file2 = new File(hadoopConfDir, "hdfs-site.xml");
        File file3 = new File(hadoopHomeConf, "core-site.xml");
        File file4 = new File(hadoopHomeConf, "hdfs-site.xml");
        File file5 = new File(hadoopHomeEtc, "core-site.xml");
        File file6 = new File(hadoopHomeEtc, "hdfs-site.xml");
        HadoopConfigLoadingTest.printConfig(file1, "where?", "I'm on a boat");
        HadoopConfigLoadingTest.printConfig(file2, "when?", "midnight");
        HadoopConfigLoadingTest.printConfig(file3, "why?", "what do you think?");
        HadoopConfigLoadingTest.printConfig(file4, "which way?", "south, always south...");
        HadoopConfigLoadingTest.printConfig(file5, "how long?", "an eternity");
        HadoopConfigLoadingTest.printConfig(file6, "for real?", "quite so...");
        Map<String, String> originalEnv = System.getenv();
        HashMap<String, String> newEnv = new HashMap<String, String>(originalEnv);
        newEnv.put("HADOOP_CONF_DIR", hadoopConfDir.getAbsolutePath());
        newEnv.put("HADOOP_HOME", hadoopHome.getAbsolutePath());
        try {
            CommonTestUtils.setEnv(newEnv);
            hadoopConf = HadoopUtils.getHadoopConfiguration((Configuration)new Configuration());
        }
        finally {
            CommonTestUtils.setEnv(originalEnv);
        }
        Assertions.assertThat((String)hadoopConf.get("where?", null)).isEqualTo("I'm on a boat");
        Assertions.assertThat((String)hadoopConf.get("when?", null)).isEqualTo("midnight");
        Assertions.assertThat((String)hadoopConf.get("why?", null)).isEqualTo("what do you think?");
        Assertions.assertThat((String)hadoopConf.get("which way?", null)).isEqualTo("south, always south...");
        Assertions.assertThat((String)hadoopConf.get("how long?", null)).isEqualTo("an eternity");
        Assertions.assertThat((String)hadoopConf.get("for real?", null)).isEqualTo("quite so...");
        Assertions.assertThat((String)hadoopConf.get(IN_CP_CONFIG_KEY, null)).isEqualTo(IN_CP_CONFIG_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void loadOverlappingConfig(@TempDir File hadoopConfDir, @TempDir File hadoopConfEntryDir, @TempDir File legacyConfDir, @TempDir File hadoopHome) throws Exception {
        org.apache.hadoop.conf.Configuration hadoopConf;
        String k1 = "key1";
        String k2 = "key2";
        String k3 = "key3";
        String k4 = "key4";
        String k5 = "key5";
        String v1 = "from HADOOP_CONF_DIR";
        String v2 = "from HADOOP_HOME/etc/hadoop";
        String v3 = "from HADOOP_HOME/etc/hadoop";
        String v4 = "from HADOOP_HOME/etc/hadoop";
        String v5 = "from HADOOP_HOME/conf";
        File hadoopHomeConf = new File(hadoopHome, "conf");
        File hadoopHomeEtc = new File(hadoopHome, "etc/hadoop");
        Assertions.assertThat((boolean)hadoopHomeConf.mkdirs()).isTrue();
        Assertions.assertThat((boolean)hadoopHomeEtc.mkdirs()).isTrue();
        File file1 = new File(hadoopConfDir, "core-site.xml");
        File file2 = new File(hadoopConfEntryDir, "core-site.xml");
        File file3 = new File(legacyConfDir, "core-site.xml");
        File file4 = new File(hadoopHomeEtc, "core-site.xml");
        File file5 = new File(hadoopHomeConf, "core-site.xml");
        HadoopConfigLoadingTest.printConfig(file1, "key1", "from HADOOP_CONF_DIR");
        HashMap<String, String> properties2 = new HashMap<String, String>();
        properties2.put("key1", "from HADOOP_HOME/etc/hadoop");
        properties2.put("key2", "from HADOOP_HOME/etc/hadoop");
        HadoopConfigLoadingTest.printConfigs(file2, properties2);
        HashMap<String, String> properties3 = new HashMap<String, String>();
        properties3.put("key1", "from HADOOP_HOME/etc/hadoop");
        properties3.put("key2", "from HADOOP_HOME/etc/hadoop");
        properties3.put("key3", "from HADOOP_HOME/etc/hadoop");
        HadoopConfigLoadingTest.printConfigs(file3, properties3);
        HashMap<String, String> properties4 = new HashMap<String, String>();
        properties4.put("key1", "from HADOOP_HOME/etc/hadoop");
        properties4.put("key2", "from HADOOP_HOME/etc/hadoop");
        properties4.put("key3", "from HADOOP_HOME/etc/hadoop");
        properties4.put("key4", "from HADOOP_HOME/etc/hadoop");
        HadoopConfigLoadingTest.printConfigs(file4, properties4);
        HashMap<String, String> properties5 = new HashMap<String, String>();
        properties5.put("key1", "from HADOOP_HOME/conf");
        properties5.put("key2", "from HADOOP_HOME/conf");
        properties5.put("key3", "from HADOOP_HOME/conf");
        properties5.put("key4", "from HADOOP_HOME/conf");
        properties5.put("key5", "from HADOOP_HOME/conf");
        HadoopConfigLoadingTest.printConfigs(file5, properties5);
        Configuration cfg = new Configuration();
        Map<String, String> originalEnv = System.getenv();
        HashMap<String, String> newEnv = new HashMap<String, String>(originalEnv);
        newEnv.put("HADOOP_CONF_DIR", hadoopConfDir.getAbsolutePath());
        newEnv.put("HADOOP_HOME", hadoopHome.getAbsolutePath());
        try {
            CommonTestUtils.setEnv(newEnv);
            hadoopConf = HadoopUtils.getHadoopConfiguration((Configuration)cfg);
        }
        finally {
            CommonTestUtils.setEnv(originalEnv);
        }
        Assertions.assertThat((String)hadoopConf.get("key1", null)).isEqualTo("from HADOOP_CONF_DIR");
        Assertions.assertThat((String)hadoopConf.get("key2", null)).isEqualTo("from HADOOP_HOME/etc/hadoop");
        Assertions.assertThat((String)hadoopConf.get("key3", null)).isEqualTo("from HADOOP_HOME/etc/hadoop");
        Assertions.assertThat((String)hadoopConf.get("key4", null)).isEqualTo("from HADOOP_HOME/etc/hadoop");
        Assertions.assertThat((String)hadoopConf.get("key5", null)).isEqualTo("from HADOOP_HOME/conf");
        Assertions.assertThat((String)hadoopConf.get(IN_CP_CONFIG_KEY, null)).isEqualTo(IN_CP_CONFIG_VALUE);
    }

    @Test
    void loadFromFlinkConfEntry() throws Exception {
        String prefix = "flink.hadoop.";
        String k1 = "brooklyn";
        String v1 = "nets";
        String k2 = "miami";
        String v2 = "heat";
        String k3 = "philadelphia";
        String v3 = "76ers";
        String k4 = "golden.state";
        String v4 = "warriors";
        String k5 = "oklahoma.city";
        String v5 = "thunders";
        Configuration cfg = new Configuration();
        cfg.setString("flink.hadoop.brooklyn", "nets");
        cfg.setString("flink.hadoop.miami", "heat");
        cfg.setString("flink.hadoop.philadelphia", "76ers");
        cfg.setString("flink.hadoop.golden.state", "warriors");
        cfg.setString("oklahoma.city", "thunders");
        org.apache.hadoop.conf.Configuration hadoopConf = HadoopUtils.getHadoopConfiguration((Configuration)cfg);
        Assertions.assertThat((String)hadoopConf.get("brooklyn", null)).isEqualTo("nets");
        Assertions.assertThat((String)hadoopConf.get("miami", null)).isEqualTo("heat");
        Assertions.assertThat((String)hadoopConf.get("philadelphia", null)).isEqualTo("76ers");
        Assertions.assertThat((String)hadoopConf.get("golden.state", null)).isEqualTo("warriors");
        Assertions.assertThat((String)hadoopConf.get("oklahoma.city")).isNull();
        Assertions.assertThat((String)hadoopConf.get(IN_CP_CONFIG_KEY, null)).isEqualTo(IN_CP_CONFIG_VALUE);
    }

    private static void printConfig(File file, String key, String value) throws IOException {
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put(key, value);
        HadoopConfigLoadingTest.printConfigs(file, map);
    }

    private static void printConfigs(File file, Map<String, String> properties) throws IOException {
        try (PrintStream out = new PrintStream(new FileOutputStream(file));){
            out.println("<?xml version=\"1.0\"?>");
            out.println("<?xml-stylesheet type=\"text/xsl\" href=\"configuration.xsl\"?>");
            out.println("<configuration>");
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                out.println("\t<property>");
                out.println("\t\t<name>" + entry.getKey() + "</name>");
                out.println("\t\t<value>" + entry.getValue() + "</value>");
                out.println("\t</property>");
            }
            out.println("</configuration>");
        }
    }
}

