/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.fs.hdfs;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.FileSystemTestUtils;
import org.apache.flink.core.fs.Path;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;

public abstract class AbstractHadoopFileSystemITTest {
    protected static FileSystem fs;
    protected static Path basePath;
    protected static long consistencyToleranceNS;

    private static void checkPathExistence(Path path, boolean expectedExists, long consistencyToleranceNS) throws IOException, InterruptedException {
        if (consistencyToleranceNS == 0L) {
            Assertions.assertThat((boolean)fs.exists(path)).isEqualTo(expectedExists);
        } else {
            FileSystemTestUtils.checkPathEventualExistence((FileSystem)fs, (Path)path, (boolean)expectedExists, (long)consistencyToleranceNS);
        }
    }

    protected void checkEmptyDirectory(Path path) throws IOException, InterruptedException {
        AbstractHadoopFileSystemITTest.checkPathExistence(path, true, consistencyToleranceNS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testSimpleFileWriteAndRead() throws Exception {
        String testLine = "Hello Upload!";
        Path path = new Path(basePath, "test.txt");
        try {
            try (FSDataOutputStream out = fs.create(path, FileSystem.WriteMode.OVERWRITE);
                 OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8);){
                writer.write("Hello Upload!");
            }
            AbstractHadoopFileSystemITTest.checkPathExistence(path, true, consistencyToleranceNS);
            try (FSDataInputStream in = fs.open(path);
                 InputStreamReader ir = new InputStreamReader((InputStream)in, StandardCharsets.UTF_8);
                 BufferedReader reader = new BufferedReader(ir);){
                String line = reader.readLine();
                Assertions.assertThat((String)line).isEqualTo("Hello Upload!");
            }
        }
        finally {
            fs.delete(path, false);
        }
        AbstractHadoopFileSystemITTest.checkPathExistence(path, false, consistencyToleranceNS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testDirectoryListing() throws Exception {
        Path directory = new Path(basePath, "testdir/");
        Assertions.assertThat((boolean)fs.exists(directory)).isFalse();
        try {
            Assertions.assertThat((boolean)fs.mkdirs(directory)).isTrue();
            this.checkEmptyDirectory(directory);
            Assertions.assertThat((int)fs.listStatus(directory).length).isZero();
            int numFiles = 3;
            for (int i = 0; i < 3; ++i) {
                Path file = new Path(directory, "/file-" + i);
                try (FSDataOutputStream out = fs.create(file, FileSystem.WriteMode.OVERWRITE);
                     OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8);){
                    writer.write("hello-" + i + "\n");
                }
                AbstractHadoopFileSystemITTest.checkPathExistence(file, true, consistencyToleranceNS);
            }
            Object[] files = fs.listStatus(directory);
            Assertions.assertThat((Object[])files).isNotNull();
            Assertions.assertThat((int)files.length).isEqualTo(3);
            for (Object status : files) {
                Assertions.assertThat((boolean)status.isDir()).isFalse();
            }
            Assertions.assertThat((boolean)fs.exists(directory)).isTrue();
        }
        finally {
            AbstractHadoopFileSystemITTest.cleanupDirectoryWithRetry(fs, directory, consistencyToleranceNS);
        }
    }

    @AfterAll
    static void teardown() throws IOException, InterruptedException {
        try {
            if (fs != null) {
                AbstractHadoopFileSystemITTest.cleanupDirectoryWithRetry(fs, basePath, consistencyToleranceNS);
            }
        }
        finally {
            FileSystem.initialize((Configuration)new Configuration());
        }
    }

    private static void cleanupDirectoryWithRetry(FileSystem fs, Path path, long consistencyToleranceNS) throws IOException, InterruptedException {
        fs.delete(path, true);
        long deadline = System.nanoTime() + consistencyToleranceNS;
        while (fs.exists(path) && System.nanoTime() - deadline < 0L) {
            fs.delete(path, true);
            Thread.sleep(50L);
        }
        Assertions.assertThat((boolean)fs.exists(path)).isFalse();
    }
}

