/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.hadoopcompatibility.mapreduce.example;

import java.io.Serializable;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.RichFlatMapFunction;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.hadoop.mapreduce.HadoopInputFormat;
import org.apache.flink.api.java.hadoop.mapreduce.HadoopOutputFormat;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.sink.legacy.OutputFormatSinkFunction;
import org.apache.flink.streaming.api.functions.sink.legacy.SinkFunction;
import org.apache.flink.streaming.api.windowing.assigners.GlobalWindows;
import org.apache.flink.streaming.api.windowing.assigners.WindowAssigner;
import org.apache.flink.util.Collector;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;

public class WordCount {
    public static JobExecutionResult run(String[] args) throws Exception {
        if (args.length < 2) {
            System.err.println("Usage: WordCount <input path> <result path>");
            return null;
        }
        String inputPath = args[0];
        String outputPath = args[1];
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        Job job = Job.getInstance();
        HadoopInputFormat hadoopInputFormat = new HadoopInputFormat((InputFormat)new TextInputFormat(), LongWritable.class, Text.class, job);
        TextInputFormat.addInputPath((Job)job, (Path)new Path(inputPath));
        DataStreamSource text = env.createInput((org.apache.flink.api.common.io.InputFormat)hadoopInputFormat);
        SingleOutputStreamOperator words = text.flatMap((FlatMapFunction)new Tokenizer());
        SingleOutputStreamOperator result = words.keyBy((KeySelector & Serializable)x -> (String)x.f0).window((WindowAssigner)GlobalWindows.createWithEndOfStreamTrigger()).sum(1);
        SingleOutputStreamOperator hadoopResult = result.map((MapFunction)new HadoopDatatypeMapper());
        HadoopOutputFormat hadoopOutputFormat = new HadoopOutputFormat((OutputFormat)new TextOutputFormat(), job);
        hadoopOutputFormat.getConfiguration().set("mapreduce.output.textoutputformat.separator", " ");
        hadoopOutputFormat.getConfiguration().set("mapred.textoutputformat.separator", " ");
        TextOutputFormat.setOutputPath((Job)job, (Path)new Path(outputPath));
        hadoopResult.addSink((SinkFunction)new OutputFormatSinkFunction((org.apache.flink.api.common.io.OutputFormat)hadoopOutputFormat));
        return env.execute("Word Count");
    }

    public static final class HadoopDatatypeMapper
    extends RichMapFunction<Tuple2<String, Integer>, Tuple2<Text, IntWritable>> {
        public Tuple2<Text, IntWritable> map(Tuple2<String, Integer> value) throws Exception {
            return new Tuple2((Object)new Text((String)value.f0), (Object)new IntWritable(((Integer)value.f1).intValue()));
        }
    }

    public static final class Tokenizer
    extends RichFlatMapFunction<Tuple2<LongWritable, Text>, Tuple2<String, Integer>> {
        public void flatMap(Tuple2<LongWritable, Text> value, Collector<Tuple2<String, Integer>> out) {
            String[] tokens;
            String line = ((Text)value.f1).toString();
            for (String token : tokens = line.toLowerCase().split("\\W+")) {
                if (token.length() <= 0) continue;
                out.collect((Object)new Tuple2((Object)token, (Object)1));
            }
        }
    }
}

