/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.hadoop.mapred.wrapper;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.flink.api.java.hadoop.mapred.wrapper.HadoopInputSplit;
import org.apache.flink.util.InstantiationUtil;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobConfigurable;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class HadoopInputSplitTest {
    private JobConf conf;

    HadoopInputSplitTest() {
    }

    @BeforeEach
    void before() {
        Configuration configuration = new Configuration();
        for (int i = 0; i < 10000; ++i) {
            configuration.set("key-" + i, "value-" + i);
        }
        this.conf = new JobConf(configuration);
    }

    private void testInner(FileSplit fileSplit, Consumer<Integer> serializeSizeChecker, Consumer<InputSplit> splitChecker) throws IOException, ClassNotFoundException {
        HadoopInputSplit split = new HadoopInputSplit(5, (InputSplit)fileSplit, this.conf);
        byte[] bytes = InstantiationUtil.serializeObject((Object)split);
        serializeSizeChecker.accept(bytes.length);
        split = (HadoopInputSplit)InstantiationUtil.deserializeObject((byte[])bytes, (ClassLoader)split.getClass().getClassLoader());
        Assertions.assertThat((int)split.getSplitNumber()).isEqualTo(5);
        Assertions.assertThat((Object[])split.getHostnames()).containsExactly((Object[])new String[]{"host0"});
        splitChecker.accept(split.getHadoopInputSplit());
    }

    @Test
    void testFileSplit() throws IOException, ClassNotFoundException {
        FileSplit fileSplit = new FileSplit(new Path("/test"), 0L, 100L, new String[]{"host0"});
        this.testInner(fileSplit, i -> Assertions.assertThat((Integer)i).isLessThan(10000), split -> Assertions.assertThat((Object)split).isEqualTo((Object)fileSplit));
    }

    @Test
    void testConfigurable() throws IOException, ClassNotFoundException {
        ConfigurableFileSplit fileSplit = new ConfigurableFileSplit(new Path("/test"), 0L, 100L, new String[]{"host0"});
        this.testInner(fileSplit, i -> {}, inputSplit -> {
            ConfigurableFileSplit split = (ConfigurableFileSplit)inputSplit;
            Assertions.assertThat((Iterable)split.getConf()).isNotNull();
            Assertions.assertThat((Object)split).isEqualTo((Object)fileSplit);
        });
    }

    @Test
    void testJobConfigurable() throws IOException, ClassNotFoundException {
        JobConfigurableFileSplit fileSplit = new JobConfigurableFileSplit(new Path("/test"), 0L, 100L, new String[]{"host0"});
        this.testInner(fileSplit, i -> {}, inputSplit -> {
            JobConfigurableFileSplit split = (JobConfigurableFileSplit)inputSplit;
            Assertions.assertThat((Iterable)split.getConf()).isNotNull();
            Assertions.assertThat((Object)split).isEqualTo((Object)fileSplit);
        });
    }

    private static class JobConfigurableFileSplit
    extends FileSplit
    implements JobConfigurable {
        private JobConf jobConf;

        public JobConfigurableFileSplit() {
        }

        private JobConfigurableFileSplit(Path file, long start, long length, String[] hosts) {
            super(file, start, length, hosts);
        }

        public void configure(JobConf jobConf) {
            this.jobConf = jobConf;
        }

        private JobConf getConf() {
            return this.jobConf;
        }
    }

    private static class ConfigurableFileSplit
    extends FileSplit
    implements Configurable {
        private Configuration conf;

        public ConfigurableFileSplit() {
        }

        private ConfigurableFileSplit(Path file, long start, long length, String[] hosts) {
            super(file, start, length, hosts);
        }

        public void setConf(Configuration configuration) {
            this.conf = configuration;
        }

        public Configuration getConf() {
            return this.conf;
        }
    }

    private static class FileSplit
    implements InputSplit {
        private Path file;
        private long start;
        private long length;
        private String[] hosts;

        public FileSplit() {
        }

        private FileSplit(Path file, long start, long length, String[] hosts) {
            this.file = file;
            this.start = start;
            this.length = length;
            this.hosts = hosts;
        }

        public long getLength() throws IOException {
            return this.length;
        }

        public String[] getLocations() throws IOException {
            return this.hosts;
        }

        public void write(DataOutput out) throws IOException {
            out.writeUTF(this.file.toString());
            out.writeLong(this.start);
            out.writeLong(this.length);
            out.writeInt(this.hosts.length);
            for (String host : this.hosts) {
                out.writeUTF(host);
            }
        }

        public void readFields(DataInput in) throws IOException {
            this.file = new Path(in.readUTF());
            this.start = in.readLong();
            this.length = in.readLong();
            int size = in.readInt();
            this.hosts = new String[size];
            for (int i = 0; i < size; ++i) {
                this.hosts[i] = in.readUTF();
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FileSplit fileSplit = (FileSplit)o;
            return this.start == fileSplit.start && this.length == fileSplit.length && Objects.equals(this.file, fileSplit.file) && Arrays.equals(this.hosts, fileSplit.hosts);
        }
    }
}

