/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.datastream.impl.extension.window.utils;

import java.time.Duration;
import org.apache.flink.datastream.api.extension.window.strategy.GlobalWindowStrategy;
import org.apache.flink.datastream.api.extension.window.strategy.SessionWindowStrategy;
import org.apache.flink.datastream.api.extension.window.strategy.SlidingTimeWindowStrategy;
import org.apache.flink.datastream.api.extension.window.strategy.TumblingTimeWindowStrategy;
import org.apache.flink.datastream.api.extension.window.strategy.WindowStrategy;
import org.apache.flink.datastream.impl.extension.window.context.WindowTriggerContext;
import org.apache.flink.streaming.api.operators.InternalTimerService;
import org.apache.flink.streaming.api.windowing.assigners.EventTimeSessionWindows;
import org.apache.flink.streaming.api.windowing.assigners.GlobalWindows;
import org.apache.flink.streaming.api.windowing.assigners.ProcessingTimeSessionWindows;
import org.apache.flink.streaming.api.windowing.assigners.SlidingEventTimeWindows;
import org.apache.flink.streaming.api.windowing.assigners.SlidingProcessingTimeWindows;
import org.apache.flink.streaming.api.windowing.assigners.TumblingEventTimeWindows;
import org.apache.flink.streaming.api.windowing.assigners.TumblingProcessingTimeWindows;
import org.apache.flink.streaming.api.windowing.assigners.WindowAssigner;
import org.apache.flink.streaming.api.windowing.windows.Window;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;

public final class WindowUtils {
    public static long getAllowedLateness(WindowStrategy windowStrategy) {
        if (windowStrategy instanceof TumblingTimeWindowStrategy) {
            return ((TumblingTimeWindowStrategy)windowStrategy).getAllowedLateness().toMillis();
        }
        if (windowStrategy instanceof SlidingTimeWindowStrategy) {
            return ((SlidingTimeWindowStrategy)windowStrategy).getAllowedLateness().toMillis();
        }
        return 0L;
    }

    public static WindowAssigner<?, ?> createWindowAssigner(WindowStrategy windowStrategy) {
        if (windowStrategy instanceof GlobalWindowStrategy) {
            return WindowUtils.createGlobalWindowAssigner();
        }
        if (windowStrategy instanceof TumblingTimeWindowStrategy) {
            return WindowUtils.createTumblingTimeWindowAssigner((TumblingTimeWindowStrategy)windowStrategy);
        }
        if (windowStrategy instanceof SlidingTimeWindowStrategy) {
            return WindowUtils.createSlidingTimeWindowAssigner((SlidingTimeWindowStrategy)windowStrategy);
        }
        if (windowStrategy instanceof SessionWindowStrategy) {
            return WindowUtils.createSessionWindowAssigner((SessionWindowStrategy)windowStrategy);
        }
        throw new IllegalArgumentException("Unsupported type of window strategy : " + windowStrategy.getClass());
    }

    private static WindowAssigner<?, ?> createGlobalWindowAssigner() {
        return GlobalWindows.createWithEndOfStreamTrigger();
    }

    private static WindowAssigner<?, ?> createTumblingTimeWindowAssigner(TumblingTimeWindowStrategy windowStrategy) {
        switch (windowStrategy.getTimeType()) {
            case PROCESSING: {
                return TumblingProcessingTimeWindows.of((Duration)windowStrategy.getWindowSize());
            }
            case EVENT: {
                return TumblingEventTimeWindows.of((Duration)windowStrategy.getWindowSize());
            }
        }
        throw new IllegalArgumentException("Unsupported time type : " + windowStrategy.getTimeType());
    }

    private static WindowAssigner<?, ?> createSlidingTimeWindowAssigner(SlidingTimeWindowStrategy windowStrategy) {
        switch (windowStrategy.getTimeType()) {
            case PROCESSING: {
                return SlidingProcessingTimeWindows.of((Duration)windowStrategy.getWindowSize(), (Duration)windowStrategy.getWindowSlideInterval());
            }
            case EVENT: {
                return SlidingEventTimeWindows.of((Duration)windowStrategy.getWindowSize(), (Duration)windowStrategy.getWindowSlideInterval());
            }
        }
        throw new IllegalArgumentException("Unsupported time type : " + windowStrategy.getTimeType());
    }

    private static WindowAssigner<?, ?> createSessionWindowAssigner(SessionWindowStrategy windowStrategy) {
        switch (windowStrategy.getTimeType()) {
            case PROCESSING: {
                return ProcessingTimeSessionWindows.withGap((Duration)windowStrategy.getSessionGap());
            }
            case EVENT: {
                return EventTimeSessionWindows.withGap((Duration)windowStrategy.getSessionGap());
            }
        }
        throw new IllegalArgumentException("Unsupported time type : " + windowStrategy.getTimeType());
    }

    public static <W extends Window> boolean isWindowLate(W window, WindowAssigner<?, W> windowAssigner, InternalTimerService<W> internalTimerService, long allowedLateness) {
        return windowAssigner.isEventTime() && WindowUtils.cleanupTime(window, windowAssigner, allowedLateness) <= internalTimerService.currentWatermark();
    }

    public static boolean isElementLate(StreamRecord<?> element, WindowAssigner<?, ?> windowAssigner, long allowedLateness, InternalTimerService<?> internalTimerService) {
        return windowAssigner.isEventTime() && element.getTimestamp() + allowedLateness <= internalTimerService.currentWatermark();
    }

    public static <W extends Window> void deleteCleanupTimer(W window, WindowAssigner<?, ?> windowAssigner, WindowTriggerContext<?, ?, W> triggerContext, long allowedLateness) {
        long cleanupTime = WindowUtils.cleanupTime(window, windowAssigner, allowedLateness);
        if (cleanupTime == Long.MAX_VALUE) {
            return;
        }
        if (windowAssigner.isEventTime()) {
            triggerContext.deleteEventTimeTimer(cleanupTime);
        } else {
            triggerContext.deleteProcessingTimeTimer(cleanupTime);
        }
    }

    public static <W extends Window> void registerCleanupTimer(W window, WindowAssigner<?, ?> windowAssigner, WindowTriggerContext<?, ?, W> triggerContext, long allowedLateness) {
        long cleanupTime = WindowUtils.cleanupTime(window, windowAssigner, allowedLateness);
        if (cleanupTime == Long.MAX_VALUE) {
            return;
        }
        if (windowAssigner.isEventTime()) {
            triggerContext.registerEventTimeTimer(cleanupTime);
        } else {
            triggerContext.registerProcessingTimeTimer(cleanupTime);
        }
    }

    private static <W extends Window> long cleanupTime(W window, WindowAssigner<?, ?> windowAssigner, long allowedLateness) {
        if (windowAssigner.isEventTime()) {
            long cleanupTime = window.maxTimestamp() + allowedLateness;
            return cleanupTime >= window.maxTimestamp() ? cleanupTime : Long.MAX_VALUE;
        }
        return window.maxTimestamp();
    }

    public static <W extends Window> boolean isCleanupTime(W window, long time, WindowAssigner<?, ?> windowAssigner, long allowedLateness) {
        return time == WindowUtils.cleanupTime(window, windowAssigner, allowedLateness);
    }
}

