/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.datastream.impl.extension.eventtime.timer;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.flink.datastream.api.extension.eventtime.timer.EventTimeManager;
import org.apache.flink.runtime.state.VoidNamespace;
import org.apache.flink.streaming.api.operators.InternalTimerService;

public class DefaultEventTimeManager
implements EventTimeManager {
    @Nullable
    private final InternalTimerService<VoidNamespace> timerService;
    private final Supplier<Long> eventTimeSupplier;

    public DefaultEventTimeManager(@Nullable InternalTimerService<VoidNamespace> timerService, Supplier<Long> eventTimeSupplier) {
        this.timerService = timerService;
        this.eventTimeSupplier = eventTimeSupplier;
    }

    public void registerTimer(long timestamp) {
        if (this.timerService == null) {
            throw new UnsupportedOperationException("Registering event timer is not allowed in NonKeyed Stream.");
        }
        this.timerService.registerEventTimeTimer((Object)VoidNamespace.INSTANCE, timestamp);
    }

    public void deleteTimer(long timestamp) {
        if (this.timerService == null) {
            throw new UnsupportedOperationException("Deleting event timer is not allowed in NonKeyed Stream.");
        }
        this.timerService.deleteEventTimeTimer((Object)VoidNamespace.INSTANCE, timestamp);
    }

    public long currentTime() {
        return this.eventTimeSupplier.get();
    }
}

