/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.datastream.impl.context;

import java.util.Map;
import java.util.Set;
import org.apache.flink.api.common.watermark.WatermarkManager;
import org.apache.flink.datastream.api.common.Collector;
import org.apache.flink.datastream.api.context.JobInfo;
import org.apache.flink.datastream.api.context.NonPartitionedContext;
import org.apache.flink.datastream.api.context.TaskInfo;
import org.apache.flink.datastream.api.function.ApplyPartitionFunction;
import org.apache.flink.datastream.impl.context.DefaultPartitionedContext;
import org.apache.flink.datastream.impl.context.DefaultRuntimeContext;
import org.apache.flink.datastream.impl.watermark.DefaultWatermarkManager;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.runtime.watermark.AbstractInternalWatermarkDeclaration;

public class DefaultNonPartitionedContext<OUT>
implements NonPartitionedContext<OUT> {
    private final DefaultRuntimeContext context;
    private final DefaultPartitionedContext<OUT> partitionedContext;
    private final Collector<OUT> collector;
    private final boolean isKeyed;
    private final Set<Object> keySet;
    private final WatermarkManager watermarkManager;

    public DefaultNonPartitionedContext(DefaultRuntimeContext context, DefaultPartitionedContext<OUT> partitionedContext, Collector<OUT> collector, boolean isKeyed, Set<Object> keySet, Output<?> streamRecordOutput, Map<String, AbstractInternalWatermarkDeclaration<?>> watermarkDeclarationMap) {
        this.context = context;
        this.partitionedContext = partitionedContext;
        this.collector = collector;
        this.isKeyed = isKeyed;
        this.keySet = keySet;
        this.watermarkManager = new DefaultWatermarkManager(streamRecordOutput, watermarkDeclarationMap);
    }

    public void applyToAllPartitions(ApplyPartitionFunction<OUT> applyPartitionFunction) throws Exception {
        if (this.isKeyed) {
            for (Object key : this.keySet) {
                this.partitionedContext.getStateManager().executeInKeyContext(() -> {
                    try {
                        applyPartitionFunction.apply(this.collector, this.partitionedContext);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }, key);
            }
        } else {
            applyPartitionFunction.apply(this.collector, this.partitionedContext);
        }
    }

    public WatermarkManager getWatermarkManager() {
        return this.watermarkManager;
    }

    public JobInfo getJobInfo() {
        return this.context.getJobInfo();
    }

    public TaskInfo getTaskInfo() {
        return this.context.getTaskInfo();
    }

    public MetricGroup getMetricGroup() {
        return this.context.getMetricGroup();
    }
}

