/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.table;

import java.net.URI;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import org.apache.flink.connector.file.table.PartitionTempFileManager;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class PartitionTempFileManagerTest {
    @TempDir
    private java.nio.file.Path tmpPath;

    PartitionTempFileManagerTest() {
    }

    @Test
    void testListTaskTemporaryPaths() throws Exception {
        BiPredicate<Integer, Integer> taskAttemptFilter = (subtaskIndex, attemptNumber) -> subtaskIndex == 0 && attemptNumber == 1;
        FileSystem fs = FileSystem.get((URI)this.tmpPath.toUri());
        fs.mkdirs(new Path(this.tmpPath.toUri() + "/task-0-attempt-0"));
        fs.mkdirs(new Path(this.tmpPath.toUri() + "/task-0-attempt-1"));
        fs.mkdirs(new Path(this.tmpPath.toUri() + "/task-1-attempt-0"));
        fs.mkdirs(new Path(this.tmpPath.toUri() + "/.task-0-attempt-1"));
        fs.mkdirs(new Path(this.tmpPath.toUri() + "/_SUCCESS"));
        List taskTmpPaths = PartitionTempFileManager.listTaskTemporaryPaths((FileSystem)fs, (Path)new Path(this.tmpPath.toUri()), taskAttemptFilter);
        List taskDirs = taskTmpPaths.stream().map(Path::getName).collect(Collectors.toList());
        ((ListAssert)Assertions.assertThat(taskDirs).hasSize(1)).containsExactly((Object[])new String[]{"task-0-attempt-1"});
    }
}

