/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.src.testutils;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.core.fs.BlockLocation;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.core.fs.FileStatus;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.util.Preconditions;

public class TestingFileSystem
extends FileSystem {
    private final String scheme;
    private final Map<Path, Collection<FileStatus>> directories;
    private final Map<Path, TestFileStatus> files;

    private TestingFileSystem(String scheme, Map<Path, Collection<FileStatus>> directories, Map<Path, TestFileStatus> files) {
        this.scheme = scheme;
        this.directories = directories;
        this.files = files;
    }

    public static TestingFileSystem createWithFiles(String scheme, Path ... files) {
        return TestingFileSystem.createWithFiles(scheme, Arrays.asList(files));
    }

    public static TestingFileSystem createWithFiles(String scheme, Collection<Path> files) {
        Preconditions.checkNotNull((Object)scheme, (String)"scheme");
        Preconditions.checkNotNull(files, (String)"files");
        Collection status = files.stream().map(path -> TestFileStatus.forFileWithDefaultBlock(path, 0xA00000L)).collect(Collectors.toList());
        return TestingFileSystem.createForFileStatus(scheme, status);
    }

    public static TestingFileSystem createForFileStatus(String scheme, TestFileStatus ... files) {
        return TestingFileSystem.createForFileStatus(scheme, Arrays.asList(files));
    }

    public static TestingFileSystem createForFileStatus(String scheme, Collection<TestFileStatus> files) {
        Preconditions.checkNotNull((Object)scheme, (String)"scheme");
        Preconditions.checkNotNull(files, (String)"files");
        HashMap<Path, TestFileStatus> fileMap = new HashMap<Path, TestFileStatus>(files.size());
        HashMap<Path, Collection<FileStatus>> directories = new HashMap<Path, Collection<FileStatus>>();
        for (TestFileStatus file : files) {
            if (fileMap.putIfAbsent(file.getPath(), file) != null) {
                throw new IllegalStateException("Already have a status for path " + file.getPath());
            }
            TestingFileSystem.addParentDirectories(file, fileMap, directories);
        }
        return new TestingFileSystem(scheme, directories, fileMap);
    }

    private static void addParentDirectories(TestFileStatus file, Map<Path, TestFileStatus> files, Map<Path, Collection<FileStatus>> directories) {
        Path parentPath = file.getPath().getParent();
        if (parentPath == null) {
            return;
        }
        TestFileStatus parentStatus = TestFileStatus.forDirectory(parentPath);
        directories.computeIfAbsent(parentPath, key -> new ArrayList()).add(file);
        TestFileStatus existingParent = files.putIfAbsent(parentPath, parentStatus);
        if (existingParent == null) {
            TestingFileSystem.addParentDirectories(parentStatus, files, directories);
        } else {
            Preconditions.checkArgument((boolean)existingParent.isDir(), (Object)"have a file already for a directory path");
        }
    }

    public void register() throws Exception {
        Object key = TestingFileSystem.createFsKey(this.scheme);
        Map<Object, Object> fsMap = TestingFileSystem.getFsRegistry();
        fsMap.put(key, (Object)this);
    }

    public void unregister() throws Exception {
        Object key = TestingFileSystem.createFsKey(this.scheme);
        Map<Object, Object> fsMap = TestingFileSystem.getFsRegistry();
        fsMap.remove(key);
    }

    private static Object createFsKey(String scheme) throws Exception {
        Class<?> fsKeyClass = Class.forName("org.apache.flink.core.fs.FileSystem$FSKey");
        Constructor<?> ctor = fsKeyClass.getConstructor(String.class, String.class);
        ctor.setAccessible(true);
        return ctor.newInstance(scheme, null);
    }

    private static Map<Object, Object> getFsRegistry() throws Exception {
        Field cacheField = FileSystem.class.getDeclaredField("CACHE");
        cacheField.setAccessible(true);
        return (Map)cacheField.get(null);
    }

    public Path getWorkingDirectory() {
        throw new UnsupportedOperationException();
    }

    public Path getHomeDirectory() {
        throw new UnsupportedOperationException();
    }

    public URI getUri() {
        return URI.create(this.scheme + "://");
    }

    public FileStatus getFileStatus(Path f) throws IOException {
        FileStatus status = this.files.get(f);
        if (status != null) {
            return status;
        }
        throw new FileNotFoundException("File not found: " + f);
    }

    public BlockLocation[] getFileBlockLocations(FileStatus file, long start, long len) throws IOException {
        TestFileStatus status;
        TestFileStatus testFileStatus = status = file instanceof TestFileStatus ? (TestFileStatus)file : this.files.get(file.getPath());
        if (status == null) {
            throw new FileNotFoundException(file.getPath().toString());
        }
        return status.getBlocks();
    }

    public FSDataInputStream open(Path f, int bufferSize) throws IOException {
        return this.open(f);
    }

    public FSDataInputStream open(Path f) throws IOException {
        TestFileStatus status = (TestFileStatus)this.getFileStatus(f);
        if (status.stream != null) {
            return status.stream;
        }
        throw new UnsupportedOperationException("No stream registered for this file");
    }

    public FileStatus[] listStatus(Path f) throws IOException {
        Collection<FileStatus> dirContents = this.directories.get(f);
        if (dirContents != null) {
            return dirContents.toArray(new FileStatus[dirContents.size()]);
        }
        throw new FileNotFoundException("Directory not found: " + f);
    }

    public boolean delete(Path f, boolean recursive) throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean mkdirs(Path f) throws IOException {
        throw new UnsupportedOperationException();
    }

    public FSDataOutputStream create(Path f, FileSystem.WriteMode overwriteMode) throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean rename(Path src, Path dst) throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean isDistributedFS() {
        return false;
    }

    public static final class TestBlockLocation
    implements BlockLocation {
        private final String[] hosts;
        private final long offset;
        private final long length;

        public TestBlockLocation(long offset, long length, String ... hosts) {
            Preconditions.checkArgument((offset >= 0L ? 1 : 0) != 0);
            Preconditions.checkArgument((length >= 0L ? 1 : 0) != 0);
            this.offset = offset;
            this.length = length;
            this.hosts = (String[])Preconditions.checkNotNull((Object)hosts);
        }

        public String[] getHosts() throws IOException {
            return this.hosts;
        }

        public long getOffset() {
            return this.offset;
        }

        public long getLength() {
            return this.length;
        }

        public int compareTo(BlockLocation o) {
            return 0;
        }
    }

    public static final class TestFileStatus
    implements FileStatus {
        private static final long TIME = System.currentTimeMillis();
        private final Path path;
        private final long len;
        private final boolean isDir;
        @Nullable
        private final BlockLocation[] blocks;
        @Nullable
        final FSDataInputStream stream;

        public static TestFileStatus forFileWithDefaultBlock(Path path, long len) {
            return TestFileStatus.forFileWithBlocks(path, len, new TestBlockLocation(0L, len, new String[0]));
        }

        public static TestFileStatus forFileWithBlocks(Path path, long len, BlockLocation ... blocks) {
            Preconditions.checkNotNull((Object)blocks);
            return new TestFileStatus(path, len, false, blocks, null);
        }

        public static TestFileStatus forFileWithStream(Path path, long len, FSDataInputStream stream) {
            return new TestFileStatus(path, len, false, new BlockLocation[]{new TestBlockLocation(0L, len, new String[0])}, stream);
        }

        public static TestFileStatus forDirectory(Path path) {
            return new TestFileStatus(path, 4096L, true, null, null);
        }

        private TestFileStatus(Path path, long len, boolean isDir, @Nullable BlockLocation[] blocks, @Nullable FSDataInputStream stream) {
            this.path = path;
            this.len = len;
            this.isDir = isDir;
            this.blocks = blocks;
            this.stream = stream;
        }

        public long getLen() {
            return this.len;
        }

        public long getBlockSize() {
            return 0x4000000L;
        }

        public short getReplication() {
            return 1;
        }

        public long getModificationTime() {
            return TIME;
        }

        public long getAccessTime() {
            return TIME;
        }

        public boolean isDir() {
            return this.isDir;
        }

        public Path getPath() {
            return this.path;
        }

        public BlockLocation[] getBlocks() {
            return this.blocks;
        }

        public String toString() {
            return this.path.toString() + (this.isDir ? " [DIR]" : " [FILE]");
        }
    }
}

