/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.src.impl;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import org.apache.flink.api.connector.source.SourceReaderContext;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.file.src.FileSourceSplit;
import org.apache.flink.connector.file.src.impl.FileSourceReader;
import org.apache.flink.connector.file.src.impl.StreamFormatAdapter;
import org.apache.flink.connector.file.src.reader.BulkFormat;
import org.apache.flink.connector.file.src.reader.StreamFormat;
import org.apache.flink.connector.file.src.reader.TextLineInputFormat;
import org.apache.flink.connector.testutils.source.reader.TestingReaderContext;
import org.apache.flink.core.fs.Path;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class FileSourceReaderTest {
    @TempDir
    private static java.nio.file.Path tmpDir;

    FileSourceReaderTest() {
    }

    @Test
    void testRequestSplitWhenNoSplitRestored() throws Exception {
        TestingReaderContext context = new TestingReaderContext();
        FileSourceReader<String, FileSourceSplit> reader = FileSourceReaderTest.createReader(context);
        reader.start();
        reader.close();
        Assertions.assertThat((int)context.getNumSplitRequests()).isEqualTo(1);
    }

    @Test
    void testNoSplitRequestWhenSplitRestored() throws Exception {
        TestingReaderContext context = new TestingReaderContext();
        FileSourceReader<String, FileSourceSplit> reader = FileSourceReaderTest.createReader(context);
        reader.addSplits(Collections.singletonList(FileSourceReaderTest.createTestFileSplit()));
        reader.start();
        reader.close();
        Assertions.assertThat((int)context.getNumSplitRequests()).isEqualTo(0);
    }

    private static FileSourceReader<String, FileSourceSplit> createReader(TestingReaderContext context) {
        return new FileSourceReader((SourceReaderContext)context, (BulkFormat)new StreamFormatAdapter((StreamFormat)new TextLineInputFormat()), new Configuration());
    }

    private static FileSourceSplit createTestFileSplit() throws IOException {
        return new FileSourceSplit("test-id", Path.fromLocalFile((File)tmpDir.toFile()), 0L, 0L, 0L, 0L);
    }
}

