/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.sink.committer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.api.connector.sink2.mocks.MockCommitRequest;
import org.apache.flink.connector.file.sink.FileSinkCommittable;
import org.apache.flink.connector.file.sink.committer.FileCommitter;
import org.apache.flink.connector.file.sink.utils.FileSinkTestUtils;
import org.apache.flink.connector.file.sink.utils.NoOpBucketWriter;
import org.apache.flink.streaming.api.functions.sink.filesystem.BucketWriter;
import org.apache.flink.streaming.api.functions.sink.filesystem.InProgressFileWriter;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class FileCommitterTest {
    FileCommitterTest() {
    }

    @Test
    void testCommitPendingFile() throws Exception {
        StubBucketWriter stubBucketWriter = new StubBucketWriter();
        FileCommitter fileCommitter = new FileCommitter((BucketWriter)stubBucketWriter);
        MockCommitRequest fileSinkCommittable = new MockCommitRequest((Object)new FileSinkCommittable("0", (InProgressFileWriter.PendingFileRecoverable)new FileSinkTestUtils.TestPendingFileRecoverable()));
        fileCommitter.commit(Collections.singletonList(fileSinkCommittable));
        Assertions.assertThat(stubBucketWriter.getRecoveredPendingFiles()).hasSize(1);
        Assertions.assertThat((int)stubBucketWriter.getNumCleanUp()).isEqualTo(0);
        Assertions.assertThat((boolean)stubBucketWriter.getRecoveredPendingFiles().get(0).isCommitted()).isTrue();
        Assertions.assertThat((int)fileSinkCommittable.getNumberOfRetries()).isEqualTo(0);
    }

    @Test
    void testCleanupInProgressFiles() throws Exception {
        StubBucketWriter stubBucketWriter = new StubBucketWriter();
        FileCommitter fileCommitter = new FileCommitter((BucketWriter)stubBucketWriter);
        MockCommitRequest fileSinkCommittable = new MockCommitRequest((Object)new FileSinkCommittable("0", (InProgressFileWriter.InProgressFileRecoverable)new FileSinkTestUtils.TestInProgressFileRecoverable()));
        fileCommitter.commit(Collections.singletonList(fileSinkCommittable));
        Assertions.assertThat(stubBucketWriter.getRecoveredPendingFiles()).isEmpty();
        Assertions.assertThat((int)stubBucketWriter.getNumCleanUp()).isEqualTo(1);
        Assertions.assertThat((int)fileSinkCommittable.getNumberOfRetries()).isEqualTo(0);
    }

    @Test
    void testCommitMultiple() throws Exception {
        StubBucketWriter stubBucketWriter = new StubBucketWriter();
        FileCommitter fileCommitter = new FileCommitter((BucketWriter)stubBucketWriter);
        Collection committables = Stream.of(new FileSinkCommittable("0", (InProgressFileWriter.PendingFileRecoverable)new FileSinkTestUtils.TestPendingFileRecoverable()), new FileSinkCommittable("0", (InProgressFileWriter.PendingFileRecoverable)new FileSinkTestUtils.TestPendingFileRecoverable()), new FileSinkCommittable("0", (InProgressFileWriter.InProgressFileRecoverable)new FileSinkTestUtils.TestInProgressFileRecoverable()), new FileSinkCommittable("0", (InProgressFileWriter.PendingFileRecoverable)new FileSinkTestUtils.TestPendingFileRecoverable()), new FileSinkCommittable("0", (InProgressFileWriter.InProgressFileRecoverable)new FileSinkTestUtils.TestInProgressFileRecoverable())).map(MockCommitRequest::new).collect(Collectors.toList());
        fileCommitter.commit(committables);
        Assertions.assertThat(stubBucketWriter.getRecoveredPendingFiles()).hasSize(3);
        Assertions.assertThat((int)stubBucketWriter.getNumCleanUp()).isEqualTo(2);
        stubBucketWriter.getRecoveredPendingFiles().forEach(pendingFile -> Assertions.assertThat((boolean)pendingFile.isCommitted()).isTrue());
        Assertions.assertThat((Collection)committables).allMatch(c -> c.getNumberOfRetries() == 0);
    }

    private static class StubBucketWriter
    extends NoOpBucketWriter {
        private final List<RecordingPendingFile> recoveredPendingFiles = new ArrayList<RecordingPendingFile>();
        private int numCleanUp;

        private StubBucketWriter() {
        }

        @Override
        public BucketWriter.PendingFile recoverPendingFile(InProgressFileWriter.PendingFileRecoverable pendingFileRecoverable) throws IOException {
            RecordingPendingFile pendingFile = new RecordingPendingFile();
            this.recoveredPendingFiles.add(pendingFile);
            return pendingFile;
        }

        @Override
        public boolean cleanupInProgressFileRecoverable(InProgressFileWriter.InProgressFileRecoverable inProgressFileRecoverable) throws IOException {
            ++this.numCleanUp;
            return true;
        }

        public List<RecordingPendingFile> getRecoveredPendingFiles() {
            return this.recoveredPendingFiles;
        }

        public int getNumCleanUp() {
            return this.numCleanUp;
        }
    }

    private static class RecordingPendingFile
    implements BucketWriter.PendingFile {
        private boolean committed;

        private RecordingPendingFile() {
        }

        public void commit() throws IOException {
            this.commitAfterRecovery();
        }

        public void commitAfterRecovery() throws IOException {
            this.committed = true;
        }

        public boolean isCommitted() {
            return this.committed;
        }
    }
}

