/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.table;

import java.util.LinkedHashMap;
import org.apache.flink.connector.file.table.RowPartitionComputer;
import org.apache.flink.table.utils.PartitionPathUtils;
import org.apache.flink.types.Row;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class RowPartitionComputerTest {
    RowPartitionComputerTest() {
    }

    @Test
    void testProjectColumnsToWrite() {
        Row projected1 = new RowPartitionComputer("", new String[]{"f1", "p1", "p2", "f2"}, new String[]{"p1", "p2"}).projectColumnsToWrite(Row.of((Object[])new Object[]{1, 2, 3, 4}));
        Assertions.assertThat((Object)projected1).isEqualTo((Object)Row.of((Object[])new Object[]{1, 4}));
        Row projected2 = new RowPartitionComputer("", new String[]{"f1", "f2", "p1", "p2"}, new String[]{"p1", "p2"}).projectColumnsToWrite(Row.of((Object[])new Object[]{1, 2, 3, 4}));
        Assertions.assertThat((Object)projected2).isEqualTo((Object)Row.of((Object[])new Object[]{1, 2}));
        Row projected3 = new RowPartitionComputer("", new String[]{"f1", "p1", "f2", "p2"}, new String[]{"p1", "p2"}).projectColumnsToWrite(Row.of((Object[])new Object[]{1, 2, 3, 4}));
        Assertions.assertThat((Object)projected3).isEqualTo((Object)Row.of((Object[])new Object[]{1, 3}));
    }

    @Test
    void testComputePartition() throws Exception {
        RowPartitionComputer computer = new RowPartitionComputer("myDefaultname", new String[]{"f1", "p1", "p2", "f2"}, new String[]{"p1", "p2"});
        Assertions.assertThat((String)PartitionPathUtils.generatePartitionPath((LinkedHashMap)computer.generatePartValues(Row.of((Object[])new Object[]{1, 2, 3, 4})))).isEqualTo("p1=2/p2=3/");
        Assertions.assertThat((String)PartitionPathUtils.generatePartitionPath((LinkedHashMap)computer.generatePartValues(Row.of((Object[])new Object[]{1, null, 3, 4})))).isEqualTo("p1=myDefaultname/p2=3/");
    }
}

