/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.src.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.flink.connector.file.src.impl.FileRecords;
import org.apache.flink.connector.file.src.reader.BulkFormat;
import org.apache.flink.connector.file.src.util.RecordAndPosition;
import org.apache.flink.connector.file.src.util.SingletonResultIterator;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class FileRecordsTest {
    FileRecordsTest() {
    }

    @Test
    void testEmptySplits() {
        String split = "empty";
        FileRecords records = FileRecords.finishedSplit((String)"empty");
        Assertions.assertThat((Collection)records.finishedSplits()).isEqualTo(Collections.singleton("empty"));
    }

    @Test
    void testMoveToFirstSplit() {
        String splitId = "splitId";
        FileRecords records = FileRecords.forRecords((String)"splitId", (BulkFormat.RecordIterator)new SingletonResultIterator());
        String firstSplitId = records.nextSplit();
        Assertions.assertThat((String)"splitId").isEqualTo(firstSplitId);
    }

    @Test
    void testMoveToSecondSplit() {
        FileRecords records = FileRecords.forRecords((String)"splitId", (BulkFormat.RecordIterator)new SingletonResultIterator());
        records.nextSplit();
        String secondSplitId = records.nextSplit();
        Assertions.assertThat((String)secondSplitId).isNull();
    }

    @Test
    void testRecordsFromFirstSplit() {
        SingletonResultIterator iter = new SingletonResultIterator();
        iter.set((Object)"test", 18L, 99L);
        FileRecords records = FileRecords.forRecords((String)"splitId", (BulkFormat.RecordIterator)iter);
        records.nextSplit();
        RecordAndPosition recAndPos = records.nextRecordFromSplit();
        Assertions.assertThat((String)((String)recAndPos.getRecord())).isEqualTo("test");
        Assertions.assertThat((long)recAndPos.getOffset()).isEqualTo(18L);
        Assertions.assertThat((long)recAndPos.getRecordSkipCount()).isEqualTo(99L);
    }

    @Test
    void testRecordsInitiallyIllegal() {
        FileRecords records = FileRecords.forRecords((String)"splitId", (BulkFormat.RecordIterator)new SingletonResultIterator());
        Assertions.assertThatThrownBy(() -> ((FileRecords)records).nextRecordFromSplit()).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void testRecordsOnSecondSplitIllegal() {
        FileRecords records = FileRecords.forRecords((String)"splitId", (BulkFormat.RecordIterator)new SingletonResultIterator());
        records.nextSplit();
        records.nextSplit();
        Assertions.assertThatThrownBy(() -> ((FileRecords)records).nextRecordFromSplit()).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void testRecycleExhaustedBatch() {
        AtomicBoolean recycled = new AtomicBoolean(false);
        SingletonResultIterator iter = new SingletonResultIterator(() -> recycled.set(true));
        iter.set(new Object(), 1L, 2L);
        FileRecords records = FileRecords.forRecords((String)"test split", (BulkFormat.RecordIterator)iter);
        records.nextSplit();
        records.nextRecordFromSplit();
        Assertions.assertThat((Object)records.nextRecordFromSplit()).isNull();
        Assertions.assertThat((String)records.nextSplit()).isNull();
        records.recycle();
        Assertions.assertThat((boolean)recycled.get()).isTrue();
    }

    @Test
    void testRecycleNonExhaustedBatch() {
        AtomicBoolean recycled = new AtomicBoolean(false);
        SingletonResultIterator iter = new SingletonResultIterator(() -> recycled.set(true));
        iter.set(new Object(), 1L, 2L);
        FileRecords records = FileRecords.forRecords((String)"test split", (BulkFormat.RecordIterator)iter);
        records.nextSplit();
        records.recycle();
        Assertions.assertThat((boolean)recycled.get()).isTrue();
    }
}

