/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.src;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.BiConsumer;
import org.apache.flink.connector.file.src.FileSourceSplit;
import org.apache.flink.connector.file.src.FileSourceSplitSerializer;
import org.apache.flink.connector.file.src.FileSourceSplitSerializerTest;
import org.apache.flink.connector.file.src.PendingSplitsCheckpoint;
import org.apache.flink.connector.file.src.PendingSplitsCheckpointSerializer;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.io.SimpleVersionedSerialization;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class PendingSplitsCheckpointSerializerTest {
    PendingSplitsCheckpointSerializerTest() {
    }

    @Test
    void serializeEmptyCheckpoint() throws Exception {
        PendingSplitsCheckpoint checkpoint = PendingSplitsCheckpoint.fromCollectionSnapshot(Collections.emptyList());
        PendingSplitsCheckpoint<FileSourceSplit> deSerialized = PendingSplitsCheckpointSerializerTest.serializeAndDeserialize((PendingSplitsCheckpoint<FileSourceSplit>)checkpoint);
        PendingSplitsCheckpointSerializerTest.assertCheckpointsEqual((PendingSplitsCheckpoint<FileSourceSplit>)checkpoint, deSerialized);
    }

    @Test
    void serializeSomeSplits() throws Exception {
        PendingSplitsCheckpoint checkpoint = PendingSplitsCheckpoint.fromCollectionSnapshot(Arrays.asList(PendingSplitsCheckpointSerializerTest.testSplit1(), PendingSplitsCheckpointSerializerTest.testSplit2(), PendingSplitsCheckpointSerializerTest.testSplit3()));
        PendingSplitsCheckpoint<FileSourceSplit> deSerialized = PendingSplitsCheckpointSerializerTest.serializeAndDeserialize((PendingSplitsCheckpoint<FileSourceSplit>)checkpoint);
        PendingSplitsCheckpointSerializerTest.assertCheckpointsEqual((PendingSplitsCheckpoint<FileSourceSplit>)checkpoint, deSerialized);
    }

    @Test
    void serializeSplitsAndProcessedPaths() throws Exception {
        PendingSplitsCheckpoint checkpoint = PendingSplitsCheckpoint.fromCollectionSnapshot(Arrays.asList(PendingSplitsCheckpointSerializerTest.testSplit1(), PendingSplitsCheckpointSerializerTest.testSplit2(), PendingSplitsCheckpointSerializerTest.testSplit3()), Arrays.asList(new Path("file:/some/path"), new Path("s3://bucket/key/and/path"), new Path("hdfs://namenode:12345/path")));
        PendingSplitsCheckpoint<FileSourceSplit> deSerialized = PendingSplitsCheckpointSerializerTest.serializeAndDeserialize((PendingSplitsCheckpoint<FileSourceSplit>)checkpoint);
        PendingSplitsCheckpointSerializerTest.assertCheckpointsEqual((PendingSplitsCheckpoint<FileSourceSplit>)checkpoint, deSerialized);
    }

    @Test
    void repeatedSerialization() throws Exception {
        PendingSplitsCheckpoint checkpoint = PendingSplitsCheckpoint.fromCollectionSnapshot(Arrays.asList(PendingSplitsCheckpointSerializerTest.testSplit3(), PendingSplitsCheckpointSerializerTest.testSplit1()));
        PendingSplitsCheckpointSerializerTest.serializeAndDeserialize((PendingSplitsCheckpoint<FileSourceSplit>)checkpoint);
        PendingSplitsCheckpointSerializerTest.serializeAndDeserialize((PendingSplitsCheckpoint<FileSourceSplit>)checkpoint);
        PendingSplitsCheckpoint<FileSourceSplit> deSerialized = PendingSplitsCheckpointSerializerTest.serializeAndDeserialize((PendingSplitsCheckpoint<FileSourceSplit>)checkpoint);
        PendingSplitsCheckpointSerializerTest.assertCheckpointsEqual((PendingSplitsCheckpoint<FileSourceSplit>)checkpoint, deSerialized);
    }

    @Test
    void repeatedSerializationCaches() throws Exception {
        PendingSplitsCheckpoint checkpoint = PendingSplitsCheckpoint.fromCollectionSnapshot(Collections.singletonList(PendingSplitsCheckpointSerializerTest.testSplit2()));
        byte[] ser1 = new PendingSplitsCheckpointSerializer((SimpleVersionedSerializer)FileSourceSplitSerializer.INSTANCE).serialize(checkpoint);
        byte[] ser2 = new PendingSplitsCheckpointSerializer((SimpleVersionedSerializer)FileSourceSplitSerializer.INSTANCE).serialize(checkpoint);
        Assertions.assertThat((byte[])ser1).isSameAs((Object)ser2);
    }

    private static FileSourceSplit testSplit1() {
        return new FileSourceSplit("random-id", new Path("hdfs://namenode:14565/some/path/to/a/file"), 100000000L, 64000000L, 0L, 200000000L, new String[]{"host1", "host2", "host3"});
    }

    private static FileSourceSplit testSplit2() {
        return new FileSourceSplit("some-id", new Path("file:/some/path/to/a/file"), 0L, 0L, 0L, 0L);
    }

    private static FileSourceSplit testSplit3() {
        return new FileSourceSplit("an-id", new Path("s3://some-bucket/key/to/the/object"), 0L, 1234567L, 0L, 1234567L);
    }

    private static PendingSplitsCheckpoint<FileSourceSplit> serializeAndDeserialize(PendingSplitsCheckpoint<FileSourceSplit> split) throws IOException {
        PendingSplitsCheckpointSerializer serializer = new PendingSplitsCheckpointSerializer((SimpleVersionedSerializer)FileSourceSplitSerializer.INSTANCE);
        byte[] bytes = SimpleVersionedSerialization.writeVersionAndSerialize((SimpleVersionedSerializer)serializer, split);
        return (PendingSplitsCheckpoint)SimpleVersionedSerialization.readVersionAndDeSerialize((SimpleVersionedSerializer)serializer, (byte[])bytes);
    }

    private static void assertCheckpointsEqual(PendingSplitsCheckpoint<FileSourceSplit> expected, PendingSplitsCheckpoint<FileSourceSplit> actual) {
        PendingSplitsCheckpointSerializerTest.assertOrderedCollectionEquals(expected.getSplits(), actual.getSplits(), FileSourceSplitSerializerTest::assertSplitsEqual);
        Assertions.assertThat((Collection)actual.getAlreadyProcessedPaths()).containsExactlyElementsOf((Iterable)expected.getAlreadyProcessedPaths());
    }

    private static <E> void assertOrderedCollectionEquals(Collection<E> expected, Collection<E> actual, BiConsumer<E, E> equalityAsserter) {
        Assertions.assertThat(actual).hasSize(expected.size());
        Iterator<E> expectedIter = expected.iterator();
        Iterator<E> actualIter = actual.iterator();
        while (expectedIter.hasNext()) {
            equalityAsserter.accept(expectedIter.next(), actualIter.next());
        }
    }
}

