/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.src;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.GZIPOutputStream;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.RuntimeExecutionMode;
import org.apache.flink.api.common.eventtime.WatermarkStrategy;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.connector.source.Source;
import org.apache.flink.configuration.BatchExecutionOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.file.src.FileSource;
import org.apache.flink.connector.file.src.reader.StreamFormat;
import org.apache.flink.connector.file.src.reader.TextLineInputFormat;
import org.apache.flink.core.execution.JobClient;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.executiongraph.AccessExecutionJobVertex;
import org.apache.flink.runtime.highavailability.nonha.embedded.HaLeadershipControl;
import org.apache.flink.runtime.minicluster.MiniCluster;
import org.apache.flink.runtime.minicluster.RpcServiceSharing;
import org.apache.flink.runtime.testutils.MiniClusterResourceConfiguration;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.util.RestartStrategyUtils;
import org.apache.flink.test.junit5.InjectMiniCluster;
import org.apache.flink.test.junit5.MiniClusterExtension;
import org.apache.flink.test.util.MiniClusterWithClientResource;
import org.apache.flink.util.CloseableIterator;
import org.apache.flink.util.function.FunctionWithException;
import org.apache.flink.util.function.ThrowingConsumer;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.jupiter.api.io.TempDir;

class FileSourceTextLinesITCase {
    private static final int PARALLELISM = 4;
    private static final int SOURCE_PARALLELISM_UPPER_BOUND = 8;
    @TempDir
    private static java.nio.file.Path tmpDir;
    @RegisterExtension
    private static final MiniClusterExtension MINI_CLUSTER_RESOURCE;
    private static final String[] FILE_PATHS;
    private static final String[] HIDDEN_JUNK_PATHS;
    private static final String[] LINES;
    private static final String[][] LINES_PER_FILE;

    FileSourceTextLinesITCase() {
    }

    @Test
    void testBoundedTextFileSource(@TempDir java.nio.file.Path tmpTestDir, @InjectMiniCluster MiniCluster miniCluster) throws Exception {
        this.testBoundedTextFileSource(tmpTestDir, FailoverType.NONE, miniCluster);
    }

    @Test
    void testBoundedTextFileSourceWithTaskManagerFailover(@TempDir java.nio.file.Path tmpTestDir) throws Exception {
        FileSourceTextLinesITCase.runTestWithNewMiniCluster((ThrowingConsumer<MiniCluster, Exception>)((ThrowingConsumer)miniCluster -> this.testBoundedTextFileSource(tmpTestDir, FailoverType.TM, (MiniCluster)miniCluster)));
    }

    @Test
    void testBoundedTextFileSourceWithJobManagerFailover(@TempDir java.nio.file.Path tmpTestDir) throws Exception {
        FileSourceTextLinesITCase.runTestWithNewMiniCluster((ThrowingConsumer<MiniCluster, Exception>)((ThrowingConsumer)miniCluster -> this.testBoundedTextFileSource(tmpTestDir, FailoverType.JM, (MiniCluster)miniCluster)));
    }

    @Test
    void testBoundedTextFileSourceWithDynamicParallelismInference(@TempDir java.nio.file.Path tmpTestDir, @InjectMiniCluster MiniCluster miniCluster) throws Exception {
        this.testBoundedTextFileSource(tmpTestDir, FailoverType.NONE, miniCluster, true);
    }

    private void testBoundedTextFileSource(java.nio.file.Path tmpTestDir, FailoverType failoverType, MiniCluster miniCluster) throws Exception {
        this.testBoundedTextFileSource(tmpTestDir, failoverType, miniCluster, false);
    }

    private void testBoundedTextFileSource(java.nio.file.Path tmpTestDir, FailoverType failoverType, MiniCluster miniCluster, boolean batchMode) throws Exception {
        File testDir = tmpTestDir.toFile();
        FileSourceTextLinesITCase.writeAllFiles(testDir);
        FileSourceTextLinesITCase.writeHiddenJunkFiles(testDir);
        FileSource source = FileSource.forRecordStreamFormat((StreamFormat)new TextLineInputFormat(), (Path[])new Path[]{Path.fromLocalFile((File)testDir)}).build();
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        RestartStrategyUtils.configureFixedDelayRestartStrategy((StreamExecutionEnvironment)env, (int)1, (long)0L);
        env.setParallelism(4);
        if (batchMode) {
            env.setRuntimeMode(RuntimeExecutionMode.BATCH);
        }
        SingleOutputStreamOperator stream = env.fromSource((Source)source, WatermarkStrategy.noWatermarks(), "file-source").setMaxParallelism(8);
        DataStream streamFailingInTheMiddleOfReading = RecordCounterToFail.wrapWithFailureAfter(stream, LINES.length / 2);
        CloseableIterator iterator = streamFailingInTheMiddleOfReading.collectAsync();
        JobClient client = env.executeAsync("Bounded TextFiles Test");
        JobID jobId = client.getJobID();
        RecordCounterToFail.waitToFail();
        FileSourceTextLinesITCase.triggerFailover(failoverType, jobId, () -> RecordCounterToFail.continueProcessing(), miniCluster);
        ArrayList<String> result = new ArrayList<String>();
        while (iterator.hasNext()) {
            result.add((String)iterator.next());
        }
        FileSourceTextLinesITCase.verifyResult(result);
        if (batchMode) {
            FileSourceTextLinesITCase.verifySourceParallelism((AccessExecutionGraph)miniCluster.getExecutionGraph(jobId).get());
        }
    }

    @Test
    void testContinuousTextFileSource(@TempDir java.nio.file.Path tmpTestDir, @InjectMiniCluster MiniCluster miniCluster) throws Exception {
        this.testContinuousTextFileSource(tmpTestDir, FailoverType.NONE, miniCluster);
    }

    @Test
    void testContinuousTextFileSourceWithTaskManagerFailover(@TempDir java.nio.file.Path tmpTestDir) throws Exception {
        FileSourceTextLinesITCase.runTestWithNewMiniCluster((ThrowingConsumer<MiniCluster, Exception>)((ThrowingConsumer)miniCluster -> this.testContinuousTextFileSource(tmpTestDir, FailoverType.TM, (MiniCluster)miniCluster)));
    }

    @Test
    void testContinuousTextFileSourceWithJobManagerFailover(@TempDir java.nio.file.Path tmpTestDir) throws Exception {
        FileSourceTextLinesITCase.runTestWithNewMiniCluster((ThrowingConsumer<MiniCluster, Exception>)((ThrowingConsumer)miniCluster -> this.testContinuousTextFileSource(tmpTestDir, FailoverType.JM, (MiniCluster)miniCluster)));
    }

    private void testContinuousTextFileSource(java.nio.file.Path tmpTestDir, FailoverType type, MiniCluster miniCluster) throws Exception {
        File testDir = tmpTestDir.toFile();
        FileSource source = ((FileSource.FileSourceBuilder)FileSource.forRecordStreamFormat((StreamFormat)new TextLineInputFormat(), (Path[])new Path[]{Path.fromLocalFile((File)testDir)}).monitorContinuously(Duration.ofMillis(5L))).build();
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.setParallelism(4);
        env.enableCheckpointing(10L);
        DataStreamSource stream = env.fromSource((Source)source, WatermarkStrategy.noWatermarks(), "file-source");
        CloseableIterator iter = stream.collectAsync();
        JobClient client = env.executeAsync("jobExecutionName");
        JobID jobId = client.getJobID();
        int numLinesFirst = LINES_PER_FILE[0].length;
        int numLinesAfter = LINES.length - numLinesFirst;
        FileSourceTextLinesITCase.writeFile(testDir, 0);
        ArrayList<String> result1 = new ArrayList<String>(numLinesFirst);
        while (iter.hasNext()) {
            result1.add((String)iter.next());
            if (result1.size() != numLinesFirst) continue;
        }
        for (int i = 1; i < LINES_PER_FILE.length; ++i) {
            boolean failAfterHalfOfInput;
            Thread.sleep(10L);
            FileSourceTextLinesITCase.writeFile(testDir, i);
            boolean bl = failAfterHalfOfInput = i == LINES_PER_FILE.length / 2;
            if (!failAfterHalfOfInput) continue;
            FileSourceTextLinesITCase.triggerFailover(type, jobId, () -> {}, miniCluster);
        }
        ArrayList<String> result2 = new ArrayList<String>(numLinesAfter);
        while (iter.hasNext()) {
            result2.add((String)iter.next());
            if (result2.size() != numLinesAfter) continue;
        }
        client.cancel().get();
        result1.addAll(result2);
        FileSourceTextLinesITCase.verifyResult(result1);
    }

    private static MiniClusterResourceConfiguration createMiniClusterConfiguration() {
        Configuration configuration = new Configuration();
        configuration.set(BatchExecutionOptions.ADAPTIVE_AUTO_PARALLELISM_DEFAULT_SOURCE_PARALLELISM, (Object)8);
        return new MiniClusterResourceConfiguration.Builder().setNumberTaskManagers(1).setNumberSlotsPerTaskManager(4).setRpcServiceSharing(RpcServiceSharing.DEDICATED).withHaLeadershipControl().setConfiguration(configuration).build();
    }

    private static void runTestWithNewMiniCluster(ThrowingConsumer<MiniCluster, Exception> testMethod) throws Exception {
        MiniClusterWithClientResource miniCluster = null;
        try {
            miniCluster = new MiniClusterWithClientResource(FileSourceTextLinesITCase.createMiniClusterConfiguration());
            miniCluster.before();
            testMethod.accept((Object)miniCluster.getMiniCluster());
        }
        finally {
            if (miniCluster != null) {
                miniCluster.after();
            }
        }
    }

    private static void triggerFailover(FailoverType type, JobID jobId, Runnable afterFailAction, MiniCluster miniCluster) throws Exception {
        switch (type) {
            case NONE: {
                afterFailAction.run();
                break;
            }
            case TM: {
                FileSourceTextLinesITCase.restartTaskManager(afterFailAction, miniCluster);
                break;
            }
            case JM: {
                FileSourceTextLinesITCase.triggerJobManagerFailover(jobId, afterFailAction, miniCluster);
            }
        }
    }

    private static void triggerJobManagerFailover(JobID jobId, Runnable afterFailAction, MiniCluster miniCluster) throws Exception {
        HaLeadershipControl haLeadershipControl = (HaLeadershipControl)miniCluster.getHaLeadershipControl().get();
        haLeadershipControl.revokeJobMasterLeadership(jobId).get();
        afterFailAction.run();
        haLeadershipControl.grantJobMasterLeadership(jobId).get();
    }

    private static void restartTaskManager(Runnable afterFailAction, MiniCluster miniCluster) throws Exception {
        miniCluster.terminateTaskManager(0).get();
        afterFailAction.run();
        miniCluster.startTaskManager();
    }

    private static void verifyResult(List<String> lines) {
        Object[] expected = Arrays.copyOf(LINES, LINES.length);
        Object[] actual = lines.toArray(new String[0]);
        Arrays.sort(expected);
        Arrays.sort(actual);
        Assertions.assertThat((Object[])actual).isEqualTo((Object)expected);
    }

    private static void verifySourceParallelism(AccessExecutionGraph executionGraph) {
        AccessExecutionJobVertex sourceVertex = (AccessExecutionJobVertex)executionGraph.getVerticesTopologically().iterator().next();
        Assertions.assertThat((int)sourceVertex.getParallelism()).isEqualTo(FILE_PATHS.length);
    }

    private static String[][] splitLinesForFiles() {
        String[][] result = new String[FILE_PATHS.length][];
        int linesPerFile = LINES.length / FILE_PATHS.length;
        int linesForLastFile = LINES.length - (FILE_PATHS.length - 1) * linesPerFile;
        int pos = 0;
        for (int i = 0; i < FILE_PATHS.length - 1; ++i) {
            String[] lines = new String[linesPerFile];
            result[i] = lines;
            for (int k = 0; k < lines.length; ++k) {
                lines[k] = LINES[pos++];
            }
        }
        String[] lines = new String[linesForLastFile];
        result[result.length - 1] = lines;
        for (int k = 0; k < lines.length; ++k) {
            lines[k] = LINES[pos++];
        }
        return result;
    }

    private static void writeFile(File testDir, int num) throws IOException {
        File file = new File(testDir, FILE_PATHS[num]);
        FileSourceTextLinesITCase.writeFileAtomically(file, LINES_PER_FILE[num]);
    }

    private static void writeCompressedFile(File testDir, int num) throws IOException {
        File file = new File(testDir, FILE_PATHS[num] + ".gz");
        FileSourceTextLinesITCase.writeFileAtomically(file, LINES_PER_FILE[num], (FunctionWithException<OutputStream, OutputStream, IOException>)((FunctionWithException)GZIPOutputStream::new));
    }

    private static void writeAllFiles(File testDir) throws IOException {
        for (int i = 0; i < FILE_PATHS.length; ++i) {
            if (i % 2 == 0) {
                FileSourceTextLinesITCase.writeFile(testDir, i);
                continue;
            }
            FileSourceTextLinesITCase.writeCompressedFile(testDir, i);
        }
    }

    private static void writeHiddenJunkFiles(File testDir) throws IOException {
        String[] junkContents = new String[]{"This should not end up in the test result.", "Foo bar bazzl junk"};
        for (String junkPath : HIDDEN_JUNK_PATHS) {
            File file = new File(testDir, junkPath);
            FileSourceTextLinesITCase.writeFileAtomically(file, junkContents);
        }
    }

    private static void writeFileAtomically(File file, String[] lines) throws IOException {
        FileSourceTextLinesITCase.writeFileAtomically(file, lines, (FunctionWithException<OutputStream, OutputStream, IOException>)((FunctionWithException)v -> v));
    }

    private static void writeFileAtomically(File file, String[] lines, FunctionWithException<OutputStream, OutputStream, IOException> streamEncoderFactory) throws IOException {
        File stagingFile = new File(tmpDir.getParent().toFile(), ".tmp-" + UUID.randomUUID().toString());
        try (FileOutputStream fileOut = new FileOutputStream(stagingFile);
             OutputStream out = (OutputStream)streamEncoderFactory.apply((Object)fileOut);
             OutputStreamWriter encoder = new OutputStreamWriter(out, StandardCharsets.UTF_8);
             PrintWriter writer = new PrintWriter(encoder);){
            for (String line : lines) {
                writer.println(line);
            }
        }
        File parent = file.getParentFile();
        Assertions.assertThat((parent.mkdirs() || parent.exists() ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((boolean)stagingFile.renameTo(file)).isTrue();
    }

    static {
        MINI_CLUSTER_RESOURCE = new MiniClusterExtension(FileSourceTextLinesITCase.createMiniClusterConfiguration());
        FILE_PATHS = new String[]{"text.2", "nested1/text.1", "text.1", "text.3", "nested2/nested21/text", "nested1/text.2", "nested2/text"};
        HIDDEN_JUNK_PATHS = new String[]{"_something", ".junk", "nested1/.somefile", "othernested/_ignoredfile", "_nested/file", "nested1/.intermediate/somefile"};
        LINES = new String[]{"To be, or not to be,--that is the question:--", "Whether 'tis nobler in the mind to suffer", "The slings and arrows of outrageous fortune", "Or to take arms against a sea of troubles,", "And by opposing end them?--To die,--to sleep,--", "No more; and by a sleep to say we end", "The heartache, and the thousand natural shocks", "That flesh is heir to,--'tis a consummation", "Devoutly to be wish'd. To die,--to sleep;--", "To sleep! perchance to dream:--ay, there's the rub;", "For in that sleep of death what dreams may come,", "When we have shuffled off this mortal coil,", "Must give us pause: there's the respect", "That makes calamity of so long life;", "For who would bear the whips and scorns of time,", "The oppressor's wrong, the proud man's contumely,", "The pangs of despis'd love, the law's delay,", "The insolence of office, and the spurns", "That patient merit of the unworthy takes,", "When he himself might his quietus make", "With a bare bodkin? who would these fardels bear,", "To grunt and sweat under a weary life,", "But that the dread of something after death,--", "The undiscover'd country, from whose bourn", "No traveller returns,--puzzles the will,", "And makes us rather bear those ills we have", "Than fly to others that we know not of?", "Thus conscience does make cowards of us all;", "And thus the native hue of resolution", "Is sicklied o'er with the pale cast of thought;", "And enterprises of great pith and moment,", "With this regard, their currents turn awry,", "And lose the name of action.--Soft you now!", "The fair Ophelia!--Nymph, in thy orisons", "Be all my sins remember'd."};
        LINES_PER_FILE = FileSourceTextLinesITCase.splitLinesForFiles();
    }

    private static class RecordCounterToFail {
        private static AtomicInteger records;
        private static CompletableFuture<Void> fail;
        private static CompletableFuture<Void> continueProcessing;

        private RecordCounterToFail() {
        }

        private static <T> DataStream<T> wrapWithFailureAfter(DataStream<T> stream, int failAfter) {
            records = new AtomicInteger();
            fail = new CompletableFuture();
            continueProcessing = new CompletableFuture();
            return stream.map((MapFunction & Serializable)record -> {
                boolean notFailedYet;
                boolean halfOfInputIsRead = records.incrementAndGet() > failAfter;
                boolean bl = notFailedYet = !fail.isDone();
                if (notFailedYet && halfOfInputIsRead) {
                    fail.complete(null);
                    continueProcessing.get();
                }
                return record;
            });
        }

        private static void waitToFail() throws ExecutionException, InterruptedException {
            fail.get();
        }

        private static void continueProcessing() {
            continueProcessing.complete(null);
        }
    }

    private static enum FailoverType {
        NONE,
        TM,
        JM;

    }
}

