/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.sink.utils;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import org.apache.flink.api.common.serialization.Encoder;
import org.apache.flink.connector.file.sink.compactor.DecoderBasedReader;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.streaming.api.functions.sink.filesystem.BucketAssigner;
import org.apache.flink.streaming.api.functions.sink.filesystem.bucketassigners.SimpleVersionedStringSerializer;
import org.assertj.core.api.AbstractFileAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;

public class IntegerFileSinkTestDataUtils {
    public static void checkIntegerSequenceSinkOutput(String path, int numRecords, int numBuckets, int numSources) throws Exception {
        File dir = new File(path);
        Object[] subDirNames = dir.list();
        Assertions.assertThat((Object[])subDirNames).isNotNull();
        Arrays.sort(subDirNames, Comparator.comparingInt(Integer::parseInt));
        Assertions.assertThat((Object[])subDirNames).hasSize(numBuckets);
        for (int i = 0; i < numBuckets; ++i) {
            Assertions.assertThat((String)subDirNames[i]).isEqualTo(Integer.toString(i));
            File bucketDir = new File(path, (String)subDirNames[i]);
            ((AbstractFileAssert)Assertions.assertThat((File)bucketDir).as(bucketDir.getAbsolutePath() + " Should be a existing directory", new Object[0])).isDirectory();
            HashMap<Integer, Integer> counts = new HashMap<Integer, Integer>();
            Object[] files = bucketDir.listFiles(f -> !f.getName().startsWith("."));
            Assertions.assertThat((Object[])files).isNotNull();
            for (Object file : files) {
                Assertions.assertThat((File)file).isFile();
                try {
                    DataInputStream dataInputStream = new DataInputStream(new FileInputStream((File)file));
                    try {
                        while (true) {
                            int value = dataInputStream.readInt();
                            counts.compute(value, (k, v) -> v == null ? 1 : v + 1);
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            dataInputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (EOFException eOFException) {
                }
            }
            int expectedCount = numRecords / numBuckets + (i < numRecords % numBuckets ? 1 : 0);
            Assertions.assertThat(counts).hasSize(expectedCount);
            for (int j = i; j < numRecords; j += numBuckets) {
                ((AbstractIntegerAssert)Assertions.assertThat((int)counts.getOrDefault(j, 0)).as("The record " + j + " should occur " + numSources + " times,  but only occurs " + counts.getOrDefault(j, 0) + "time", new Object[0])).isEqualTo(numSources);
            }
        }
    }

    public static class ModuloBucketAssigner
    implements BucketAssigner<Integer, String> {
        private final int numBuckets;

        public ModuloBucketAssigner(int numBuckets) {
            this.numBuckets = numBuckets;
        }

        public String getBucketId(Integer element, BucketAssigner.Context context) {
            return Integer.toString(element % this.numBuckets);
        }

        public SimpleVersionedSerializer<String> getSerializer() {
            return SimpleVersionedStringSerializer.INSTANCE;
        }
    }

    public static class IntDecoder
    implements DecoderBasedReader.Decoder<Integer> {
        private InputStream input;

        public void open(InputStream input) throws IOException {
            this.input = input;
        }

        public Integer decodeNext() throws IOException {
            byte[] bytes = new byte[4];
            int read = this.input.read(bytes);
            return read < 0 ? null : Integer.valueOf(ByteBuffer.wrap(bytes).getInt());
        }

        public void close() throws IOException {
            this.input.close();
            this.input = null;
        }
    }

    public static class IntEncoder
    implements Encoder<Integer> {
        public void encode(Integer element, OutputStream stream) throws IOException {
            stream.write(ByteBuffer.allocate(4).putInt(element).array());
            stream.flush();
        }
    }
}

