/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.base.sink.writer;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import org.apache.flink.connector.base.sink.writer.AsyncSinkWriterStateSerializer;
import org.apache.flink.connector.base.sink.writer.AsyncSinkWriterTestUtils;
import org.apache.flink.connector.base.sink.writer.BufferedRequestState;
import org.apache.flink.connector.base.sink.writer.ElementConverter;
import org.junit.jupiter.api.Test;

class AsyncSinkWriterStateSerializerTest {
    AsyncSinkWriterStateSerializerTest() {
    }

    @Test
    void testSerializeAndDeSerialize() throws IOException {
        AsyncSinkWriterStateSerializerImpl stateSerializer = new AsyncSinkWriterStateSerializerImpl();
        BufferedRequestState<String> state = AsyncSinkWriterTestUtils.getTestState((ElementConverter & Serializable)(element, context) -> element, String::length);
        BufferedRequestState deserializedState = stateSerializer.deserialize(0, stateSerializer.serialize(state));
        AsyncSinkWriterTestUtils.assertThatBufferStatesAreEqual(state, deserializedState);
    }

    private static class AsyncSinkWriterStateSerializerImpl
    extends AsyncSinkWriterStateSerializer<String> {
        private AsyncSinkWriterStateSerializerImpl() {
        }

        protected void serializeRequestToStream(String request, DataOutputStream out) throws IOException {
            out.write(request.getBytes(StandardCharsets.UTF_8));
        }

        protected String deserializeRequestFromStream(long requestSize, DataInputStream in) throws IOException {
            byte[] requestData = new byte[(int)requestSize];
            in.read(requestData);
            return new String(requestData, StandardCharsets.UTF_8);
        }

        public int getVersion() {
            return 1;
        }
    }
}

