/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.base.sink.writer;

import java.util.Arrays;
import java.util.List;
import org.apache.flink.connector.base.sink.writer.Batch;
import org.apache.flink.connector.base.sink.writer.DequeRequestBuffer;
import org.apache.flink.connector.base.sink.writer.RequestBuffer;
import org.apache.flink.connector.base.sink.writer.RequestEntryWrapper;
import org.apache.flink.connector.base.sink.writer.SimpleBatchCreator;
import org.apache.flink.connector.base.sink.writer.strategy.RequestInfo;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class SimpleBatchCreatorTest {
    @Test
    public void testCreatNextBatchWithEmptyBuffer() {
        SimpleBatchCreator creator = new SimpleBatchCreator(100L);
        DequeRequestBuffer buffer = new DequeRequestBuffer();
        RequestInfo requestInfo = () -> 10;
        Batch result = creator.createNextBatch(requestInfo, (RequestBuffer)buffer);
        Assertions.assertThat((List)result.getBatchEntries()).isEmpty();
        Assertions.assertThat((int)result.getRecordCount()).isEqualTo(0);
        Assertions.assertThat((long)result.getSizeInBytes()).isEqualTo(0L);
    }

    @Test
    public void testCreateNextBatchRespectsBatchCountLimit() {
        SimpleBatchCreator creator = new SimpleBatchCreator(100L);
        DequeRequestBuffer buffer = new DequeRequestBuffer();
        for (int i = 0; i < 10; ++i) {
            buffer.add(new RequestEntryWrapper((Object)("elem-" + i), 10L), false);
        }
        RequestInfo requestInfo = () -> 5;
        Batch result = creator.createNextBatch(requestInfo, (RequestBuffer)buffer);
        Assertions.assertThat((int)result.getBatchEntries().size()).isEqualTo(5);
        Assertions.assertThat((int)result.getRecordCount()).isEqualTo(5);
        Assertions.assertThat((long)result.getSizeInBytes()).isEqualTo(50L);
        Assertions.assertThat((int)buffer.size()).isEqualTo(5);
    }

    @Test
    public void testCreateNextBatchRespectSizeLimit() {
        SimpleBatchCreator creator = new SimpleBatchCreator(25L);
        DequeRequestBuffer buffer = new DequeRequestBuffer();
        buffer.add(new RequestEntryWrapper((Object)"A", 10L), false);
        buffer.add(new RequestEntryWrapper((Object)"B", 10L), false);
        buffer.add(new RequestEntryWrapper((Object)"C", 10L), false);
        buffer.add(new RequestEntryWrapper((Object)"D", 1L), false);
        RequestInfo requestInfo = new RequestInfo(){

            public int getBatchSize() {
                return 10;
            }
        };
        Batch result = creator.createNextBatch(requestInfo, (RequestBuffer)buffer);
        Assertions.assertThat((List)result.getBatchEntries()).isEqualTo(Arrays.asList("A", "B"));
        Assertions.assertThat((int)result.getRecordCount()).isEqualTo(2);
        Assertions.assertThat((long)result.getSizeInBytes()).isEqualTo(20L);
        Assertions.assertThat((int)buffer.size()).isEqualTo(2);
    }

    @Test
    public void testCreateNextBatchSizeLimitFits() {
        SimpleBatchCreator creator = new SimpleBatchCreator(20L);
        DequeRequestBuffer buffer = new DequeRequestBuffer();
        buffer.add(new RequestEntryWrapper((Object)"A", 10L), false);
        buffer.add(new RequestEntryWrapper((Object)"B", 10L), false);
        buffer.add(new RequestEntryWrapper((Object)"C", 10L), false);
        RequestInfo requestInfo = () -> 10;
        Batch result = creator.createNextBatch(requestInfo, (RequestBuffer)buffer);
        Assertions.assertThat((List)result.getBatchEntries()).isEqualTo(Arrays.asList("A", "B"));
        Assertions.assertThat((int)result.getRecordCount()).isEqualTo(2);
        Assertions.assertThat((long)result.getSizeInBytes()).isEqualTo(20L);
        Assertions.assertThat((int)buffer.size()).isEqualTo(1);
        Assertions.assertThat((String)((String)buffer.peek().getRequestEntry())).isEqualTo("C");
    }

    @Test
    public void testCreateNextBufferPartiallyUsed() {
        SimpleBatchCreator creator = new SimpleBatchCreator(50L);
        DequeRequestBuffer buffer = new DequeRequestBuffer();
        buffer.add(new RequestEntryWrapper((Object)"A", 10L), false);
        buffer.add(new RequestEntryWrapper((Object)"B", 20L), false);
        buffer.add(new RequestEntryWrapper((Object)"C", 20L), false);
        buffer.add(new RequestEntryWrapper((Object)"D", 5L), false);
        RequestInfo requestInfo = () -> 3;
        Batch result = creator.createNextBatch(requestInfo, (RequestBuffer)buffer);
        Assertions.assertThat((List)result.getBatchEntries()).isEqualTo(Arrays.asList("A", "B", "C"));
        Assertions.assertThat((int)result.getRecordCount()).isEqualTo(3);
        Assertions.assertThat((long)result.getSizeInBytes()).isEqualTo(50L);
        Assertions.assertThat((int)buffer.size()).isEqualTo(1);
        Assertions.assertThat((String)((String)buffer.peek().getRequestEntry())).isEqualTo("D");
    }

    @Test
    public void testCreateNextStopWhenAddingNextWouldExceedSize() {
        SimpleBatchCreator creator = new SimpleBatchCreator(30L);
        DequeRequestBuffer buffer = new DequeRequestBuffer();
        buffer.add(new RequestEntryWrapper((Object)"A", 10L), false);
        buffer.add(new RequestEntryWrapper((Object)"B", 20L), false);
        buffer.add(new RequestEntryWrapper((Object)"C", 10L), false);
        RequestInfo requestInfo = () -> 5;
        Batch result = creator.createNextBatch(requestInfo, (RequestBuffer)buffer);
        Assertions.assertThat((List)result.getBatchEntries()).isEqualTo(Arrays.asList("A", "B"));
        Assertions.assertThat((int)result.getRecordCount()).isEqualTo(2);
        Assertions.assertThat((long)result.getSizeInBytes()).isEqualTo(30L);
        Assertions.assertThat((int)buffer.size()).isEqualTo(1);
        Assertions.assertThat((String)((String)buffer.peek().getRequestEntry())).isEqualTo("C");
    }
}

