/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro.utils;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import org.apache.flink.formats.avro.generated.Address;
import org.apache.flink.formats.avro.generated.Colors;
import org.apache.flink.formats.avro.generated.Fixed16;
import org.apache.flink.formats.avro.generated.Fixed2;
import org.apache.flink.formats.avro.generated.SimpleUser;
import org.apache.flink.formats.avro.generated.User;

public class TestDataGenerator {
    public static User generateRandomUser(Random rnd) {
        return new User(TestDataGenerator.generateRandomString(rnd, 50), rnd.nextBoolean() ? null : Integer.valueOf(rnd.nextInt()), rnd.nextBoolean() ? null : TestDataGenerator.generateRandomString(rnd, 6), rnd.nextBoolean() ? null : Long.valueOf(rnd.nextLong()), rnd.nextDouble(), null, rnd.nextBoolean(), TestDataGenerator.generateRandomStringList(rnd, 20, 30), TestDataGenerator.generateRandomBooleanList(rnd, 20), rnd.nextBoolean() ? null : TestDataGenerator.generateRandomStringList(rnd, 20, 20), TestDataGenerator.generateRandomColor(rnd), new HashMap<CharSequence, Long>(), TestDataGenerator.generateRandomFixed16(rnd), TestDataGenerator.generateRandomUnion(rnd), TestDataGenerator.generateRandomAddress(rnd), TestDataGenerator.generateRandomBytes(rnd), LocalDate.parse("2014-03-01"), LocalTime.parse("12:12:12"), LocalTime.ofSecondOfDay(0L).plus(123456L, ChronoUnit.MICROS), Instant.parse("2014-03-01T12:12:12.321Z"), Instant.ofEpochSecond(0L).plus(123456L, ChronoUnit.MICROS), ByteBuffer.wrap(BigDecimal.valueOf(2000L, 2).unscaledValue().toByteArray()), new Fixed2(BigDecimal.valueOf(2000L, 2).unscaledValue().toByteArray()));
    }

    public static SimpleUser generateRandomSimpleUser(Random rnd) {
        return new SimpleUser(TestDataGenerator.generateRandomString(rnd, 50), rnd.nextBoolean() ? null : Integer.valueOf(rnd.nextInt()), rnd.nextBoolean() ? null : TestDataGenerator.generateRandomString(rnd, 6), rnd.nextBoolean() ? null : Long.valueOf(rnd.nextLong()), rnd.nextDouble(), null, rnd.nextBoolean(), TestDataGenerator.generateRandomStringList(rnd, 20, 30), TestDataGenerator.generateRandomBooleanList(rnd, 20), rnd.nextBoolean() ? null : TestDataGenerator.generateRandomStringList(rnd, 20, 20), TestDataGenerator.generateRandomColor(rnd), new HashMap<CharSequence, Long>(), TestDataGenerator.generateRandomFixed16(rnd), TestDataGenerator.generateRandomUnion(rnd), TestDataGenerator.generateRandomAddress(rnd), TestDataGenerator.generateRandomBytes(rnd));
    }

    public static Colors generateRandomColor(Random rnd) {
        return Colors.values()[rnd.nextInt(Colors.values().length)];
    }

    public static Fixed16 generateRandomFixed16(Random rnd) {
        if (rnd.nextBoolean()) {
            return new Fixed16();
        }
        byte[] bytes = new byte[16];
        rnd.nextBytes(bytes);
        return new Fixed16(bytes);
    }

    public static Address generateRandomAddress(Random rnd) {
        return new Address(rnd.nextInt(), TestDataGenerator.generateRandomString(rnd, 20), TestDataGenerator.generateRandomString(rnd, 20), TestDataGenerator.generateRandomString(rnd, 20), TestDataGenerator.generateRandomString(rnd, 20));
    }

    public static ByteBuffer generateRandomBytes(Random rnd) {
        byte[] bytes = new byte[10];
        rnd.nextBytes(bytes);
        return ByteBuffer.wrap(bytes);
    }

    private static List<Boolean> generateRandomBooleanList(Random rnd, int maxEntries) {
        int num = rnd.nextInt(maxEntries + 1);
        ArrayList<Boolean> list = new ArrayList<Boolean>();
        for (int i = 0; i < num; ++i) {
            list.add(rnd.nextBoolean());
        }
        return list;
    }

    private static List<CharSequence> generateRandomStringList(Random rnd, int maxEntries, int maxLen) {
        int num = rnd.nextInt(maxEntries + 1);
        ArrayList<CharSequence> list = new ArrayList<CharSequence>();
        for (int i = 0; i < num; ++i) {
            list.add(TestDataGenerator.generateRandomString(rnd, maxLen));
        }
        return list;
    }

    private static String generateRandomString(Random rnd, int maxLen) {
        char[] chars = new char[rnd.nextInt(maxLen + 1)];
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = (char)rnd.nextInt(55296);
        }
        return new String(chars);
    }

    private static Object generateRandomUnion(Random rnd) {
        if (rnd.nextBoolean()) {
            if (rnd.nextBoolean()) {
                return null;
            }
            return rnd.nextBoolean();
        }
        if (rnd.nextBoolean()) {
            return rnd.nextLong();
        }
        return rnd.nextDouble();
    }
}

