/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro;

import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.PojoTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.core.fs.Path;
import org.apache.flink.formats.avro.AvroInputFormat;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class AvroInputFormatTypeExtractionTest {
    AvroInputFormatTypeExtractionTest() {
    }

    @Test
    void testTypeExtraction() {
        try {
            AvroInputFormat format = new AvroInputFormat(new Path("file:///ignore/this/file"), MyAvroType.class);
            TypeInformation typeInfoDirect = TypeExtractor.getInputFormatTypes((InputFormat)format);
            StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
            DataStreamSource input = env.createInput((InputFormat)format);
            TypeInformation typeInfoDataSet = input.getType();
            Assertions.assertThat((Object)typeInfoDirect).isInstanceOf(PojoTypeInfo.class);
            Assertions.assertThat((Object)typeInfoDataSet).isInstanceOf(PojoTypeInfo.class);
            Assertions.assertThat((Class)typeInfoDirect.getTypeClass()).isEqualTo(MyAvroType.class);
            Assertions.assertThat((Class)typeInfoDataSet.getTypeClass()).isEqualTo(MyAvroType.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }

    public static final class MyAvroType {
        public String theString;
        public MyAvroType recursive;
        private double aDouble;

        public double getaDouble() {
            return this.aDouble;
        }

        public void setaDouble(double aDouble) {
            this.aDouble = aDouble;
        }

        public void setTheString(String theString) {
            this.theString = theString;
        }

        public String getTheString() {
            return this.theString;
        }
    }
}

