/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.io.DatumReader;
import org.apache.avro.reflect.ReflectDatumReader;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.common.typeinfo.TypeHint;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.core.fs.Path;
import org.apache.flink.formats.avro.AvroOutputFormat;
import org.apache.flink.formats.avro.generated.Colors;
import org.apache.flink.formats.avro.generated.Fixed2;
import org.apache.flink.formats.avro.generated.User;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.sink.legacy.OutputFormatSinkFunction;
import org.apache.flink.streaming.api.functions.sink.legacy.SinkFunction;
import org.apache.flink.streaming.api.legacy.io.TextInputFormat;
import org.apache.flink.test.util.JavaProgramTestBaseJUnit4;
import org.apache.flink.test.util.TestBaseUtils;
import org.assertj.core.api.Assertions;

public class AvroOutputFormatITCase
extends JavaProgramTestBaseJUnit4 {
    public static String outputPath1;
    public static String outputPath2;
    public static String inputPath;
    public static String userData;

    protected void preSubmit() throws Exception {
        inputPath = this.createTempFile("user", userData);
        outputPath1 = this.getTempDirPath("avro_output1");
        outputPath2 = this.getTempDirPath("avro_output2");
    }

    protected void testProgram() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        SingleOutputStreamOperator input = env.createInput((InputFormat)new TextInputFormat(new Path(inputPath))).map((MapFunction & Serializable)x -> {
            String[] splits = x.split("\\|");
            return Tuple3.of((Object)splits[0], (Object)Integer.valueOf(splits[1]), (Object)splits[2]);
        }).returns(TypeInformation.of((TypeHint)new TypeHint<Tuple3<String, Integer, String>>(){}));
        SingleOutputStreamOperator specificUser = input.map((MapFunction)new ConvertToUser());
        AvroOutputFormat avroOutputFormat = new AvroOutputFormat(new Path(outputPath1), User.class);
        avroOutputFormat.setCodec(AvroOutputFormat.Codec.SNAPPY);
        avroOutputFormat.setSchema(User.SCHEMA$);
        specificUser.addSink((SinkFunction)new OutputFormatSinkFunction((OutputFormat)avroOutputFormat));
        SingleOutputStreamOperator reflectiveUser = specificUser.map((MapFunction)new ConvertToReflective());
        reflectiveUser.addSink((SinkFunction)new OutputFormatSinkFunction((OutputFormat)new AvroOutputFormat(new Path(outputPath2), ReflectiveUser.class)));
        env.execute();
    }

    protected void postSubmit() throws Exception {
        File[] output1;
        File file1 = TestBaseUtils.asFile((String)outputPath1);
        if (file1.isDirectory()) {
            output1 = file1.listFiles();
            for (File avroOutput : Objects.requireNonNull(output1)) {
                Assertions.assertThat((String)avroOutput.toString()).endsWith((CharSequence)".avro");
            }
        } else {
            output1 = new File[]{file1};
        }
        ArrayList<CallSite> result1 = new ArrayList<CallSite>();
        SpecificDatumReader userDatumReader1 = new SpecificDatumReader(User.class);
        for (File avroOutput : output1) {
            DataFileReader dataFileReader1 = new DataFileReader(avroOutput, (DatumReader)userDatumReader1);
            while (dataFileReader1.hasNext()) {
                User user = (User)((Object)dataFileReader1.next());
                result1.add((CallSite)((Object)(user.getName() + "|" + user.getFavoriteNumber() + "|" + user.getFavoriteColor())));
            }
        }
        Assertions.assertThat(result1).contains((Object[])userData.split("\n"));
        File file2 = TestBaseUtils.asFile((String)outputPath2);
        File[] output2 = file2.isDirectory() ? file2.listFiles() : new File[]{file2};
        ArrayList<CallSite> result2 = new ArrayList<CallSite>();
        ReflectDatumReader userDatumReader2 = new ReflectDatumReader(ReflectiveUser.class);
        for (File avroOutput : Objects.requireNonNull(output2)) {
            DataFileReader dataFileReader2 = new DataFileReader(avroOutput, (DatumReader)userDatumReader2);
            while (dataFileReader2.hasNext()) {
                ReflectiveUser user = (ReflectiveUser)dataFileReader2.next();
                result2.add((CallSite)((Object)(user.getName() + "|" + user.getFavoriteNumber() + "|" + user.getFavoriteColor())));
            }
        }
        Assertions.assertThat(result2).contains((Object[])userData.split("\n"));
    }

    static {
        userData = "alice|1|blue\nbob|2|red\njohn|3|yellow\nwalt|4|black\n";
    }

    private static class ReflectiveUser {
        private String name;
        private int favoriteNumber;
        private String favoriteColor;

        public ReflectiveUser() {
        }

        public ReflectiveUser(String name, int favoriteNumber, String favoriteColor) {
            this.name = name;
            this.favoriteNumber = favoriteNumber;
            this.favoriteColor = favoriteColor;
        }

        public String getName() {
            return this.name;
        }

        public String getFavoriteColor() {
            return this.favoriteColor;
        }

        public int getFavoriteNumber() {
            return this.favoriteNumber;
        }
    }

    private static final class ConvertToReflective
    extends RichMapFunction<User, ReflectiveUser> {
        private ConvertToReflective() {
        }

        public ReflectiveUser map(User value) {
            return new ReflectiveUser(value.getName().toString(), value.getFavoriteNumber(), value.getFavoriteColor().toString());
        }
    }

    private static final class ConvertToUser
    extends RichMapFunction<Tuple3<String, Integer, String>, User> {
        private ConvertToUser() {
        }

        public User map(Tuple3<String, Integer, String> value) {
            User user = new User();
            user.setName((CharSequence)value.f0);
            user.setFavoriteNumber((Integer)value.f1);
            user.setFavoriteColor((CharSequence)value.f2);
            user.setTypeBoolTest(true);
            user.setTypeArrayString(Collections.emptyList());
            user.setTypeArrayBoolean(Collections.emptyList());
            user.setTypeEnum(Colors.BLUE);
            user.setTypeMap(Collections.emptyMap());
            user.setTypeBytes(ByteBuffer.allocate(10));
            user.setTypeDate(LocalDate.parse("2014-03-01"));
            user.setTypeTimeMillis(LocalTime.parse("12:12:12"));
            user.setTypeTimeMicros(LocalTime.ofSecondOfDay(0L).plus(123456L, ChronoUnit.MICROS));
            user.setTypeTimestampMillis(Instant.parse("2014-03-01T12:12:12.321Z"));
            user.setTypeTimestampMicros(Instant.ofEpochSecond(0L).plus(123456L, ChronoUnit.MICROS));
            user.setTypeDecimalBytes(ByteBuffer.wrap(BigDecimal.valueOf(2000L, 2).unscaledValue().toByteArray()));
            user.setTypeDecimalFixed(new Fixed2(BigDecimal.valueOf(2000L, 2).unscaledValue().toByteArray()));
            return user;
        }
    }
}

