/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro;

import java.util.function.Function;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.connector.file.src.FileSourceSplit;
import org.apache.flink.formats.avro.AbstractAvroBulkFormat;
import org.apache.flink.formats.avro.AvroToRowDataConverters;
import org.apache.flink.formats.avro.typeutils.AvroSchemaConverter;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;

public class AvroBulkFormatTestUtils {
    public static final RowType ROW_TYPE = RowType.of((boolean)false, (LogicalType[])new LogicalType[]{DataTypes.STRING().getLogicalType(), DataTypes.STRING().getLogicalType()}, (String[])new String[]{"a", "b"});

    public static class TestingAvroBulkFormat
    extends AbstractAvroBulkFormat<GenericRecord, RowData, FileSourceSplit> {
        protected TestingAvroBulkFormat() {
            super(AvroSchemaConverter.convertToSchema((LogicalType)ROW_TYPE));
        }

        protected GenericRecord createReusedAvroRecord() {
            return new GenericData.Record(this.readerSchema);
        }

        protected Function<GenericRecord, RowData> createConverter() {
            AvroToRowDataConverters.AvroToRowDataConverter converter = AvroToRowDataConverters.createRowConverter((RowType)ROW_TYPE);
            return record -> record == null ? null : (RowData)converter.convert(record);
        }

        public TypeInformation<RowData> getProducedType() {
            return InternalTypeInfo.of((RowType)ROW_TYPE);
        }
    }
}

