/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.mongodb.services;

import org.apache.camel.test.infra.common.services.InfrastructureService;
import org.apache.camel.test.infra.common.services.SimpleTestServiceBuilder;
import org.apache.camel.test.infra.common.services.SingletonService;
import org.apache.camel.test.infra.mongodb.services.MongoDBLocalContainerService;
import org.apache.camel.test.infra.mongodb.services.MongoDBRemoteInfraService;
import org.apache.camel.test.infra.mongodb.services.MongoDBService;

public final class MongoDBServiceFactory {
    private MongoDBServiceFactory() {
    }

    public static SimpleTestServiceBuilder<MongoDBService> builder() {
        return new SimpleTestServiceBuilder("mongodb");
    }

    public static MongoDBService createService() {
        return (MongoDBService)MongoDBServiceFactory.builder().addLocalMapping(MongoDBLocalContainerService::new).addRemoteMapping(MongoDBRemoteService::new).build();
    }

    public static MongoDBService createSingletonService() {
        return SingletonServiceHolder.INSTANCE;
    }

    private static class SingletonServiceHolder {
        static final MongoDBService INSTANCE;

        private SingletonServiceHolder() {
        }

        static {
            SimpleTestServiceBuilder<MongoDBService> instance = MongoDBServiceFactory.builder();
            instance.addLocalMapping(() -> new SingletonMongoDBService(new MongoDBLocalContainerService(), "mongo-db")).addRemoteMapping(MongoDBRemoteService::new);
            INSTANCE = (MongoDBService)instance.build();
        }
    }

    public static class MongoDBRemoteService
    extends MongoDBRemoteInfraService
    implements MongoDBService {
    }

    static class SingletonMongoDBService
    extends SingletonService<MongoDBService>
    implements MongoDBService {
        public SingletonMongoDBService(MongoDBService service, String name) {
            super((InfrastructureService)service, name);
        }

        @Override
        public String getReplicaSetUrl() {
            return ((MongoDBService)this.getService()).getReplicaSetUrl();
        }

        @Override
        public String getConnectionAddress() {
            return ((MongoDBService)this.getService()).getConnectionAddress();
        }
    }
}

