/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.telegram.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.camel.component.telegram.model.InlineKeyboardMarkup;
import org.apache.camel.component.telegram.model.InputMedia;
import org.apache.camel.component.telegram.model.OutgoingMessage;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class EditMessageMediaMessage
extends OutgoingMessage {
    @JsonProperty(value="message_id")
    private Integer messageId;
    @JsonProperty(value="inline_message_id")
    private String inlineMessageId;
    private InputMedia media;
    @JsonProperty(value="reply_markup")
    private InlineKeyboardMarkup replyMarkup;

    public EditMessageMediaMessage(String chatId, Integer messageId, String inlineMessageId, InputMedia media, InlineKeyboardMarkup replyMarkup) {
        this.chatId = chatId;
        this.messageId = messageId;
        this.inlineMessageId = inlineMessageId;
        this.media = media;
        this.replyMarkup = replyMarkup;
    }

    public Integer getMessageId() {
        return this.messageId;
    }

    public String getInlineMessageId() {
        return this.inlineMessageId;
    }

    public InlineKeyboardMarkup getReplyMarkup() {
        return this.replyMarkup;
    }

    public InputMedia getMedia() {
        return this.media;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        protected String chatId;
        private Integer messageId;
        private String inlineMessageId;
        private InputMedia media;
        private InlineKeyboardMarkup replyMarkup;

        private Builder() {
        }

        public Builder messageId(Integer messageId) {
            this.messageId = messageId;
            return this;
        }

        public Builder inlineMessageId(String inlineMessageId) {
            this.inlineMessageId = inlineMessageId;
            return this;
        }

        public Builder media(InputMedia media) {
            this.media = media;
            return this;
        }

        public Builder replyMarkup(InlineKeyboardMarkup replyMarkup) {
            this.replyMarkup = replyMarkup;
            return this;
        }

        public Builder chatId(String chatId) {
            this.chatId = chatId;
            return this;
        }

        public EditMessageMediaMessage build() {
            return new EditMessageMediaMessage(this.chatId, this.messageId, this.inlineMessageId, this.media, this.replyMarkup);
        }
    }
}

