/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.PooledExchange;
import org.apache.camel.clock.Clock;
import org.apache.camel.support.AbstractExchange;
import org.apache.camel.support.DefaultExchange;
import org.apache.camel.support.DefaultMessage;
import org.apache.camel.support.ResetableClock;

public final class DefaultPooledExchange
extends AbstractExchange
implements PooledExchange {
    private final ResetableClock clock;
    private PooledExchange.OnDoneTask onDone;
    private Class<?> originalInClassType;
    private Message originalOut;
    private final ExchangePattern originalPattern;
    private boolean autoRelease;

    public DefaultPooledExchange(CamelContext context) {
        super(context);
        this.originalPattern = this.getPattern();
        this.properties = new ConcurrentHashMap(8);
        this.clock = new ResetableClock();
    }

    public DefaultPooledExchange(Exchange parent) {
        super(parent);
        ResetableClock rs;
        this.originalPattern = parent.getPattern();
        this.properties = new ConcurrentHashMap(8);
        Clock parentClock = parent.getClock();
        this.clock = parentClock instanceof ResetableClock ? (rs = (ResetableClock)parentClock) : new ResetableClock(parent.getClock());
    }

    public DefaultPooledExchange(CamelContext context, ExchangePattern pattern) {
        super(context, pattern);
        this.originalPattern = this.getPattern();
        this.properties = new ConcurrentHashMap(8);
        this.clock = new ResetableClock();
    }

    @Override
    AbstractExchange newCopy() {
        return new DefaultExchange(this);
    }

    public boolean isAutoRelease() {
        return this.autoRelease;
    }

    public void setAutoRelease(boolean autoRelease) {
        this.autoRelease = autoRelease;
    }

    public void onDone(PooledExchange.OnDoneTask task) {
        this.onDone = task;
    }

    public void done() {
        if (this.clock.getCreated() > 0L) {
            this.clock.unset();
            this.properties.clear();
            this.internalProperties.clear();
            if (this.safeCopyProperties != null) {
                this.safeCopyProperties.clear();
            }
            this.exchangeId = null;
            if (this.in != null && this.in.getClass() == this.originalInClassType) {
                this.in.reset();
            } else {
                this.in = null;
            }
            if (this.out != null) {
                this.out.reset();
                this.out = null;
            }
            this.exception = null;
            this.pattern = this.originalPattern;
            this.getExchangeExtension().reset();
            if (this.onDone != null) {
                this.onDone.onDone((Exchange)this);
            }
        }
    }

    @Deprecated(since="4.4.0")
    public void reset(long created) {
        this.clock.reset();
    }

    @Override
    public Message getIn() {
        if (this.in == null) {
            this.in = new DefaultMessage(this.getContext());
            this.originalInClassType = this.in.getClass();
            this.configureMessage(this.in);
        }
        return this.in;
    }

    @Override
    public void setIn(Message in) {
        this.in = in;
        this.configureMessage(in);
        if (in != null) {
            this.originalInClassType = in.getClass();
        }
    }

    @Override
    public Message getOut() {
        if (this.out == null) {
            if (this.originalOut != null) {
                this.out = this.originalOut;
            } else {
                this.out = new DefaultMessage(this);
                this.configureMessage(this.out);
                this.originalOut = this.out;
            }
        }
        return this.out;
    }

    @Override
    public void setOut(Message out) {
        this.out = out;
        if (out != null) {
            this.configureMessage(out);
            this.originalOut = null;
        }
    }

    public Clock getClock() {
        return this.clock;
    }

    public static DefaultPooledExchange newFromEndpoint(Endpoint fromEndpoint) {
        return DefaultPooledExchange.newFromEndpoint(fromEndpoint, fromEndpoint.getExchangePattern());
    }

    public static DefaultPooledExchange newFromEndpoint(Endpoint fromEndpoint, ExchangePattern exchangePattern) {
        DefaultPooledExchange exchange = new DefaultPooledExchange(fromEndpoint.getCamelContext(), exchangePattern);
        exchange.getExchangeExtension().setFromEndpoint(fromEndpoint);
        return exchange;
    }
}

