/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce;

import java.util.concurrent.ExecutorService;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.salesforce.PubSubApiConsumer;
import org.apache.camel.component.salesforce.SalesforceComponent;
import org.apache.camel.component.salesforce.SalesforceConstants;
import org.apache.camel.component.salesforce.SalesforceEndpointConfig;
import org.apache.camel.component.salesforce.SalesforceHttpClient;
import org.apache.camel.component.salesforce.SalesforceProducer;
import org.apache.camel.component.salesforce.StreamingApiConsumer;
import org.apache.camel.component.salesforce.internal.OperationName;
import org.apache.camel.component.salesforce.internal.streaming.SubscriptionHelper;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.support.DefaultEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(firstVersion="2.12.0", scheme="salesforce", title="Salesforce", syntax="salesforce:operationName:topicName", category={Category.CLOUD, Category.SAAS}, headersClass=SalesforceConstants.class)
public class SalesforceEndpoint
extends DefaultEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(SalesforceEndpoint.class);
    @UriPath(label="common", description="The operation to use", enums="getVersions,getResources,getGlobalObjects,getBasicInfo,getDescription,getSObject,createSObject,updateSObject,deleteSObject,getSObjectWithId,upsertSObject,deleteSObjectWithId,getBlobField,query,queryMore,queryAll,search,apexCall,recent,getEventSchema,createJob,getJob,closeJob,abortJob,createBatch,getBatch,getAllBatches,getRequest,getResults,createBatchQuery,getQueryResultIds,getQueryResult,getRecentReports,getReportDescription,executeSyncReport,executeAsyncReport,getReportInstances,getReportResults,limits,approval,approvals,composite-tree,composite-batch,composite,compositeRetrieveSObjectCollections,compositeCreateSObjectCollections,compositeUpdateSObjectCollections,compositeUpsertSObjectCollections,compositeDeleteSObjectCollections,bulk2GetAllJobs,bulk2CreateJob,bulk2GetJob,bulk2CreateBatch,bulk2CloseJob,bulk2AbortJob,bulk2DeleteJob,bulk2GetSuccessfulResults,bulk2GetFailedResults,bulk2GetUnprocessedRecords,bulk2CreateQueryJob,bulk2GetQueryJob,bulk2GetAllQueryJobs,bulk2GetQueryJobResults,bulk2AbortQueryJob,bulk2DeleteQueryJob,raw,subscribe,pubSubSubscribe,pubSubPublish")
    @Metadata(required=true)
    private final OperationName operationName;
    @UriPath(label="consumer,producer", description="The name of the topic/channel to use")
    private final String topicName;
    @UriParam
    private final SalesforceEndpointConfig configuration;
    @UriParam(label="consumer", description="The replayId value to use when subscribing to the Streaming API.")
    private Long replayId;
    @UriParam(label="consumer", description="The replayId value to use when subscribing to the Pub/Sub API.")
    private String pubSubReplayId;
    @UriParam(label="consumer,advanced", description="Use thread pool for processing received Salesforce events, for example to process events in parallel.")
    private boolean consumerWorkerPoolEnabled;
    @UriParam(label="consumer,advanced", description="To use a custom thread pool for processing received Salesforce events, for example to process events in parallel.")
    private ExecutorService consumerWorkerPoolExecutorService;
    @UriParam(label="consumer,advanced", description="Core thread pool size size for consumer worker pool.", defaultValue="10")
    private int consumerWorkerPoolSize = 10;
    @UriParam(label="consumer,advanced", description="Maximum thread pool size size for consumer worker pool.", defaultValue="20")
    private int consumerWorkerPoolMaxSize = 20;

    public SalesforceEndpoint(String uri, SalesforceComponent salesforceComponent, SalesforceEndpointConfig configuration, OperationName operationName, String topicName) {
        super(uri, (Component)salesforceComponent);
        this.configuration = configuration;
        this.operationName = operationName;
        this.topicName = topicName;
    }

    public Producer createProducer() throws Exception {
        if (this.operationName == null) {
            throw new IllegalArgumentException(String.format("Invalid Operation %s", this.topicName));
        }
        return new SalesforceProducer(this);
    }

    protected ExecutorService createExecutorService(Object source) {
        return this.getCamelContext().getExecutorServiceManager().newThreadPool(source, "SalesforceConsumerWorker", this.consumerWorkerPoolSize, this.consumerWorkerPoolMaxSize);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        DefaultConsumer consumer = null;
        switch (this.operationName) {
            case SUBSCRIBE: {
                SubscriptionHelper subscriptionHelper = this.getComponent().getSubscriptionHelper();
                StreamingApiConsumer answer = new StreamingApiConsumer(this, processor, subscriptionHelper);
                answer.setExecutorService(this.consumerWorkerPoolExecutorService);
                consumer = answer;
                break;
            }
            case PUBSUB_SUBSCRIBE: {
                PubSubApiConsumer answer = new PubSubApiConsumer(this, processor);
                answer.setExecutorService(this.consumerWorkerPoolExecutorService);
                consumer = answer;
                break;
            }
        }
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public SalesforceComponent getComponent() {
        return (SalesforceComponent)super.getComponent();
    }

    public SalesforceEndpointConfig getConfiguration() {
        return this.configuration;
    }

    public OperationName getOperationName() {
        return this.operationName;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public void setReplayId(Long replayId) {
        this.replayId = replayId;
    }

    public Long getReplayId() {
        return this.replayId;
    }

    public String getPubSubReplayId() {
        return this.pubSubReplayId;
    }

    public void setPubSubReplayId(String pubSubReplayId) {
        this.pubSubReplayId = pubSubReplayId;
    }

    public boolean isConsumerWorkerPoolEnabled() {
        return this.consumerWorkerPoolEnabled;
    }

    public void setConsumerWorkerPoolEnabled(boolean consumerWorkerPoolEnabled) {
        this.consumerWorkerPoolEnabled = consumerWorkerPoolEnabled;
    }

    public ExecutorService getConsumerWorkerPoolExecutorService() {
        return this.consumerWorkerPoolExecutorService;
    }

    public void setConsumerWorkerPoolExecutorService(ExecutorService consumerWorkerPoolExecutorService) {
        this.consumerWorkerPoolExecutorService = consumerWorkerPoolExecutorService;
    }

    public int getConsumerWorkerPoolSize() {
        return this.consumerWorkerPoolSize;
    }

    public void setConsumerWorkerPoolSize(int consumerWorkerPoolSize) {
        this.consumerWorkerPoolSize = consumerWorkerPoolSize;
    }

    public int getConsumerWorkerPoolMaxSize() {
        return this.consumerWorkerPoolMaxSize;
    }

    public void setConsumerWorkerPoolMaxSize(int consumerWorkerPoolMaxSize) {
        this.consumerWorkerPoolMaxSize = consumerWorkerPoolMaxSize;
    }

    protected void doStart() throws Exception {
        try {
            super.doStart();
        }
        finally {
            SalesforceHttpClient httpClient = this.getConfiguration().getHttpClient();
            if (httpClient == null) {
                httpClient = this.getComponent().getHttpClient();
            }
            if (httpClient != null && this.getComponent().getHttpClient() != httpClient) {
                String endpointUri = this.getEndpointUri();
                LOG.debug("Starting http client for {} ...", (Object)endpointUri);
                httpClient.start();
                LOG.debug("Started http client for {}", (Object)endpointUri);
            }
        }
    }

    protected void doStop() throws Exception {
        try {
            super.doStop();
        }
        finally {
            SalesforceHttpClient httpClient = this.getConfiguration().getHttpClient();
            if (httpClient == null) {
                httpClient = this.getComponent().getHttpClient();
            }
            if (httpClient != null && this.getComponent().getHttpClient() != httpClient) {
                String endpointUri = this.getEndpointUri();
                LOG.debug("Stopping http client for {} ...", (Object)endpointUri);
                httpClient.stop();
                LOG.debug("Stopped http client for {}", (Object)endpointUri);
            }
        }
    }
}

