/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.resilience4j.micrometer;

import io.github.resilience4j.bulkhead.BulkheadRegistry;
import io.github.resilience4j.circuitbreaker.CircuitBreakerRegistry;
import io.github.resilience4j.micrometer.tagged.TaggedBulkheadMetrics;
import io.github.resilience4j.micrometer.tagged.TaggedCircuitBreakerMetrics;
import io.github.resilience4j.micrometer.tagged.TaggedTimeLimiterMetrics;
import io.github.resilience4j.timelimiter.TimeLimiterRegistry;
import io.micrometer.core.instrument.MeterRegistry;
import org.apache.camel.CamelContext;
import org.apache.camel.NonManagedService;
import org.apache.camel.component.micrometer.MicrometerUtils;
import org.apache.camel.spi.Registry;
import org.apache.camel.spi.Resilience4jMicrometerFactory;
import org.apache.camel.spi.annotations.JdkService;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JdkService(value="resilience4j-micrometer-factory")
public class DefaultResilience4jMicrometerFactory
extends ServiceSupport
implements Resilience4jMicrometerFactory,
NonManagedService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultResilience4jMicrometerFactory.class);
    private MeterRegistry meterRegistry;
    private CamelContext camelContext;
    private CircuitBreakerRegistry circuitBreakerRegistry;
    private TimeLimiterRegistry timeLimiterRegistry;
    private BulkheadRegistry bulkheadRegistry;

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public void setMeterRegistry(Object meterRegistry) {
        this.meterRegistry = (MeterRegistry)meterRegistry;
    }

    public MeterRegistry getMeterRegistry() {
        return this.meterRegistry;
    }

    protected void doInit() throws Exception {
        super.doInit();
        if (this.meterRegistry == null) {
            Registry camelRegistry = this.getCamelContext().getRegistry();
            this.meterRegistry = MicrometerUtils.getOrCreateMeterRegistry((Registry)camelRegistry, (String)"metricsRegistry");
        }
        this.circuitBreakerRegistry = (CircuitBreakerRegistry)CamelContextHelper.findSingleByType((CamelContext)this.camelContext, CircuitBreakerRegistry.class);
        if (this.circuitBreakerRegistry == null) {
            this.circuitBreakerRegistry = CircuitBreakerRegistry.ofDefaults();
            this.camelContext.getCamelContextExtension().addContextPlugin(CircuitBreakerRegistry.class, (Object)this.circuitBreakerRegistry);
        }
        this.timeLimiterRegistry = (TimeLimiterRegistry)CamelContextHelper.findSingleByType((CamelContext)this.camelContext, TimeLimiterRegistry.class);
        if (this.timeLimiterRegistry == null) {
            this.timeLimiterRegistry = TimeLimiterRegistry.ofDefaults();
            this.camelContext.getCamelContextExtension().addContextPlugin(TimeLimiterRegistry.class, (Object)this.timeLimiterRegistry);
        }
        this.bulkheadRegistry = (BulkheadRegistry)CamelContextHelper.findSingleByType((CamelContext)this.camelContext, BulkheadRegistry.class);
        if (this.bulkheadRegistry == null) {
            this.bulkheadRegistry = BulkheadRegistry.ofDefaults();
            this.camelContext.getCamelContextExtension().addContextPlugin(BulkheadRegistry.class, (Object)this.bulkheadRegistry);
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
        TaggedCircuitBreakerMetrics.ofCircuitBreakerRegistry((CircuitBreakerRegistry)this.circuitBreakerRegistry).bindTo(this.meterRegistry);
        TaggedTimeLimiterMetrics.ofTimeLimiterRegistry((TimeLimiterRegistry)this.timeLimiterRegistry).bindTo(this.meterRegistry);
        TaggedBulkheadMetrics.ofBulkheadRegistry((BulkheadRegistry)this.bulkheadRegistry).bindTo(this.meterRegistry);
        LOG.info("Enabled Micrometer statistics with Resilience4j Circuit Breakers");
    }
}

