/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.micrometer;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.micrometer.MicrometerEndpoint;
import org.apache.camel.component.micrometer.MicrometerUtils;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.Registry;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@org.apache.camel.spi.annotations.Component(value="micrometer")
public class MicrometerComponent
extends DefaultComponent {
    public static final Meter.Type DEFAULT_METER_TYPE = Meter.Type.COUNTER;
    private static final Logger LOG = LoggerFactory.getLogger(MicrometerComponent.class);
    @Metadata(label="advanced")
    private MeterRegistry metricsRegistry;

    protected void doInit() throws Exception {
        super.doInit();
        if (this.metricsRegistry == null) {
            Registry camelRegistry = this.getCamelContext().getRegistry();
            this.metricsRegistry = MicrometerUtils.getOrCreateMeterRegistry(camelRegistry, "metricsRegistry");
        }
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        String metricsName = this.getMetricsName(remaining);
        Meter.Type metricsType = this.getMetricsType(remaining);
        Map<String, String> map = this.getTags(parameters);
        if (map != null && !map.isEmpty()) {
            LOG.warn("Deprecated tags=key1=value&key2=value2 parameter in use. Migrate to use multi-valued tags.key1=value1&tags.key2=value2 syntax");
        }
        LOG.debug("Metrics type: {}; name: {}", (Object)metricsType, (Object)metricsName);
        MicrometerEndpoint endpoint = new MicrometerEndpoint(uri, (Component)this, this.metricsRegistry, metricsType, metricsName);
        if (map != null) {
            endpoint.setTags(map);
        }
        this.setProperties((Endpoint)endpoint, parameters);
        return endpoint;
    }

    Map<String, String> getTags(Map<String, Object> parameters) {
        String tagsString = (String)this.getAndRemoveParameter(parameters, "tags", String.class, "");
        if (tagsString != null && !tagsString.isEmpty()) {
            HashMap<String, String> answer = new HashMap<String, String>();
            for (String tag : tagsString.split("\\s*,\\s*")) {
                String[] e = tag.split("\\s*=\\s*");
                if (e.length != 2) continue;
                answer.put(e[0], e[1]);
            }
            return answer;
        }
        return null;
    }

    String getMetricsName(String remaining) {
        String name = StringHelper.after((String)remaining, (String)":");
        return name == null ? remaining : name;
    }

    Meter.Type getMetricsType(String remaining) {
        String type = StringHelper.before((String)remaining, (String)":");
        return type == null ? DEFAULT_METER_TYPE : MicrometerUtils.getByName(type);
    }

    public MeterRegistry getMetricsRegistry() {
        return this.metricsRegistry;
    }

    public void setMetricsRegistry(MeterRegistry metricsRegistry) {
        this.metricsRegistry = metricsRegistry;
    }
}

