/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven;

import javax.inject.Inject;
import org.apache.camel.maven.DevMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.eclipse.aether.RepositorySystem;

@Mojo(name="debug", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class DebugMojo
extends DevMojo {
    @Parameter(property="camel.suspend", defaultValue="true")
    private boolean suspend;

    @Inject
    public DebugMojo(RepositorySystem repositorySystem) {
        super(repositorySystem);
    }

    @Override
    protected void beforeBootstrapCamel() throws Exception {
        super.beforeBootstrapCamel();
        System.setProperty("org.apache.camel.jmx.disabled", "false");
        System.setProperty("org.apache.camel.debugger.suspend", Boolean.toString(this.suspend));
        String suspendMode = System.getenv("CAMEL_DEBUGGER_SUSPEND");
        if (suspendMode != null && Boolean.parseBoolean(suspendMode) != this.suspend) {
            throw new MojoExecutionException(String.format("The environment variable %s has been set and prevents to configure the suspend mode. Please remove it first.", "CAMEL_DEBUGGER_SUSPEND"));
        }
    }

    @Override
    protected String goal() {
        return "camel:debug";
    }
}

