/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.keycloak.KeycloakComponent;
import org.apache.camel.component.keycloak.KeycloakConfiguration;
import org.apache.camel.component.keycloak.KeycloakOperations;
import org.keycloak.admin.client.Keycloak;

public interface KeycloakComponentBuilderFactory {
    public static KeycloakComponentBuilder keycloak() {
        return new KeycloakComponentBuilderImpl();
    }

    public static class KeycloakComponentBuilderImpl
    extends AbstractComponentBuilder<KeycloakComponent>
    implements KeycloakComponentBuilder {
        @Override
        protected KeycloakComponent buildConcreteComponent() {
            return new KeycloakComponent();
        }

        private KeycloakConfiguration getOrCreateConfiguration(KeycloakComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new KeycloakConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "accessToken": {
                    this.getOrCreateConfiguration((KeycloakComponent)component).setAccessToken((String)value);
                    return true;
                }
                case "authClient": {
                    this.getOrCreateConfiguration((KeycloakComponent)component).setAuthClient((String)value);
                    return true;
                }
                case "authIpAddress": {
                    this.getOrCreateConfiguration((KeycloakComponent)component).setAuthIpAddress((String)value);
                    return true;
                }
                case "authRealm": {
                    this.getOrCreateConfiguration((KeycloakComponent)component).setAuthRealm((String)value);
                    return true;
                }
                case "authRealmFilter": {
                    this.getOrCreateConfiguration((KeycloakComponent)component).setAuthRealmFilter((String)value);
                    return true;
                }
                case "authUser": {
                    this.getOrCreateConfiguration((KeycloakComponent)component).setAuthUser((String)value);
                    return true;
                }
                case "client": {
                    this.getOrCreateConfiguration((KeycloakComponent)component).setClient((String)value);
                    return true;
                }
                case "clientId": {
                    this.getOrCreateConfiguration((KeycloakComponent)component).setClientId((String)value);
                    return true;
                }
                case "clientSecret": {
                    this.getOrCreateConfiguration((KeycloakComponent)component).setClientSecret((String)value);
                    return true;
                }
                case "configuration": {
                    ((KeycloakComponent)component).setConfiguration((KeycloakConfiguration)value);
                    return true;
                }
                case "dateFrom": {
                    this.getOrCreateConfiguration((KeycloakComponent)component).setDateFrom((String)value);
                    return true;
                }
                case "dateTo": {
                    this.getOrCreateConfiguration((KeycloakComponent)component).setDateTo((String)value);
                    return true;
                }
                case "eventType": {
                    this.getOrCreateConfiguration((KeycloakComponent)component).setEventType((String)value);
                    return true;
                }
                case "first": {
                    this.getOrCreateConfiguration((KeycloakComponent)component).setFirst(((Integer)value).intValue());
                    return true;
                }
                case "introspectionCacheEnabled": {
                    this.getOrCreateConfiguration((KeycloakComponent)component).setIntrospectionCacheEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "introspectionCacheTtl": {
                    this.getOrCreateConfiguration((KeycloakComponent)component).setIntrospectionCacheTtl(((Long)value).longValue());
                    return true;
                }
                case "ipAddress": {
                    this.getOrCreateConfiguration((KeycloakComponent)component).setIpAddress((String)value);
                    return true;
                }
                case "keycloakClient": {
                    this.getOrCreateConfiguration((KeycloakComponent)component).setKeycloakClient((Keycloak)value);
                    return true;
                }
                case "maxResults": {
                    this.getOrCreateConfiguration((KeycloakComponent)component).setMaxResults(((Integer)value).intValue());
                    return true;
                }
                case "operation": {
                    this.getOrCreateConfiguration((KeycloakComponent)component).setOperation((KeycloakOperations)value);
                    return true;
                }
                case "operationTypes": {
                    this.getOrCreateConfiguration((KeycloakComponent)component).setOperationTypes((String)value);
                    return true;
                }
                case "password": {
                    this.getOrCreateConfiguration((KeycloakComponent)component).setPassword((String)value);
                    return true;
                }
                case "pojoRequest": {
                    this.getOrCreateConfiguration((KeycloakComponent)component).setPojoRequest(((Boolean)value).booleanValue());
                    return true;
                }
                case "realm": {
                    this.getOrCreateConfiguration((KeycloakComponent)component).setRealm((String)value);
                    return true;
                }
                case "resourcePath": {
                    this.getOrCreateConfiguration((KeycloakComponent)component).setResourcePath((String)value);
                    return true;
                }
                case "serverUrl": {
                    this.getOrCreateConfiguration((KeycloakComponent)component).setServerUrl((String)value);
                    return true;
                }
                case "types": {
                    this.getOrCreateConfiguration((KeycloakComponent)component).setTypes((String)value);
                    return true;
                }
                case "user": {
                    this.getOrCreateConfiguration((KeycloakComponent)component).setUser((String)value);
                    return true;
                }
                case "username": {
                    this.getOrCreateConfiguration((KeycloakComponent)component).setUsername((String)value);
                    return true;
                }
                case "useTokenIntrospection": {
                    this.getOrCreateConfiguration((KeycloakComponent)component).setUseTokenIntrospection(((Boolean)value).booleanValue());
                    return true;
                }
                case "bridgeErrorHandler": {
                    ((KeycloakComponent)component).setBridgeErrorHandler(((Boolean)value).booleanValue());
                    return true;
                }
                case "lazyStartProducer": {
                    ((KeycloakComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "autowiredEnabled": {
                    ((KeycloakComponent)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
            }
            return false;
        }
    }

    public static interface KeycloakComponentBuilder
    extends ComponentBuilder<KeycloakComponent> {
        default public KeycloakComponentBuilder accessToken(String accessToken) {
            this.doSetProperty("accessToken", accessToken);
            return this;
        }

        default public KeycloakComponentBuilder authClient(String authClient) {
            this.doSetProperty("authClient", authClient);
            return this;
        }

        default public KeycloakComponentBuilder authIpAddress(String authIpAddress) {
            this.doSetProperty("authIpAddress", authIpAddress);
            return this;
        }

        default public KeycloakComponentBuilder authRealm(String authRealm) {
            this.doSetProperty("authRealm", authRealm);
            return this;
        }

        default public KeycloakComponentBuilder authRealmFilter(String authRealmFilter) {
            this.doSetProperty("authRealmFilter", authRealmFilter);
            return this;
        }

        default public KeycloakComponentBuilder authUser(String authUser) {
            this.doSetProperty("authUser", authUser);
            return this;
        }

        default public KeycloakComponentBuilder client(String client) {
            this.doSetProperty("client", client);
            return this;
        }

        default public KeycloakComponentBuilder clientId(String clientId) {
            this.doSetProperty("clientId", clientId);
            return this;
        }

        default public KeycloakComponentBuilder clientSecret(String clientSecret) {
            this.doSetProperty("clientSecret", clientSecret);
            return this;
        }

        default public KeycloakComponentBuilder configuration(KeycloakConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public KeycloakComponentBuilder dateFrom(String dateFrom) {
            this.doSetProperty("dateFrom", dateFrom);
            return this;
        }

        default public KeycloakComponentBuilder dateTo(String dateTo) {
            this.doSetProperty("dateTo", dateTo);
            return this;
        }

        default public KeycloakComponentBuilder eventType(String eventType) {
            this.doSetProperty("eventType", eventType);
            return this;
        }

        default public KeycloakComponentBuilder first(int first) {
            this.doSetProperty("first", first);
            return this;
        }

        default public KeycloakComponentBuilder introspectionCacheEnabled(boolean introspectionCacheEnabled) {
            this.doSetProperty("introspectionCacheEnabled", introspectionCacheEnabled);
            return this;
        }

        default public KeycloakComponentBuilder introspectionCacheTtl(long introspectionCacheTtl) {
            this.doSetProperty("introspectionCacheTtl", introspectionCacheTtl);
            return this;
        }

        default public KeycloakComponentBuilder ipAddress(String ipAddress) {
            this.doSetProperty("ipAddress", ipAddress);
            return this;
        }

        default public KeycloakComponentBuilder keycloakClient(Keycloak keycloakClient) {
            this.doSetProperty("keycloakClient", keycloakClient);
            return this;
        }

        default public KeycloakComponentBuilder maxResults(int maxResults) {
            this.doSetProperty("maxResults", maxResults);
            return this;
        }

        default public KeycloakComponentBuilder operation(KeycloakOperations operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        default public KeycloakComponentBuilder operationTypes(String operationTypes) {
            this.doSetProperty("operationTypes", operationTypes);
            return this;
        }

        default public KeycloakComponentBuilder password(String password) {
            this.doSetProperty("password", password);
            return this;
        }

        default public KeycloakComponentBuilder pojoRequest(boolean pojoRequest) {
            this.doSetProperty("pojoRequest", pojoRequest);
            return this;
        }

        default public KeycloakComponentBuilder realm(String realm) {
            this.doSetProperty("realm", realm);
            return this;
        }

        default public KeycloakComponentBuilder resourcePath(String resourcePath) {
            this.doSetProperty("resourcePath", resourcePath);
            return this;
        }

        default public KeycloakComponentBuilder serverUrl(String serverUrl) {
            this.doSetProperty("serverUrl", serverUrl);
            return this;
        }

        default public KeycloakComponentBuilder types(String types) {
            this.doSetProperty("types", types);
            return this;
        }

        default public KeycloakComponentBuilder user(String user) {
            this.doSetProperty("user", user);
            return this;
        }

        default public KeycloakComponentBuilder username(String username) {
            this.doSetProperty("username", username);
            return this;
        }

        default public KeycloakComponentBuilder useTokenIntrospection(boolean useTokenIntrospection) {
            this.doSetProperty("useTokenIntrospection", useTokenIntrospection);
            return this;
        }

        default public KeycloakComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public KeycloakComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public KeycloakComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }
    }
}

