/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import com.ibm.cloud.objectstorage.services.s3.AmazonS3;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.ibm.cos.IBMCOSComponent;
import org.apache.camel.component.ibm.cos.IBMCOSConfiguration;
import org.apache.camel.component.ibm.cos.IBMCOSOperations;

public interface IbmCosComponentBuilderFactory {
    public static IbmCosComponentBuilder ibmCos() {
        return new IbmCosComponentBuilderImpl();
    }

    public static class IbmCosComponentBuilderImpl
    extends AbstractComponentBuilder<IBMCOSComponent>
    implements IbmCosComponentBuilder {
        @Override
        protected IBMCOSComponent buildConcreteComponent() {
            return new IBMCOSComponent();
        }

        private IBMCOSConfiguration getOrCreateConfiguration(IBMCOSComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new IBMCOSConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "autoCreateBucket": {
                    this.getOrCreateConfiguration((IBMCOSComponent)component).setAutoCreateBucket(((Boolean)value).booleanValue());
                    return true;
                }
                case "configuration": {
                    ((IBMCOSComponent)component).setConfiguration((IBMCOSConfiguration)value);
                    return true;
                }
                case "delimiter": {
                    this.getOrCreateConfiguration((IBMCOSComponent)component).setDelimiter((String)value);
                    return true;
                }
                case "endpointUrl": {
                    this.getOrCreateConfiguration((IBMCOSComponent)component).setEndpointUrl((String)value);
                    return true;
                }
                case "location": {
                    this.getOrCreateConfiguration((IBMCOSComponent)component).setLocation((String)value);
                    return true;
                }
                case "prefix": {
                    this.getOrCreateConfiguration((IBMCOSComponent)component).setPrefix((String)value);
                    return true;
                }
                case "bridgeErrorHandler": {
                    ((IBMCOSComponent)component).setBridgeErrorHandler(((Boolean)value).booleanValue());
                    return true;
                }
                case "deleteAfterRead": {
                    this.getOrCreateConfiguration((IBMCOSComponent)component).setDeleteAfterRead(((Boolean)value).booleanValue());
                    return true;
                }
                case "destinationBucket": {
                    this.getOrCreateConfiguration((IBMCOSComponent)component).setDestinationBucket((String)value);
                    return true;
                }
                case "destinationBucketPrefix": {
                    this.getOrCreateConfiguration((IBMCOSComponent)component).setDestinationBucketPrefix((String)value);
                    return true;
                }
                case "destinationBucketSuffix": {
                    this.getOrCreateConfiguration((IBMCOSComponent)component).setDestinationBucketSuffix((String)value);
                    return true;
                }
                case "fileName": {
                    this.getOrCreateConfiguration((IBMCOSComponent)component).setFileName((String)value);
                    return true;
                }
                case "includeBody": {
                    this.getOrCreateConfiguration((IBMCOSComponent)component).setIncludeBody(((Boolean)value).booleanValue());
                    return true;
                }
                case "includeFolders": {
                    this.getOrCreateConfiguration((IBMCOSComponent)component).setIncludeFolders(((Boolean)value).booleanValue());
                    return true;
                }
                case "moveAfterRead": {
                    this.getOrCreateConfiguration((IBMCOSComponent)component).setMoveAfterRead(((Boolean)value).booleanValue());
                    return true;
                }
                case "autocloseBody": {
                    this.getOrCreateConfiguration((IBMCOSComponent)component).setAutocloseBody(((Boolean)value).booleanValue());
                    return true;
                }
                case "deleteAfterWrite": {
                    this.getOrCreateConfiguration((IBMCOSComponent)component).setDeleteAfterWrite(((Boolean)value).booleanValue());
                    return true;
                }
                case "keyName": {
                    this.getOrCreateConfiguration((IBMCOSComponent)component).setKeyName((String)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((IBMCOSComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "multiPartUpload": {
                    this.getOrCreateConfiguration((IBMCOSComponent)component).setMultiPartUpload(((Boolean)value).booleanValue());
                    return true;
                }
                case "operation": {
                    this.getOrCreateConfiguration((IBMCOSComponent)component).setOperation((IBMCOSOperations)value);
                    return true;
                }
                case "partSize": {
                    this.getOrCreateConfiguration((IBMCOSComponent)component).setPartSize(((Long)value).longValue());
                    return true;
                }
                case "storageClass": {
                    this.getOrCreateConfiguration((IBMCOSComponent)component).setStorageClass((String)value);
                    return true;
                }
                case "autowiredEnabled": {
                    ((IBMCOSComponent)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "cosClient": {
                    this.getOrCreateConfiguration((IBMCOSComponent)component).setCosClient((AmazonS3)value);
                    return true;
                }
                case "healthCheckConsumerEnabled": {
                    ((IBMCOSComponent)component).setHealthCheckConsumerEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "healthCheckProducerEnabled": {
                    ((IBMCOSComponent)component).setHealthCheckProducerEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "apiKey": {
                    this.getOrCreateConfiguration((IBMCOSComponent)component).setApiKey((String)value);
                    return true;
                }
                case "serviceInstanceId": {
                    this.getOrCreateConfiguration((IBMCOSComponent)component).setServiceInstanceId((String)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface IbmCosComponentBuilder
    extends ComponentBuilder<IBMCOSComponent> {
        default public IbmCosComponentBuilder autoCreateBucket(boolean autoCreateBucket) {
            this.doSetProperty("autoCreateBucket", autoCreateBucket);
            return this;
        }

        default public IbmCosComponentBuilder configuration(IBMCOSConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public IbmCosComponentBuilder delimiter(String delimiter) {
            this.doSetProperty("delimiter", delimiter);
            return this;
        }

        default public IbmCosComponentBuilder endpointUrl(String endpointUrl) {
            this.doSetProperty("endpointUrl", endpointUrl);
            return this;
        }

        default public IbmCosComponentBuilder location(String location) {
            this.doSetProperty("location", location);
            return this;
        }

        default public IbmCosComponentBuilder prefix(String prefix) {
            this.doSetProperty("prefix", prefix);
            return this;
        }

        default public IbmCosComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public IbmCosComponentBuilder deleteAfterRead(boolean deleteAfterRead) {
            this.doSetProperty("deleteAfterRead", deleteAfterRead);
            return this;
        }

        default public IbmCosComponentBuilder destinationBucket(String destinationBucket) {
            this.doSetProperty("destinationBucket", destinationBucket);
            return this;
        }

        default public IbmCosComponentBuilder destinationBucketPrefix(String destinationBucketPrefix) {
            this.doSetProperty("destinationBucketPrefix", destinationBucketPrefix);
            return this;
        }

        default public IbmCosComponentBuilder destinationBucketSuffix(String destinationBucketSuffix) {
            this.doSetProperty("destinationBucketSuffix", destinationBucketSuffix);
            return this;
        }

        default public IbmCosComponentBuilder fileName(String fileName) {
            this.doSetProperty("fileName", fileName);
            return this;
        }

        default public IbmCosComponentBuilder includeBody(boolean includeBody) {
            this.doSetProperty("includeBody", includeBody);
            return this;
        }

        default public IbmCosComponentBuilder includeFolders(boolean includeFolders) {
            this.doSetProperty("includeFolders", includeFolders);
            return this;
        }

        default public IbmCosComponentBuilder moveAfterRead(boolean moveAfterRead) {
            this.doSetProperty("moveAfterRead", moveAfterRead);
            return this;
        }

        default public IbmCosComponentBuilder autocloseBody(boolean autocloseBody) {
            this.doSetProperty("autocloseBody", autocloseBody);
            return this;
        }

        default public IbmCosComponentBuilder deleteAfterWrite(boolean deleteAfterWrite) {
            this.doSetProperty("deleteAfterWrite", deleteAfterWrite);
            return this;
        }

        default public IbmCosComponentBuilder keyName(String keyName) {
            this.doSetProperty("keyName", keyName);
            return this;
        }

        default public IbmCosComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public IbmCosComponentBuilder multiPartUpload(boolean multiPartUpload) {
            this.doSetProperty("multiPartUpload", multiPartUpload);
            return this;
        }

        default public IbmCosComponentBuilder operation(IBMCOSOperations operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        default public IbmCosComponentBuilder partSize(long partSize) {
            this.doSetProperty("partSize", partSize);
            return this;
        }

        default public IbmCosComponentBuilder storageClass(String storageClass) {
            this.doSetProperty("storageClass", storageClass);
            return this;
        }

        default public IbmCosComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }

        default public IbmCosComponentBuilder cosClient(AmazonS3 cosClient) {
            this.doSetProperty("cosClient", cosClient);
            return this;
        }

        default public IbmCosComponentBuilder healthCheckConsumerEnabled(boolean healthCheckConsumerEnabled) {
            this.doSetProperty("healthCheckConsumerEnabled", healthCheckConsumerEnabled);
            return this;
        }

        default public IbmCosComponentBuilder healthCheckProducerEnabled(boolean healthCheckProducerEnabled) {
            this.doSetProperty("healthCheckProducerEnabled", healthCheckProducerEnabled);
            return this;
        }

        default public IbmCosComponentBuilder apiKey(String apiKey) {
            this.doSetProperty("apiKey", apiKey);
            return this;
        }

        default public IbmCosComponentBuilder serviceInstanceId(String serviceInstanceId) {
            this.doSetProperty("serviceInstanceId", serviceInstanceId);
            return this;
        }
    }
}

