/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageClass;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.google.storage.GoogleCloudStorageComponent;
import org.apache.camel.component.google.storage.GoogleCloudStorageConfiguration;
import org.apache.camel.component.google.storage.GoogleCloudStorageOperations;

public interface GoogleStorageComponentBuilderFactory {
    public static GoogleStorageComponentBuilder googleStorage() {
        return new GoogleStorageComponentBuilderImpl();
    }

    public static class GoogleStorageComponentBuilderImpl
    extends AbstractComponentBuilder<GoogleCloudStorageComponent>
    implements GoogleStorageComponentBuilder {
        @Override
        protected GoogleCloudStorageComponent buildConcreteComponent() {
            return new GoogleCloudStorageComponent();
        }

        private GoogleCloudStorageConfiguration getOrCreateConfiguration(GoogleCloudStorageComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new GoogleCloudStorageConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "autoCreateBucket": {
                    this.getOrCreateConfiguration((GoogleCloudStorageComponent)component).setAutoCreateBucket(((Boolean)value).booleanValue());
                    return true;
                }
                case "configuration": {
                    ((GoogleCloudStorageComponent)component).setConfiguration((GoogleCloudStorageConfiguration)value);
                    return true;
                }
                case "serviceAccountKey": {
                    this.getOrCreateConfiguration((GoogleCloudStorageComponent)component).setServiceAccountKey((String)value);
                    return true;
                }
                case "storageClass": {
                    this.getOrCreateConfiguration((GoogleCloudStorageComponent)component).setStorageClass((StorageClass)value);
                    return true;
                }
                case "storageClient": {
                    this.getOrCreateConfiguration((GoogleCloudStorageComponent)component).setStorageClient((Storage)value);
                    return true;
                }
                case "storageLocation": {
                    this.getOrCreateConfiguration((GoogleCloudStorageComponent)component).setStorageLocation((String)value);
                    return true;
                }
                case "bridgeErrorHandler": {
                    ((GoogleCloudStorageComponent)component).setBridgeErrorHandler(((Boolean)value).booleanValue());
                    return true;
                }
                case "deleteAfterRead": {
                    this.getOrCreateConfiguration((GoogleCloudStorageComponent)component).setDeleteAfterRead(((Boolean)value).booleanValue());
                    return true;
                }
                case "destinationBucket": {
                    this.getOrCreateConfiguration((GoogleCloudStorageComponent)component).setDestinationBucket((String)value);
                    return true;
                }
                case "downloadFileName": {
                    this.getOrCreateConfiguration((GoogleCloudStorageComponent)component).setDownloadFileName((String)value);
                    return true;
                }
                case "filter": {
                    this.getOrCreateConfiguration((GoogleCloudStorageComponent)component).setFilter((String)value);
                    return true;
                }
                case "includeBody": {
                    this.getOrCreateConfiguration((GoogleCloudStorageComponent)component).setIncludeBody(((Boolean)value).booleanValue());
                    return true;
                }
                case "includeFolders": {
                    this.getOrCreateConfiguration((GoogleCloudStorageComponent)component).setIncludeFolders(((Boolean)value).booleanValue());
                    return true;
                }
                case "moveAfterRead": {
                    this.getOrCreateConfiguration((GoogleCloudStorageComponent)component).setMoveAfterRead(((Boolean)value).booleanValue());
                    return true;
                }
                case "prefix": {
                    this.getOrCreateConfiguration((GoogleCloudStorageComponent)component).setPrefix((String)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((GoogleCloudStorageComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "objectName": {
                    this.getOrCreateConfiguration((GoogleCloudStorageComponent)component).setObjectName((String)value);
                    return true;
                }
                case "operation": {
                    this.getOrCreateConfiguration((GoogleCloudStorageComponent)component).setOperation((GoogleCloudStorageOperations)value);
                    return true;
                }
                case "autowiredEnabled": {
                    ((GoogleCloudStorageComponent)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "healthCheckConsumerEnabled": {
                    ((GoogleCloudStorageComponent)component).setHealthCheckConsumerEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "healthCheckProducerEnabled": {
                    ((GoogleCloudStorageComponent)component).setHealthCheckProducerEnabled(((Boolean)value).booleanValue());
                    return true;
                }
            }
            return false;
        }
    }

    public static interface GoogleStorageComponentBuilder
    extends ComponentBuilder<GoogleCloudStorageComponent> {
        default public GoogleStorageComponentBuilder autoCreateBucket(boolean autoCreateBucket) {
            this.doSetProperty("autoCreateBucket", autoCreateBucket);
            return this;
        }

        default public GoogleStorageComponentBuilder configuration(GoogleCloudStorageConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public GoogleStorageComponentBuilder serviceAccountKey(String serviceAccountKey) {
            this.doSetProperty("serviceAccountKey", serviceAccountKey);
            return this;
        }

        default public GoogleStorageComponentBuilder storageClass(StorageClass storageClass) {
            this.doSetProperty("storageClass", storageClass);
            return this;
        }

        default public GoogleStorageComponentBuilder storageClient(Storage storageClient) {
            this.doSetProperty("storageClient", storageClient);
            return this;
        }

        default public GoogleStorageComponentBuilder storageLocation(String storageLocation) {
            this.doSetProperty("storageLocation", storageLocation);
            return this;
        }

        default public GoogleStorageComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public GoogleStorageComponentBuilder deleteAfterRead(boolean deleteAfterRead) {
            this.doSetProperty("deleteAfterRead", deleteAfterRead);
            return this;
        }

        default public GoogleStorageComponentBuilder destinationBucket(String destinationBucket) {
            this.doSetProperty("destinationBucket", destinationBucket);
            return this;
        }

        default public GoogleStorageComponentBuilder downloadFileName(String downloadFileName) {
            this.doSetProperty("downloadFileName", downloadFileName);
            return this;
        }

        default public GoogleStorageComponentBuilder filter(String filter) {
            this.doSetProperty("filter", filter);
            return this;
        }

        default public GoogleStorageComponentBuilder includeBody(boolean includeBody) {
            this.doSetProperty("includeBody", includeBody);
            return this;
        }

        default public GoogleStorageComponentBuilder includeFolders(boolean includeFolders) {
            this.doSetProperty("includeFolders", includeFolders);
            return this;
        }

        default public GoogleStorageComponentBuilder moveAfterRead(boolean moveAfterRead) {
            this.doSetProperty("moveAfterRead", moveAfterRead);
            return this;
        }

        default public GoogleStorageComponentBuilder prefix(String prefix) {
            this.doSetProperty("prefix", prefix);
            return this;
        }

        default public GoogleStorageComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public GoogleStorageComponentBuilder objectName(String objectName) {
            this.doSetProperty("objectName", objectName);
            return this;
        }

        default public GoogleStorageComponentBuilder operation(GoogleCloudStorageOperations operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        default public GoogleStorageComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }

        default public GoogleStorageComponentBuilder healthCheckConsumerEnabled(boolean healthCheckConsumerEnabled) {
            this.doSetProperty("healthCheckConsumerEnabled", healthCheckConsumerEnabled);
            return this;
        }

        default public GoogleStorageComponentBuilder healthCheckProducerEnabled(boolean healthCheckProducerEnabled) {
            this.doSetProperty("healthCheckProducerEnabled", healthCheckProducerEnabled);
            return this;
        }
    }
}

