/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.cyberark.vault.CyberArkVaultComponent;
import org.apache.camel.component.cyberark.vault.CyberArkVaultConfiguration;
import org.apache.camel.component.cyberark.vault.client.ConjurClient;

public interface CyberarkVaultComponentBuilderFactory {
    public static CyberarkVaultComponentBuilder cyberarkVault() {
        return new CyberarkVaultComponentBuilderImpl();
    }

    public static class CyberarkVaultComponentBuilderImpl
    extends AbstractComponentBuilder<CyberArkVaultComponent>
    implements CyberarkVaultComponentBuilder {
        @Override
        protected CyberArkVaultComponent buildConcreteComponent() {
            return new CyberArkVaultComponent();
        }

        private CyberArkVaultConfiguration getOrCreateConfiguration(CyberArkVaultComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new CyberArkVaultConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "account": {
                    this.getOrCreateConfiguration((CyberArkVaultComponent)component).setAccount((String)value);
                    return true;
                }
                case "certificatePath": {
                    this.getOrCreateConfiguration((CyberArkVaultComponent)component).setCertificatePath((String)value);
                    return true;
                }
                case "configuration": {
                    ((CyberArkVaultComponent)component).setConfiguration((CyberArkVaultConfiguration)value);
                    return true;
                }
                case "conjurClient": {
                    this.getOrCreateConfiguration((CyberArkVaultComponent)component).setConjurClient((ConjurClient)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((CyberArkVaultComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "secretId": {
                    this.getOrCreateConfiguration((CyberArkVaultComponent)component).setSecretId((String)value);
                    return true;
                }
                case "url": {
                    this.getOrCreateConfiguration((CyberArkVaultComponent)component).setUrl((String)value);
                    return true;
                }
                case "verifySsl": {
                    this.getOrCreateConfiguration((CyberArkVaultComponent)component).setVerifySsl(((Boolean)value).booleanValue());
                    return true;
                }
                case "autowiredEnabled": {
                    ((CyberArkVaultComponent)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "apiKey": {
                    this.getOrCreateConfiguration((CyberArkVaultComponent)component).setApiKey((String)value);
                    return true;
                }
                case "authToken": {
                    this.getOrCreateConfiguration((CyberArkVaultComponent)component).setAuthToken((String)value);
                    return true;
                }
                case "password": {
                    this.getOrCreateConfiguration((CyberArkVaultComponent)component).setPassword((String)value);
                    return true;
                }
                case "username": {
                    this.getOrCreateConfiguration((CyberArkVaultComponent)component).setUsername((String)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface CyberarkVaultComponentBuilder
    extends ComponentBuilder<CyberArkVaultComponent> {
        default public CyberarkVaultComponentBuilder account(String account) {
            this.doSetProperty("account", account);
            return this;
        }

        default public CyberarkVaultComponentBuilder certificatePath(String certificatePath) {
            this.doSetProperty("certificatePath", certificatePath);
            return this;
        }

        default public CyberarkVaultComponentBuilder configuration(CyberArkVaultConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public CyberarkVaultComponentBuilder conjurClient(ConjurClient conjurClient) {
            this.doSetProperty("conjurClient", conjurClient);
            return this;
        }

        default public CyberarkVaultComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public CyberarkVaultComponentBuilder secretId(String secretId) {
            this.doSetProperty("secretId", secretId);
            return this;
        }

        default public CyberarkVaultComponentBuilder url(String url) {
            this.doSetProperty("url", url);
            return this;
        }

        default public CyberarkVaultComponentBuilder verifySsl(boolean verifySsl) {
            this.doSetProperty("verifySsl", verifySsl);
            return this;
        }

        default public CyberarkVaultComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }

        default public CyberarkVaultComponentBuilder apiKey(String apiKey) {
            this.doSetProperty("apiKey", apiKey);
            return this;
        }

        default public CyberarkVaultComponentBuilder authToken(String authToken) {
            this.doSetProperty("authToken", authToken);
            return this;
        }

        default public CyberarkVaultComponentBuilder password(String password) {
            this.doSetProperty("password", password);
            return this;
        }

        default public CyberarkVaultComponentBuilder username(String username) {
            this.doSetProperty("username", username);
            return this;
        }
    }
}

