/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.eventhubs;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class EventHubsEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":namespace/eventHubName";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;
    private static final Map<String, String> MULTI_VALUE_PREFIXES;

    public boolean isEnabled(String scheme) {
        return "azure-eventhubs".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax = scheme + BASE;
        Object uri = syntax;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, (String)uri, "namespace", null, false, copy);
        uri = this.buildPathParameter(syntax, (String)uri, "eventHubName", null, false, copy);
        uri = this.buildQueryParameters((String)uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public Map<String, String> multiValuePrefixes() {
        return MULTI_VALUE_PREFIXES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(26);
        props.add("amqpRetryOptions");
        props.add("amqpTransportType");
        props.add("blobAccessKey");
        props.add("blobAccountName");
        props.add("blobContainerName");
        props.add("blobStorageSharedKeyCredential");
        props.add("bridgeErrorHandler");
        props.add("checkpointBatchSize");
        props.add("checkpointBatchTimeout");
        props.add("checkpointStore");
        props.add("connectionString");
        props.add("consumerGroupName");
        props.add("credentialType");
        props.add("eventHubName");
        props.add("eventPosition");
        props.add("exceptionHandler");
        props.add("exchangePattern");
        props.add("lazyStartProducer");
        props.add("namespace");
        props.add("partitionId");
        props.add("partitionKey");
        props.add("prefetchCount");
        props.add("producerAsyncClient");
        props.add("sharedAccessKey");
        props.add("sharedAccessName");
        props.add("tokenCredential");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        HashSet<String> secretProps = new HashSet<String>(5);
        secretProps.add("blobAccessKey");
        secretProps.add("blobStorageSharedKeyCredential");
        secretProps.add("connectionString");
        secretProps.add("sharedAccessKey");
        secretProps.add("tokenCredential");
        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);
        MULTI_VALUE_PREFIXES = Collections.emptyMap();
    }
}

