/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.s3;

import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.aws2.s3.AWS2S3Operations;
import org.apache.camel.component.aws2.s3.stream.AWSS3NamingStrategyEnum;
import org.apache.camel.component.aws2.s3.stream.AWSS3RestartingPolicyEnum;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import software.amazon.awssdk.core.Protocol;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.presigner.S3Presigner;

@UriParams
public class AWS2S3Configuration
implements Cloneable {
    private String bucketName;
    @UriParam(label="advanced")
    @Metadata(autowired=true)
    private S3Client amazonS3Client;
    @UriParam(label="advanced")
    @Metadata(autowired=true)
    private S3Presigner amazonS3Presigner;
    @UriParam(label="security", secret=true)
    private String accessKey;
    @UriParam(label="security", secret=true)
    private String secretKey;
    @UriParam(label="security", secret=true)
    private String sessionToken;
    @UriParam(label="consumer")
    private String fileName;
    @UriParam
    private String prefix;
    @UriParam
    private String delimiter;
    @UriParam(label="consumer")
    private String doneFileName;
    @UriParam(label="consumer", defaultValue="true")
    private boolean includeFolders = true;
    @UriParam(enums="ap-south-2,ap-south-1,eu-south-1,eu-south-2,us-gov-east-1,me-central-1,il-central-1,ca-central-1,eu-central-1,us-iso-west-1,eu-central-2,eu-isoe-west-1,us-west-1,us-west-2,af-south-1,eu-north-1,eu-west-3,eu-west-2,eu-west-1,ap-northeast-3,ap-northeast-2,ap-northeast-1,me-south-1,sa-east-1,ap-east-1,cn-north-1,ca-west-1,us-gov-west-1,ap-southeast-1,ap-southeast-2,us-iso-east-1,ap-southeast-3,ap-southeast-4,us-east-1,us-east-2,cn-northwest-1,us-isob-east-1,aws-global,aws-cn-global,aws-us-gov-global,aws-iso-global,aws-iso-b-global")
    private String region;
    @UriParam
    private boolean forcePathStyle;
    @UriParam(label="consumer", defaultValue="true")
    private boolean deleteAfterRead = true;
    @UriParam(label="consumer")
    private boolean moveAfterRead;
    @UriParam(label="consumer", defaultValue="false")
    private boolean removePrefixOnMove;
    @UriParam(label="consumer")
    private String destinationBucket;
    @UriParam(label="consumer")
    private String destinationBucketPrefix;
    @UriParam(label="consumer")
    private String destinationBucketSuffix;
    @UriParam(label="producer")
    private boolean deleteAfterWrite;
    @UriParam(label="producer")
    private boolean multiPartUpload;
    @UriParam(label="producer", defaultValue="26214400")
    private long partSize = 0x1900000L;
    @UriParam
    private String policy;
    @UriParam(label="producer")
    private String storageClass;
    @UriParam(label="proxy", enums="HTTP,HTTPS", defaultValue="HTTPS")
    private Protocol proxyProtocol = Protocol.HTTPS;
    @UriParam(label="proxy")
    private String proxyHost;
    @UriParam(label="proxy")
    private Integer proxyPort;
    @UriParam(label="consumer", defaultValue="true")
    private boolean includeBody = true;
    @UriParam(label="common", defaultValue="false")
    private boolean ignoreBody;
    @UriParam(label="producer")
    private AWS2S3Operations operation;
    @UriParam(label="consumer,advanced", defaultValue="true")
    private boolean autocloseBody = true;
    @UriParam(label="common", defaultValue="false")
    private boolean autoCreateBucket;
    @UriParam(label="producer,advanced", defaultValue="false")
    private boolean useAwsKMS;
    @UriParam(label="producer,advanced")
    private String awsKMSKeyId;
    @UriParam(label="producer,advanced", defaultValue="false")
    private boolean useCustomerKey;
    @UriParam(label="common,advanced")
    private String customerKeyId;
    @UriParam(label="common,advanced")
    private String customerKeyMD5;
    @UriParam(label="common,advanced")
    private String customerAlgorithm;
    @UriParam(label="producer,advanced", defaultValue="false")
    private boolean useSSES3;
    @UriParam(label="producer,advanced", defaultValue="false")
    private boolean conditionalWritesEnabled;
    @UriParam(label="security")
    private boolean useDefaultCredentialsProvider;
    @UriParam(label="security")
    private boolean useProfileCredentialsProvider;
    @UriParam(label="security")
    private boolean useSessionCredentials;
    @UriParam(label="security")
    private String profileCredentialsName;
    @UriParam(label="producer")
    private String keyName;
    @UriParam
    private boolean overrideEndpoint;
    @UriParam(label="security")
    private boolean trustAllCertificates;
    @UriParam
    private String uriEndpointOverride;
    @UriParam
    private boolean pojoRequest;
    @UriParam(label="producer")
    private boolean streamingUploadMode;
    @UriParam(defaultValue="10", label="producer")
    private int batchMessageNumber = 10;
    @UriParam(defaultValue="1000000", label="producer")
    private int batchSize = 1000000;
    @UriParam(defaultValue="1000000", label="producer")
    private int bufferSize = 1000000;
    @UriParam(defaultValue="progressive", label="producer")
    private AWSS3NamingStrategyEnum namingStrategy = AWSS3NamingStrategyEnum.progressive;
    @UriParam(label="producer")
    private long streamingUploadTimeout;
    @UriParam(defaultValue="override", label="producer")
    private AWSS3RestartingPolicyEnum restartingPolicy = AWSS3RestartingPolicyEnum.override;
    @UriParam(label="producer")
    private boolean timestampGroupingEnabled;
    @UriParam(defaultValue="300000", label="producer")
    private long timestampWindowSizeMillis = 300000L;
    @UriParam(defaultValue="CamelMessageTimestamp", label="producer")
    private String timestampHeaderName = "CamelMessageTimestamp";

    public long getPartSize() {
        return this.partSize;
    }

    public void setPartSize(long partSize) {
        this.partSize = partSize;
    }

    public boolean isMultiPartUpload() {
        return this.multiPartUpload;
    }

    public void setMultiPartUpload(boolean multiPartUpload) {
        this.multiPartUpload = multiPartUpload;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getSessionToken() {
        return this.sessionToken;
    }

    public void setSessionToken(String sessionToken) {
        this.sessionToken = sessionToken;
    }

    public S3Client getAmazonS3Client() {
        return this.amazonS3Client;
    }

    public void setAmazonS3Client(S3Client amazonS3Client) {
        this.amazonS3Client = amazonS3Client;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public String getDoneFileName() {
        return this.doneFileName;
    }

    public void setDoneFileName(String doneFileName) {
        this.doneFileName = doneFileName;
    }

    public void setIncludeFolders(boolean includeFolders) {
        this.includeFolders = includeFolders;
    }

    public boolean isIncludeFolders() {
        return this.includeFolders;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public void setIncludeBody(boolean includeBody) {
        this.includeBody = includeBody;
    }

    public boolean isIncludeBody() {
        return this.includeBody;
    }

    public boolean isIgnoreBody() {
        return this.ignoreBody;
    }

    public void setIgnoreBody(boolean ignoreBody) {
        this.ignoreBody = ignoreBody;
    }

    public boolean isDeleteAfterRead() {
        return this.deleteAfterRead;
    }

    public void setDeleteAfterRead(boolean deleteAfterRead) {
        this.deleteAfterRead = deleteAfterRead;
    }

    public boolean isMoveAfterRead() {
        return this.moveAfterRead;
    }

    public void setMoveAfterRead(boolean moveAfterRead) {
        this.moveAfterRead = moveAfterRead;
    }

    public boolean isRemovePrefixOnMove() {
        return this.removePrefixOnMove;
    }

    public void setRemovePrefixOnMove(boolean removePrefixOnMove) {
        this.removePrefixOnMove = removePrefixOnMove;
    }

    public String getDestinationBucket() {
        return this.destinationBucket;
    }

    public void setDestinationBucket(String destinationBucket) {
        this.destinationBucket = destinationBucket;
    }

    public String getDestinationBucketPrefix() {
        return this.destinationBucketPrefix;
    }

    public void setDestinationBucketPrefix(String destinationBucketPrefix) {
        this.destinationBucketPrefix = destinationBucketPrefix;
    }

    public String getDestinationBucketSuffix() {
        return this.destinationBucketSuffix;
    }

    public void setDestinationBucketSuffix(String destinationBucketSuffix) {
        this.destinationBucketSuffix = destinationBucketSuffix;
    }

    public boolean isDeleteAfterWrite() {
        return this.deleteAfterWrite;
    }

    public void setDeleteAfterWrite(boolean deleteAfterWrite) {
        this.deleteAfterWrite = deleteAfterWrite;
    }

    public String getPolicy() {
        return this.policy;
    }

    public void setPolicy(String policy) {
        this.policy = policy;
    }

    public String getStorageClass() {
        return this.storageClass;
    }

    public void setStorageClass(String storageClass) {
        this.storageClass = storageClass;
    }

    public Protocol getProxyProtocol() {
        return this.proxyProtocol;
    }

    public void setProxyProtocol(Protocol proxyProtocol) {
        this.proxyProtocol = proxyProtocol;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public Integer getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(Integer proxyPort) {
        this.proxyPort = proxyPort;
    }

    public AWS2S3Operations getOperation() {
        return this.operation;
    }

    public void setOperation(AWS2S3Operations operation) {
        this.operation = operation;
    }

    public boolean isAutocloseBody() {
        return this.autocloseBody;
    }

    public void setAutocloseBody(boolean autocloseBody) {
        this.autocloseBody = autocloseBody;
    }

    public boolean isUseAwsKMS() {
        return this.useAwsKMS;
    }

    public void setUseAwsKMS(boolean useAwsKMS) {
        this.useAwsKMS = useAwsKMS;
    }

    public String getAwsKMSKeyId() {
        return this.awsKMSKeyId;
    }

    public void setAwsKMSKeyId(String awsKMSKeyId) {
        this.awsKMSKeyId = awsKMSKeyId;
    }

    public boolean isUseCustomerKey() {
        return this.useCustomerKey;
    }

    public void setUseCustomerKey(boolean useCustomerKey) {
        this.useCustomerKey = useCustomerKey;
    }

    public String getCustomerKeyId() {
        return this.customerKeyId;
    }

    public void setCustomerKeyId(String customerKeyId) {
        this.customerKeyId = customerKeyId;
    }

    public String getCustomerKeyMD5() {
        return this.customerKeyMD5;
    }

    public void setCustomerKeyMD5(String customerKeyMD5) {
        this.customerKeyMD5 = customerKeyMD5;
    }

    public String getCustomerAlgorithm() {
        return this.customerAlgorithm;
    }

    public void setCustomerAlgorithm(String customerAlgorithm) {
        this.customerAlgorithm = customerAlgorithm;
    }

    public boolean isForcePathStyle() {
        return this.forcePathStyle;
    }

    public void setForcePathStyle(boolean forcePathStyle) {
        this.forcePathStyle = forcePathStyle;
    }

    public void setUseDefaultCredentialsProvider(Boolean useDefaultCredentialsProvider) {
        this.useDefaultCredentialsProvider = useDefaultCredentialsProvider;
    }

    public Boolean isUseDefaultCredentialsProvider() {
        return this.useDefaultCredentialsProvider;
    }

    public void setUseProfileCredentialsProvider(boolean useProfileCredentialsProvider) {
        this.useProfileCredentialsProvider = useProfileCredentialsProvider;
    }

    public boolean isUseProfileCredentialsProvider() {
        return this.useProfileCredentialsProvider;
    }

    public boolean isUseSessionCredentials() {
        return this.useSessionCredentials;
    }

    public void setUseSessionCredentials(boolean useSessionCredentials) {
        this.useSessionCredentials = useSessionCredentials;
    }

    public boolean isAutoCreateBucket() {
        return this.autoCreateBucket;
    }

    public void setAutoCreateBucket(boolean autoCreateBucket) {
        this.autoCreateBucket = autoCreateBucket;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public boolean isOverrideEndpoint() {
        return this.overrideEndpoint;
    }

    public void setOverrideEndpoint(boolean overrideEndpoint) {
        this.overrideEndpoint = overrideEndpoint;
    }

    public String getUriEndpointOverride() {
        return this.uriEndpointOverride;
    }

    public void setUriEndpointOverride(String uriEndpointOverride) {
        this.uriEndpointOverride = uriEndpointOverride;
    }

    public boolean isPojoRequest() {
        return this.pojoRequest;
    }

    public void setPojoRequest(boolean pojoRequest) {
        this.pojoRequest = pojoRequest;
    }

    public boolean isTrustAllCertificates() {
        return this.trustAllCertificates;
    }

    public void setTrustAllCertificates(boolean trustAllCertificates) {
        this.trustAllCertificates = trustAllCertificates;
    }

    public S3Presigner getAmazonS3Presigner() {
        return this.amazonS3Presigner;
    }

    public void setAmazonS3Presigner(S3Presigner amazonS3Presigner) {
        this.amazonS3Presigner = amazonS3Presigner;
    }

    public boolean isStreamingUploadMode() {
        return this.streamingUploadMode;
    }

    public void setStreamingUploadMode(boolean streamingUploadMode) {
        this.streamingUploadMode = streamingUploadMode;
    }

    public int getBatchMessageNumber() {
        return this.batchMessageNumber;
    }

    public void setBatchMessageNumber(int batchMessageNumber) {
        this.batchMessageNumber = batchMessageNumber;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public AWSS3NamingStrategyEnum getNamingStrategy() {
        return this.namingStrategy;
    }

    public void setNamingStrategy(AWSS3NamingStrategyEnum namingStrategy) {
        this.namingStrategy = namingStrategy;
    }

    public long getStreamingUploadTimeout() {
        return this.streamingUploadTimeout;
    }

    public void setStreamingUploadTimeout(long streamingUploadTimeout) {
        this.streamingUploadTimeout = streamingUploadTimeout;
    }

    public AWSS3RestartingPolicyEnum getRestartingPolicy() {
        return this.restartingPolicy;
    }

    public void setRestartingPolicy(AWSS3RestartingPolicyEnum restartingPolicy) {
        this.restartingPolicy = restartingPolicy;
    }

    public boolean isUseSSES3() {
        return this.useSSES3;
    }

    public void setUseSSES3(boolean useSSES3) {
        this.useSSES3 = useSSES3;
    }

    public String getProfileCredentialsName() {
        return this.profileCredentialsName;
    }

    public void setProfileCredentialsName(String profileCredentialsName) {
        this.profileCredentialsName = profileCredentialsName;
    }

    public boolean isConditionalWritesEnabled() {
        return this.conditionalWritesEnabled;
    }

    public void setConditionalWritesEnabled(boolean conditionalWritesEnabled) {
        this.conditionalWritesEnabled = conditionalWritesEnabled;
    }

    public boolean isTimestampGroupingEnabled() {
        return this.timestampGroupingEnabled;
    }

    public void setTimestampGroupingEnabled(boolean timestampGroupingEnabled) {
        this.timestampGroupingEnabled = timestampGroupingEnabled;
    }

    public long getTimestampWindowSizeMillis() {
        return this.timestampWindowSizeMillis;
    }

    public void setTimestampWindowSizeMillis(long timestampWindowSizeMillis) {
        this.timestampWindowSizeMillis = timestampWindowSizeMillis;
    }

    public String getTimestampHeaderName() {
        return this.timestampHeaderName;
    }

    public void setTimestampHeaderName(String timestampHeaderName) {
        this.timestampHeaderName = timestampHeaderName;
    }

    public AWS2S3Configuration copy() {
        try {
            return (AWS2S3Configuration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }
}

