/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.attachment;

import jakarta.activation.DataHandler;
import java.util.Iterator;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.attachment.Attachment;
import org.apache.camel.attachment.AttachmentMessage;
import org.apache.camel.attachment.DefaultAttachmentMessage;
import org.apache.camel.attachment.NoSuchAttachmentException;
import org.apache.camel.language.simple.SimpleExpressionBuilder;
import org.apache.camel.support.ExpressionAdapter;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.support.builder.ExpressionBuilder;

public class AttachmentExpressionBuilder {
    private static AttachmentMessage toAttachmentMessage(Exchange exchange) {
        AttachmentMessage am;
        Message message = exchange.getMessage();
        AttachmentMessage answer = message instanceof AttachmentMessage ? (am = (AttachmentMessage)message) : new DefaultAttachmentMessage(exchange.getMessage());
        return answer;
    }

    public static Expression attachments() {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                return AttachmentExpressionBuilder.toAttachmentMessage(exchange).getAttachments();
            }
        };
    }

    public static Expression attachmentsSize() {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                return AttachmentExpressionBuilder.toAttachmentMessage(exchange).getAttachments().size();
            }
        };
    }

    public static Expression attachmentContent(final String key, final String type) {
        return new ExpressionAdapter(){
            private Class<?> clazz;

            public Object evaluate(Exchange exchange) {
                Object answer;
                DataHandler dh = AttachmentExpressionBuilder.toAttachmentMessage(exchange).getAttachment(key);
                try {
                    answer = dh.getContent();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                if (answer != null && this.clazz != null) {
                    try {
                        answer = exchange.getContext().getTypeConverter().mandatoryConvertTo(this.clazz, answer);
                    }
                    catch (NoTypeConversionAvailableException e) {
                        throw CamelExecutionException.wrapCamelExecutionException((Exchange)exchange, (Throwable)e);
                    }
                }
                return answer;
            }

            public void init(CamelContext context) {
                if (type != null) {
                    try {
                        this.clazz = context.getClassResolver().resolveMandatoryClass(type);
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        };
    }

    public static Expression attachmentContentHeader(final String key, final String name, final String type) {
        return new ExpressionAdapter(){
            private Class<?> clazz;

            public Object evaluate(Exchange exchange) {
                Object answer = null;
                Attachment ao = AttachmentExpressionBuilder.toAttachmentMessage(exchange).getAttachmentObject(key);
                if (ao != null && (answer = ao.getHeader(name)) != null && this.clazz != null) {
                    try {
                        answer = exchange.getContext().getTypeConverter().mandatoryConvertTo(this.clazz, answer);
                    }
                    catch (NoTypeConversionAvailableException e) {
                        throw CamelExecutionException.wrapCamelExecutionException((Exchange)exchange, (Throwable)e);
                    }
                }
                return answer;
            }

            public void init(CamelContext context) {
                if (type != null) {
                    try {
                        this.clazz = context.getClassResolver().resolveMandatoryClass(type);
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        };
    }

    public static Expression attachmentContentType(final String key) {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                DataHandler dh = AttachmentExpressionBuilder.toAttachmentMessage(exchange).getAttachment(key);
                if (dh != null) {
                    return dh.getContentType();
                }
                return null;
            }
        };
    }

    public static Expression attachmentExpression(String attachmentName) {
        return AttachmentExpressionBuilder.attachmentExpression(ExpressionBuilder.simpleExpression((String)attachmentName), false);
    }

    public static Expression attachmentExpression(final Expression attachmentName, final boolean mandatory) {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                String key = (String)attachmentName.evaluate(exchange, String.class);
                DataHandler answer = AttachmentExpressionBuilder.toAttachmentMessage(exchange).getAttachment(key);
                if (mandatory && answer == null) {
                    throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)((Object)new NoSuchAttachmentException(exchange, key)));
                }
                return answer;
            }

            public void init(CamelContext context) {
                super.init(context);
                attachmentName.init(context);
            }

            public String toString() {
                return "attachment(" + attachmentName + ")";
            }
        };
    }

    public static Expression attachmentOgnlExpression(String ognl) {
        return new SimpleExpressionBuilder.KeyedOgnlExpressionAdapter(ognl, "attachmentOgnl(" + ognl + ")", (exchange, exp) -> {
            String text = (String)exp.evaluate(exchange, String.class);
            AttachmentMessage am = AttachmentExpressionBuilder.toAttachmentMessage(exchange);
            DataHandler dh = am.getAttachment(text);
            if (dh == null && ObjectHelper.isNumber((String)text)) {
                try {
                    int idx = Integer.parseInt(text);
                    if (idx < am.getAttachments().size()) {
                        Iterator<DataHandler> it = am.getAttachments().values().iterator();
                        for (int i = 0; i < idx; ++i) {
                            it.next();
                        }
                        dh = it.next();
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return dh;
        });
    }
}

