/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.idl;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.avro.JsonProperties;
import org.apache.avro.Protocol;
import org.apache.avro.Schema;
import org.apache.avro.idl.IdlFile;
import org.apache.avro.idl.IsResolvedSchemaVisitor;
import org.apache.avro.idl.ResolvingVisitor;
import org.apache.avro.idl.Schemas;

final class SchemaResolver {
    private static final String UR_SCHEMA_ATTR = "org.apache.avro.idl.unresolved.name";
    private static final String UR_SCHEMA_NAME = "UnresolvedSchema";
    private static final String UR_SCHEMA_NS = "org.apache.avro.compiler";
    private static final AtomicInteger COUNTER = new AtomicInteger();

    private SchemaResolver() {
    }

    static Schema unresolvedSchema(String name) {
        Schema schema = Schema.createRecord((String)("UnresolvedSchema_" + COUNTER.getAndIncrement()), (String)"unresolved schema", (String)UR_SCHEMA_NS, (boolean)false, Collections.emptyList());
        schema.addProp(UR_SCHEMA_ATTR, name);
        return schema;
    }

    static boolean isUnresolvedSchema(Schema schema) {
        return schema.getType() == Schema.Type.RECORD && schema.getProp(UR_SCHEMA_ATTR) != null && schema.getName() != null && schema.getName().startsWith(UR_SCHEMA_NAME) && UR_SCHEMA_NS.equals(schema.getNamespace());
    }

    static String getUnresolvedSchemaName(Schema schema) {
        if (!SchemaResolver.isUnresolvedSchema(schema)) {
            throw new IllegalArgumentException("Not a unresolved schema: " + schema);
        }
        return schema.getProp(UR_SCHEMA_ATTR);
    }

    static boolean isFullyResolvedSchema(Schema schema) {
        if (SchemaResolver.isUnresolvedSchema(schema)) {
            return false;
        }
        return Schemas.visit(schema, new IsResolvedSchemaVisitor());
    }

    static IdlFile resolve(IdlFile idlFile, String ... schemaPropertiesToRemove) {
        if (idlFile.getProtocol() != null) {
            return new IdlFile(SchemaResolver.resolve(idlFile.getProtocol(), schemaPropertiesToRemove), idlFile.getWarnings());
        }
        ResolvingVisitor visitor = new ResolvingVisitor(null, idlFile::getNamedSchema, schemaPropertiesToRemove);
        Function<Schema, Schema> resolver = schema -> Schemas.visit(schema, visitor.withRoot((Schema)schema));
        List<Schema> namedSchemata = idlFile.getNamedSchemas().values().stream().map(resolver).collect(Collectors.toList());
        Schema mainSchema = Optional.ofNullable(idlFile.getMainSchema()).map(resolver).orElse(null);
        return new IdlFile(idlFile.getNamespace(), mainSchema, namedSchemata, idlFile.getWarnings());
    }

    static Protocol resolve(Protocol protocol, String ... schemaPropertiesToRemove) {
        Protocol result = new Protocol(protocol.getName(), protocol.getDoc(), protocol.getNamespace());
        protocol.getObjectProps().forEach((arg_0, arg_1) -> ((JsonProperties)result).addProp(arg_0, arg_1));
        ResolvingVisitor visitor = new ResolvingVisitor(null, arg_0 -> ((Protocol)protocol).getType(arg_0), schemaPropertiesToRemove);
        Function<Schema, Schema> resolver = schema -> Schemas.visit(schema, visitor.withRoot((Schema)schema));
        result.setTypes((Collection)protocol.getTypes().stream().map(resolver).collect(Collectors.toList()));
        Map resultMessages = result.getMessages();
        protocol.getMessages().forEach((name, oldValue) -> {
            Protocol.Message newValue;
            if (oldValue.isOneWay()) {
                newValue = result.createMessage(oldValue.getName(), oldValue.getDoc(), (JsonProperties)oldValue, (Schema)resolver.apply(oldValue.getRequest()));
            } else {
                Schema request = (Schema)resolver.apply(oldValue.getRequest());
                Schema response = (Schema)resolver.apply(oldValue.getResponse());
                Schema errors = (Schema)resolver.apply(oldValue.getErrors());
                newValue = result.createMessage(oldValue.getName(), oldValue.getDoc(), (JsonProperties)oldValue, request, response, errors);
            }
            resultMessages.put(name, newValue);
        });
        return result;
    }
}

