/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.idl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.apache.avro.AvroTypeException;
import org.apache.avro.Schema;
import org.apache.avro.idl.SchemaResolver;
import org.apache.avro.idl.SchemaVisitor;
import org.apache.avro.idl.SchemaVisitorAction;
import org.apache.avro.idl.Schemas;

public final class ResolvingVisitor
implements SchemaVisitor<Schema> {
    private static final Set<Schema.Type> CONTAINER_SCHEMA_TYPES = EnumSet.of(Schema.Type.RECORD, Schema.Type.ARRAY, Schema.Type.MAP, Schema.Type.UNION);
    private static final Set<Schema.Type> NAMED_SCHEMA_TYPES = EnumSet.of(Schema.Type.RECORD, Schema.Type.ENUM, Schema.Type.FIXED);
    private final Function<String, Schema> symbolTable;
    private final Set<String> schemaPropertiesToRemove;
    private final IdentityHashMap<Schema, Schema> replace = new IdentityHashMap();
    private final Schema root;

    public ResolvingVisitor(Schema root, Function<String, Schema> symbolTable, String ... schemaPropertiesToRemove) {
        this(root, symbolTable, new HashSet<String>(Arrays.asList(schemaPropertiesToRemove)));
    }

    public ResolvingVisitor(Schema root, Function<String, Schema> symbolTable, Set<String> schemaPropertiesToRemove) {
        this.symbolTable = symbolTable;
        this.schemaPropertiesToRemove = schemaPropertiesToRemove;
        this.root = root;
    }

    public ResolvingVisitor withRoot(Schema root) {
        return new ResolvingVisitor(root, this.symbolTable, this.schemaPropertiesToRemove);
    }

    @Override
    public SchemaVisitorAction visitTerminal(Schema terminal) {
        Schema.Type type = terminal.getType();
        if (CONTAINER_SCHEMA_TYPES.contains(type)) {
            if (!this.replace.containsKey(terminal)) {
                throw new IllegalStateException("Schema " + terminal + " must be already processed");
            }
            return SchemaVisitorAction.CONTINUE;
        }
        Schema newSchema = type == Schema.Type.ENUM ? Schema.createEnum((String)terminal.getName(), (String)terminal.getDoc(), (String)terminal.getNamespace(), (List)terminal.getEnumSymbols(), (String)terminal.getEnumDefault()) : (type == Schema.Type.FIXED ? Schema.createFixed((String)terminal.getName(), (String)terminal.getDoc(), (String)terminal.getNamespace(), (int)terminal.getFixedSize()) : Schema.create((Schema.Type)type));
        this.copyProperties(terminal, newSchema);
        this.replace.put(terminal, newSchema);
        return SchemaVisitorAction.CONTINUE;
    }

    public void copyProperties(Schema first, Schema second) {
        Optional.ofNullable(first.getLogicalType()).ifPresent(logicalType -> logicalType.addToSchema(second));
        if (NAMED_SCHEMA_TYPES.contains(first.getType())) {
            first.getAliases().forEach(arg_0 -> ((Schema)second).addAlias(arg_0));
        }
        first.getObjectProps().forEach((name, value) -> {
            if (!this.schemaPropertiesToRemove.contains(name)) {
                second.addProp(name, value);
            }
        });
    }

    @Override
    public SchemaVisitorAction visitNonTerminal(Schema nt) {
        Schema.Type type = nt.getType();
        if (type == Schema.Type.RECORD) {
            if (SchemaResolver.isUnresolvedSchema(nt)) {
                String unresolvedSchemaName = SchemaResolver.getUnresolvedSchemaName(nt);
                Schema resSchema = this.symbolTable.apply(unresolvedSchemaName);
                if (resSchema == null) {
                    throw new AvroTypeException("Unable to resolve " + unresolvedSchemaName);
                }
                Schema replacement = this.replace.computeIfAbsent(resSchema, schema -> {
                    Schemas.visit(schema, this);
                    return this.replace.get(schema);
                });
                this.replace.put(nt, replacement);
            } else {
                Schema newSchema = Schema.createRecord((String)nt.getName(), (String)nt.getDoc(), (String)nt.getNamespace(), (boolean)nt.isError());
                this.copyProperties(nt, newSchema);
                this.replace.put(nt, newSchema);
            }
        }
        return SchemaVisitorAction.CONTINUE;
    }

    @Override
    public SchemaVisitorAction afterVisitNonTerminal(Schema nt) {
        Schema newSchema;
        Schema.Type type = nt.getType();
        switch (type) {
            case RECORD: {
                Schema newSchema2;
                if (!SchemaResolver.isUnresolvedSchema(nt) && !(newSchema2 = this.replace.get(nt)).hasFields()) {
                    List fields = nt.getFields();
                    ArrayList<Schema.Field> newFields = new ArrayList<Schema.Field>(fields.size());
                    for (Schema.Field field : fields) {
                        newFields.add(new Schema.Field(field, this.replace.get(field.schema())));
                    }
                    newSchema2.setFields(newFields);
                }
                return SchemaVisitorAction.CONTINUE;
            }
            case UNION: {
                List types = nt.getTypes();
                ArrayList<Schema> newTypes = new ArrayList<Schema>(types.size());
                for (Schema sch : types) {
                    newTypes.add(this.replace.get(sch));
                }
                newSchema = Schema.createUnion(newTypes);
                break;
            }
            case ARRAY: {
                newSchema = Schema.createArray((Schema)this.replace.get(nt.getElementType()));
                break;
            }
            case MAP: {
                newSchema = Schema.createMap((Schema)this.replace.get(nt.getValueType()));
                break;
            }
            default: {
                throw new IllegalStateException("Illegal type " + type + ", schema " + nt);
            }
        }
        this.copyProperties(nt, newSchema);
        this.replace.put(nt, newSchema);
        return SchemaVisitorAction.CONTINUE;
    }

    @Override
    public Schema get() {
        return this.replace.get(this.root);
    }

    public String toString() {
        return "ResolvingVisitor{symbolTable=" + this.symbolTable + ", schemaPropertiesToRemove=" + this.schemaPropertiesToRemove + ", replace=" + this.replace + '}';
    }
}

