/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.knative.serving.v1;

import io.fabric8.knative.serving.v1.RevisionSpec;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Affinity;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.EphemeralContainer;
import io.fabric8.kubernetes.api.model.HostAlias;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.PodDNSConfig;
import io.fabric8.kubernetes.api.model.PodOS;
import io.fabric8.kubernetes.api.model.PodReadinessGate;
import io.fabric8.kubernetes.api.model.PodResourceClaim;
import io.fabric8.kubernetes.api.model.PodSchedulingGate;
import io.fabric8.kubernetes.api.model.PodSecurityContext;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.Toleration;
import io.fabric8.kubernetes.api.model.TopologySpreadConstraint;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import io.fabric8.kubernetes.api.model.VolumeFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class RevisionSpecFluent<A extends RevisionSpecFluent<A>>
extends BaseFluent<A> {
    private Long activeDeadlineSeconds;
    private Affinity affinity;
    private Boolean automountServiceAccountToken;
    private Long containerConcurrency;
    private ArrayList<ContainerBuilder> containers = new ArrayList();
    private PodDNSConfig dnsConfig;
    private String dnsPolicy;
    private Boolean enableServiceLinks;
    private List<EphemeralContainer> ephemeralContainers = new ArrayList<EphemeralContainer>();
    private List<HostAlias> hostAliases = new ArrayList<HostAlias>();
    private Boolean hostIPC;
    private Boolean hostNetwork;
    private Boolean hostPID;
    private Boolean hostUsers;
    private String hostname;
    private Long idleTimeoutSeconds;
    private ArrayList<LocalObjectReferenceBuilder> imagePullSecrets = new ArrayList();
    private ArrayList<ContainerBuilder> initContainers = new ArrayList();
    private String nodeName;
    private Map<String, String> nodeSelector;
    private PodOS os;
    private Map<String, Quantity> overhead;
    private String preemptionPolicy;
    private Integer priority;
    private String priorityClassName;
    private List<PodReadinessGate> readinessGates = new ArrayList<PodReadinessGate>();
    private List<PodResourceClaim> resourceClaims = new ArrayList<PodResourceClaim>();
    private Long responseStartTimeoutSeconds;
    private String restartPolicy;
    private String runtimeClassName;
    private String schedulerName;
    private List<PodSchedulingGate> schedulingGates = new ArrayList<PodSchedulingGate>();
    private PodSecurityContext securityContext;
    private String serviceAccount;
    private String serviceAccountName;
    private Boolean setHostnameAsFQDN;
    private Boolean shareProcessNamespace;
    private String subdomain;
    private Long terminationGracePeriodSeconds;
    private Long timeoutSeconds;
    private List<Toleration> tolerations = new ArrayList<Toleration>();
    private List<TopologySpreadConstraint> topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();
    private ArrayList<VolumeBuilder> volumes = new ArrayList();
    private Map<String, Object> additionalProperties;

    public RevisionSpecFluent() {
    }

    public RevisionSpecFluent(RevisionSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(RevisionSpec instance) {
        RevisionSpec revisionSpec = instance = instance != null ? instance : new RevisionSpec();
        if (instance != null) {
            this.withActiveDeadlineSeconds(instance.getActiveDeadlineSeconds());
            this.withAffinity(instance.getAffinity());
            this.withAutomountServiceAccountToken(instance.getAutomountServiceAccountToken());
            this.withContainerConcurrency(instance.getContainerConcurrency());
            this.withContainers(instance.getContainers());
            this.withDnsConfig(instance.getDnsConfig());
            this.withDnsPolicy(instance.getDnsPolicy());
            this.withEnableServiceLinks(instance.getEnableServiceLinks());
            this.withEphemeralContainers(instance.getEphemeralContainers());
            this.withHostAliases(instance.getHostAliases());
            this.withHostIPC(instance.getHostIPC());
            this.withHostNetwork(instance.getHostNetwork());
            this.withHostPID(instance.getHostPID());
            this.withHostUsers(instance.getHostUsers());
            this.withHostname(instance.getHostname());
            this.withIdleTimeoutSeconds(instance.getIdleTimeoutSeconds());
            this.withImagePullSecrets(instance.getImagePullSecrets());
            this.withInitContainers(instance.getInitContainers());
            this.withNodeName(instance.getNodeName());
            this.withNodeSelector(instance.getNodeSelector());
            this.withOs(instance.getOs());
            this.withOverhead(instance.getOverhead());
            this.withPreemptionPolicy(instance.getPreemptionPolicy());
            this.withPriority(instance.getPriority());
            this.withPriorityClassName(instance.getPriorityClassName());
            this.withReadinessGates(instance.getReadinessGates());
            this.withResourceClaims(instance.getResourceClaims());
            this.withResponseStartTimeoutSeconds(instance.getResponseStartTimeoutSeconds());
            this.withRestartPolicy(instance.getRestartPolicy());
            this.withRuntimeClassName(instance.getRuntimeClassName());
            this.withSchedulerName(instance.getSchedulerName());
            this.withSchedulingGates(instance.getSchedulingGates());
            this.withSecurityContext(instance.getSecurityContext());
            this.withServiceAccount(instance.getServiceAccount());
            this.withServiceAccountName(instance.getServiceAccountName());
            this.withSetHostnameAsFQDN(instance.getSetHostnameAsFQDN());
            this.withShareProcessNamespace(instance.getShareProcessNamespace());
            this.withSubdomain(instance.getSubdomain());
            this.withTerminationGracePeriodSeconds(instance.getTerminationGracePeriodSeconds());
            this.withTimeoutSeconds(instance.getTimeoutSeconds());
            this.withTolerations(instance.getTolerations());
            this.withTopologySpreadConstraints(instance.getTopologySpreadConstraints());
            this.withVolumes(instance.getVolumes());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Long getActiveDeadlineSeconds() {
        return this.activeDeadlineSeconds;
    }

    public A withActiveDeadlineSeconds(Long activeDeadlineSeconds) {
        this.activeDeadlineSeconds = activeDeadlineSeconds;
        return (A)((Object)this);
    }

    public boolean hasActiveDeadlineSeconds() {
        return this.activeDeadlineSeconds != null;
    }

    public Affinity getAffinity() {
        return this.affinity;
    }

    public A withAffinity(Affinity affinity) {
        this.affinity = affinity;
        return (A)((Object)this);
    }

    public boolean hasAffinity() {
        return this.affinity != null;
    }

    public Boolean getAutomountServiceAccountToken() {
        return this.automountServiceAccountToken;
    }

    public A withAutomountServiceAccountToken(Boolean automountServiceAccountToken) {
        this.automountServiceAccountToken = automountServiceAccountToken;
        return (A)((Object)this);
    }

    public boolean hasAutomountServiceAccountToken() {
        return this.automountServiceAccountToken != null;
    }

    public Long getContainerConcurrency() {
        return this.containerConcurrency;
    }

    public A withContainerConcurrency(Long containerConcurrency) {
        this.containerConcurrency = containerConcurrency;
        return (A)((Object)this);
    }

    public boolean hasContainerConcurrency() {
        return this.containerConcurrency != null;
    }

    public A addToContainers(int index, Container item) {
        if (this.containers == null) {
            this.containers = new ArrayList();
        }
        ContainerBuilder builder = new ContainerBuilder(item);
        if (index < 0 || index >= this.containers.size()) {
            this._visitables.get((Object)"containers").add(builder);
            this.containers.add(builder);
        } else {
            this._visitables.get((Object)"containers").add(builder);
            this.containers.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToContainers(int index, Container item) {
        if (this.containers == null) {
            this.containers = new ArrayList();
        }
        ContainerBuilder builder = new ContainerBuilder(item);
        if (index < 0 || index >= this.containers.size()) {
            this._visitables.get((Object)"containers").add(builder);
            this.containers.add(builder);
        } else {
            this._visitables.get((Object)"containers").add(builder);
            this.containers.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToContainers(Container ... items) {
        if (this.containers == null) {
            this.containers = new ArrayList();
        }
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get((Object)"containers").add(builder);
            this.containers.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToContainers(Collection<Container> items) {
        if (this.containers == null) {
            this.containers = new ArrayList();
        }
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get((Object)"containers").add(builder);
            this.containers.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromContainers(Container ... items) {
        if (this.containers == null) {
            return (A)((Object)this);
        }
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get((Object)"containers").remove(builder);
            this.containers.remove(builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromContainers(Collection<Container> items) {
        if (this.containers == null) {
            return (A)((Object)this);
        }
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get((Object)"containers").remove(builder);
            this.containers.remove(builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromContainers(Predicate<ContainerBuilder> predicate) {
        if (this.containers == null) {
            return (A)((Object)this);
        }
        Iterator<ContainerBuilder> each = this.containers.iterator();
        List visitables = this._visitables.get((Object)"containers");
        while (each.hasNext()) {
            ContainerBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Container> buildContainers() {
        return this.containers != null ? RevisionSpecFluent.build(this.containers) : null;
    }

    public Container buildContainer(int index) {
        return this.containers.get(index).build();
    }

    public Container buildFirstContainer() {
        return this.containers.get(0).build();
    }

    public Container buildLastContainer() {
        return this.containers.get(this.containers.size() - 1).build();
    }

    public Container buildMatchingContainer(Predicate<ContainerBuilder> predicate) {
        for (ContainerBuilder item : this.containers) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingContainer(Predicate<ContainerBuilder> predicate) {
        for (ContainerBuilder item : this.containers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withContainers(List<Container> containers) {
        if (this.containers != null) {
            this._visitables.get((Object)"containers").clear();
        }
        if (containers != null) {
            this.containers = new ArrayList();
            for (Container item : containers) {
                this.addToContainers(item);
            }
        } else {
            this.containers = null;
        }
        return (A)((Object)this);
    }

    public A withContainers(Container ... containers) {
        if (this.containers != null) {
            this.containers.clear();
            this._visitables.remove((Object)"containers");
        }
        if (containers != null) {
            for (Container item : containers) {
                this.addToContainers(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasContainers() {
        return this.containers != null && !this.containers.isEmpty();
    }

    public ContainersNested<A> addNewContainer() {
        return new ContainersNested(-1, null);
    }

    public ContainersNested<A> addNewContainerLike(Container item) {
        return new ContainersNested(-1, item);
    }

    public ContainersNested<A> setNewContainerLike(int index, Container item) {
        return new ContainersNested(index, item);
    }

    public ContainersNested<A> editContainer(int index) {
        if (this.containers.size() <= index) {
            throw new RuntimeException("Can't edit containers. Index exceeds size.");
        }
        return this.setNewContainerLike(index, this.buildContainer(index));
    }

    public ContainersNested<A> editFirstContainer() {
        if (this.containers.size() == 0) {
            throw new RuntimeException("Can't edit first containers. The list is empty.");
        }
        return this.setNewContainerLike(0, this.buildContainer(0));
    }

    public ContainersNested<A> editLastContainer() {
        int index = this.containers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last containers. The list is empty.");
        }
        return this.setNewContainerLike(index, this.buildContainer(index));
    }

    public ContainersNested<A> editMatchingContainer(Predicate<ContainerBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.containers.size(); ++i) {
            if (!predicate.test(this.containers.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching containers. No match found.");
        }
        return this.setNewContainerLike(index, this.buildContainer(index));
    }

    public PodDNSConfig getDnsConfig() {
        return this.dnsConfig;
    }

    public A withDnsConfig(PodDNSConfig dnsConfig) {
        this.dnsConfig = dnsConfig;
        return (A)((Object)this);
    }

    public boolean hasDnsConfig() {
        return this.dnsConfig != null;
    }

    public String getDnsPolicy() {
        return this.dnsPolicy;
    }

    public A withDnsPolicy(String dnsPolicy) {
        this.dnsPolicy = dnsPolicy;
        return (A)((Object)this);
    }

    public boolean hasDnsPolicy() {
        return this.dnsPolicy != null;
    }

    public Boolean getEnableServiceLinks() {
        return this.enableServiceLinks;
    }

    public A withEnableServiceLinks(Boolean enableServiceLinks) {
        this.enableServiceLinks = enableServiceLinks;
        return (A)((Object)this);
    }

    public boolean hasEnableServiceLinks() {
        return this.enableServiceLinks != null;
    }

    public A addToEphemeralContainers(int index, EphemeralContainer item) {
        if (this.ephemeralContainers == null) {
            this.ephemeralContainers = new ArrayList<EphemeralContainer>();
        }
        this.ephemeralContainers.add(index, item);
        return (A)((Object)this);
    }

    public A setToEphemeralContainers(int index, EphemeralContainer item) {
        if (this.ephemeralContainers == null) {
            this.ephemeralContainers = new ArrayList<EphemeralContainer>();
        }
        this.ephemeralContainers.set(index, item);
        return (A)((Object)this);
    }

    public A addToEphemeralContainers(EphemeralContainer ... items) {
        if (this.ephemeralContainers == null) {
            this.ephemeralContainers = new ArrayList<EphemeralContainer>();
        }
        for (EphemeralContainer item : items) {
            this.ephemeralContainers.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToEphemeralContainers(Collection<EphemeralContainer> items) {
        if (this.ephemeralContainers == null) {
            this.ephemeralContainers = new ArrayList<EphemeralContainer>();
        }
        for (EphemeralContainer item : items) {
            this.ephemeralContainers.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromEphemeralContainers(EphemeralContainer ... items) {
        if (this.ephemeralContainers == null) {
            return (A)((Object)this);
        }
        for (EphemeralContainer item : items) {
            this.ephemeralContainers.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromEphemeralContainers(Collection<EphemeralContainer> items) {
        if (this.ephemeralContainers == null) {
            return (A)((Object)this);
        }
        for (EphemeralContainer item : items) {
            this.ephemeralContainers.remove(item);
        }
        return (A)((Object)this);
    }

    public List<EphemeralContainer> getEphemeralContainers() {
        return this.ephemeralContainers;
    }

    public EphemeralContainer getEphemeralContainer(int index) {
        return this.ephemeralContainers.get(index);
    }

    public EphemeralContainer getFirstEphemeralContainer() {
        return this.ephemeralContainers.get(0);
    }

    public EphemeralContainer getLastEphemeralContainer() {
        return this.ephemeralContainers.get(this.ephemeralContainers.size() - 1);
    }

    public EphemeralContainer getMatchingEphemeralContainer(Predicate<EphemeralContainer> predicate) {
        for (EphemeralContainer item : this.ephemeralContainers) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingEphemeralContainer(Predicate<EphemeralContainer> predicate) {
        for (EphemeralContainer item : this.ephemeralContainers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withEphemeralContainers(List<EphemeralContainer> ephemeralContainers) {
        if (ephemeralContainers != null) {
            this.ephemeralContainers = new ArrayList<EphemeralContainer>();
            for (EphemeralContainer item : ephemeralContainers) {
                this.addToEphemeralContainers(item);
            }
        } else {
            this.ephemeralContainers = null;
        }
        return (A)((Object)this);
    }

    public A withEphemeralContainers(EphemeralContainer ... ephemeralContainers) {
        if (this.ephemeralContainers != null) {
            this.ephemeralContainers.clear();
            this._visitables.remove((Object)"ephemeralContainers");
        }
        if (ephemeralContainers != null) {
            for (EphemeralContainer item : ephemeralContainers) {
                this.addToEphemeralContainers(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasEphemeralContainers() {
        return this.ephemeralContainers != null && !this.ephemeralContainers.isEmpty();
    }

    public A addToHostAliases(int index, HostAlias item) {
        if (this.hostAliases == null) {
            this.hostAliases = new ArrayList<HostAlias>();
        }
        this.hostAliases.add(index, item);
        return (A)((Object)this);
    }

    public A setToHostAliases(int index, HostAlias item) {
        if (this.hostAliases == null) {
            this.hostAliases = new ArrayList<HostAlias>();
        }
        this.hostAliases.set(index, item);
        return (A)((Object)this);
    }

    public A addToHostAliases(HostAlias ... items) {
        if (this.hostAliases == null) {
            this.hostAliases = new ArrayList<HostAlias>();
        }
        for (HostAlias item : items) {
            this.hostAliases.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToHostAliases(Collection<HostAlias> items) {
        if (this.hostAliases == null) {
            this.hostAliases = new ArrayList<HostAlias>();
        }
        for (HostAlias item : items) {
            this.hostAliases.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromHostAliases(HostAlias ... items) {
        if (this.hostAliases == null) {
            return (A)((Object)this);
        }
        for (HostAlias item : items) {
            this.hostAliases.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromHostAliases(Collection<HostAlias> items) {
        if (this.hostAliases == null) {
            return (A)((Object)this);
        }
        for (HostAlias item : items) {
            this.hostAliases.remove(item);
        }
        return (A)((Object)this);
    }

    public List<HostAlias> getHostAliases() {
        return this.hostAliases;
    }

    public HostAlias getHostAlias(int index) {
        return this.hostAliases.get(index);
    }

    public HostAlias getFirstHostAlias() {
        return this.hostAliases.get(0);
    }

    public HostAlias getLastHostAlias() {
        return this.hostAliases.get(this.hostAliases.size() - 1);
    }

    public HostAlias getMatchingHostAlias(Predicate<HostAlias> predicate) {
        for (HostAlias item : this.hostAliases) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingHostAlias(Predicate<HostAlias> predicate) {
        for (HostAlias item : this.hostAliases) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withHostAliases(List<HostAlias> hostAliases) {
        if (hostAliases != null) {
            this.hostAliases = new ArrayList<HostAlias>();
            for (HostAlias item : hostAliases) {
                this.addToHostAliases(item);
            }
        } else {
            this.hostAliases = null;
        }
        return (A)((Object)this);
    }

    public A withHostAliases(HostAlias ... hostAliases) {
        if (this.hostAliases != null) {
            this.hostAliases.clear();
            this._visitables.remove((Object)"hostAliases");
        }
        if (hostAliases != null) {
            for (HostAlias item : hostAliases) {
                this.addToHostAliases(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasHostAliases() {
        return this.hostAliases != null && !this.hostAliases.isEmpty();
    }

    public Boolean getHostIPC() {
        return this.hostIPC;
    }

    public A withHostIPC(Boolean hostIPC) {
        this.hostIPC = hostIPC;
        return (A)((Object)this);
    }

    public boolean hasHostIPC() {
        return this.hostIPC != null;
    }

    public Boolean getHostNetwork() {
        return this.hostNetwork;
    }

    public A withHostNetwork(Boolean hostNetwork) {
        this.hostNetwork = hostNetwork;
        return (A)((Object)this);
    }

    public boolean hasHostNetwork() {
        return this.hostNetwork != null;
    }

    public Boolean getHostPID() {
        return this.hostPID;
    }

    public A withHostPID(Boolean hostPID) {
        this.hostPID = hostPID;
        return (A)((Object)this);
    }

    public boolean hasHostPID() {
        return this.hostPID != null;
    }

    public Boolean getHostUsers() {
        return this.hostUsers;
    }

    public A withHostUsers(Boolean hostUsers) {
        this.hostUsers = hostUsers;
        return (A)((Object)this);
    }

    public boolean hasHostUsers() {
        return this.hostUsers != null;
    }

    public String getHostname() {
        return this.hostname;
    }

    public A withHostname(String hostname) {
        this.hostname = hostname;
        return (A)((Object)this);
    }

    public boolean hasHostname() {
        return this.hostname != null;
    }

    public Long getIdleTimeoutSeconds() {
        return this.idleTimeoutSeconds;
    }

    public A withIdleTimeoutSeconds(Long idleTimeoutSeconds) {
        this.idleTimeoutSeconds = idleTimeoutSeconds;
        return (A)((Object)this);
    }

    public boolean hasIdleTimeoutSeconds() {
        return this.idleTimeoutSeconds != null;
    }

    public A addToImagePullSecrets(int index, LocalObjectReference item) {
        if (this.imagePullSecrets == null) {
            this.imagePullSecrets = new ArrayList();
        }
        LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
        if (index < 0 || index >= this.imagePullSecrets.size()) {
            this._visitables.get((Object)"imagePullSecrets").add(builder);
            this.imagePullSecrets.add(builder);
        } else {
            this._visitables.get((Object)"imagePullSecrets").add(builder);
            this.imagePullSecrets.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToImagePullSecrets(int index, LocalObjectReference item) {
        if (this.imagePullSecrets == null) {
            this.imagePullSecrets = new ArrayList();
        }
        LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
        if (index < 0 || index >= this.imagePullSecrets.size()) {
            this._visitables.get((Object)"imagePullSecrets").add(builder);
            this.imagePullSecrets.add(builder);
        } else {
            this._visitables.get((Object)"imagePullSecrets").add(builder);
            this.imagePullSecrets.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToImagePullSecrets(LocalObjectReference ... items) {
        if (this.imagePullSecrets == null) {
            this.imagePullSecrets = new ArrayList();
        }
        for (LocalObjectReference item : items) {
            LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
            this._visitables.get((Object)"imagePullSecrets").add(builder);
            this.imagePullSecrets.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToImagePullSecrets(Collection<LocalObjectReference> items) {
        if (this.imagePullSecrets == null) {
            this.imagePullSecrets = new ArrayList();
        }
        for (LocalObjectReference item : items) {
            LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
            this._visitables.get((Object)"imagePullSecrets").add(builder);
            this.imagePullSecrets.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromImagePullSecrets(LocalObjectReference ... items) {
        if (this.imagePullSecrets == null) {
            return (A)((Object)this);
        }
        for (LocalObjectReference item : items) {
            LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
            this._visitables.get((Object)"imagePullSecrets").remove(builder);
            this.imagePullSecrets.remove(builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromImagePullSecrets(Collection<LocalObjectReference> items) {
        if (this.imagePullSecrets == null) {
            return (A)((Object)this);
        }
        for (LocalObjectReference item : items) {
            LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
            this._visitables.get((Object)"imagePullSecrets").remove(builder);
            this.imagePullSecrets.remove(builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromImagePullSecrets(Predicate<LocalObjectReferenceBuilder> predicate) {
        if (this.imagePullSecrets == null) {
            return (A)((Object)this);
        }
        Iterator<LocalObjectReferenceBuilder> each = this.imagePullSecrets.iterator();
        List visitables = this._visitables.get((Object)"imagePullSecrets");
        while (each.hasNext()) {
            LocalObjectReferenceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<LocalObjectReference> buildImagePullSecrets() {
        return this.imagePullSecrets != null ? RevisionSpecFluent.build(this.imagePullSecrets) : null;
    }

    public LocalObjectReference buildImagePullSecret(int index) {
        return this.imagePullSecrets.get(index).build();
    }

    public LocalObjectReference buildFirstImagePullSecret() {
        return this.imagePullSecrets.get(0).build();
    }

    public LocalObjectReference buildLastImagePullSecret() {
        return this.imagePullSecrets.get(this.imagePullSecrets.size() - 1).build();
    }

    public LocalObjectReference buildMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate) {
        for (LocalObjectReferenceBuilder item : this.imagePullSecrets) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate) {
        for (LocalObjectReferenceBuilder item : this.imagePullSecrets) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withImagePullSecrets(List<LocalObjectReference> imagePullSecrets) {
        if (this.imagePullSecrets != null) {
            this._visitables.get((Object)"imagePullSecrets").clear();
        }
        if (imagePullSecrets != null) {
            this.imagePullSecrets = new ArrayList();
            for (LocalObjectReference item : imagePullSecrets) {
                this.addToImagePullSecrets(item);
            }
        } else {
            this.imagePullSecrets = null;
        }
        return (A)((Object)this);
    }

    public A withImagePullSecrets(LocalObjectReference ... imagePullSecrets) {
        if (this.imagePullSecrets != null) {
            this.imagePullSecrets.clear();
            this._visitables.remove((Object)"imagePullSecrets");
        }
        if (imagePullSecrets != null) {
            for (LocalObjectReference item : imagePullSecrets) {
                this.addToImagePullSecrets(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasImagePullSecrets() {
        return this.imagePullSecrets != null && !this.imagePullSecrets.isEmpty();
    }

    public A addNewImagePullSecret(String name) {
        return this.addToImagePullSecrets(new LocalObjectReference(name));
    }

    public ImagePullSecretsNested<A> addNewImagePullSecret() {
        return new ImagePullSecretsNested(-1, null);
    }

    public ImagePullSecretsNested<A> addNewImagePullSecretLike(LocalObjectReference item) {
        return new ImagePullSecretsNested(-1, item);
    }

    public ImagePullSecretsNested<A> setNewImagePullSecretLike(int index, LocalObjectReference item) {
        return new ImagePullSecretsNested(index, item);
    }

    public ImagePullSecretsNested<A> editImagePullSecret(int index) {
        if (this.imagePullSecrets.size() <= index) {
            throw new RuntimeException("Can't edit imagePullSecrets. Index exceeds size.");
        }
        return this.setNewImagePullSecretLike(index, this.buildImagePullSecret(index));
    }

    public ImagePullSecretsNested<A> editFirstImagePullSecret() {
        if (this.imagePullSecrets.size() == 0) {
            throw new RuntimeException("Can't edit first imagePullSecrets. The list is empty.");
        }
        return this.setNewImagePullSecretLike(0, this.buildImagePullSecret(0));
    }

    public ImagePullSecretsNested<A> editLastImagePullSecret() {
        int index = this.imagePullSecrets.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last imagePullSecrets. The list is empty.");
        }
        return this.setNewImagePullSecretLike(index, this.buildImagePullSecret(index));
    }

    public ImagePullSecretsNested<A> editMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.imagePullSecrets.size(); ++i) {
            if (!predicate.test(this.imagePullSecrets.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching imagePullSecrets. No match found.");
        }
        return this.setNewImagePullSecretLike(index, this.buildImagePullSecret(index));
    }

    public A addToInitContainers(int index, Container item) {
        if (this.initContainers == null) {
            this.initContainers = new ArrayList();
        }
        ContainerBuilder builder = new ContainerBuilder(item);
        if (index < 0 || index >= this.initContainers.size()) {
            this._visitables.get((Object)"initContainers").add(builder);
            this.initContainers.add(builder);
        } else {
            this._visitables.get((Object)"initContainers").add(builder);
            this.initContainers.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToInitContainers(int index, Container item) {
        if (this.initContainers == null) {
            this.initContainers = new ArrayList();
        }
        ContainerBuilder builder = new ContainerBuilder(item);
        if (index < 0 || index >= this.initContainers.size()) {
            this._visitables.get((Object)"initContainers").add(builder);
            this.initContainers.add(builder);
        } else {
            this._visitables.get((Object)"initContainers").add(builder);
            this.initContainers.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToInitContainers(Container ... items) {
        if (this.initContainers == null) {
            this.initContainers = new ArrayList();
        }
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get((Object)"initContainers").add(builder);
            this.initContainers.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToInitContainers(Collection<Container> items) {
        if (this.initContainers == null) {
            this.initContainers = new ArrayList();
        }
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get((Object)"initContainers").add(builder);
            this.initContainers.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromInitContainers(Container ... items) {
        if (this.initContainers == null) {
            return (A)((Object)this);
        }
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get((Object)"initContainers").remove(builder);
            this.initContainers.remove(builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromInitContainers(Collection<Container> items) {
        if (this.initContainers == null) {
            return (A)((Object)this);
        }
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get((Object)"initContainers").remove(builder);
            this.initContainers.remove(builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromInitContainers(Predicate<ContainerBuilder> predicate) {
        if (this.initContainers == null) {
            return (A)((Object)this);
        }
        Iterator<ContainerBuilder> each = this.initContainers.iterator();
        List visitables = this._visitables.get((Object)"initContainers");
        while (each.hasNext()) {
            ContainerBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Container> buildInitContainers() {
        return this.initContainers != null ? RevisionSpecFluent.build(this.initContainers) : null;
    }

    public Container buildInitContainer(int index) {
        return this.initContainers.get(index).build();
    }

    public Container buildFirstInitContainer() {
        return this.initContainers.get(0).build();
    }

    public Container buildLastInitContainer() {
        return this.initContainers.get(this.initContainers.size() - 1).build();
    }

    public Container buildMatchingInitContainer(Predicate<ContainerBuilder> predicate) {
        for (ContainerBuilder item : this.initContainers) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingInitContainer(Predicate<ContainerBuilder> predicate) {
        for (ContainerBuilder item : this.initContainers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withInitContainers(List<Container> initContainers) {
        if (this.initContainers != null) {
            this._visitables.get((Object)"initContainers").clear();
        }
        if (initContainers != null) {
            this.initContainers = new ArrayList();
            for (Container item : initContainers) {
                this.addToInitContainers(item);
            }
        } else {
            this.initContainers = null;
        }
        return (A)((Object)this);
    }

    public A withInitContainers(Container ... initContainers) {
        if (this.initContainers != null) {
            this.initContainers.clear();
            this._visitables.remove((Object)"initContainers");
        }
        if (initContainers != null) {
            for (Container item : initContainers) {
                this.addToInitContainers(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasInitContainers() {
        return this.initContainers != null && !this.initContainers.isEmpty();
    }

    public InitContainersNested<A> addNewInitContainer() {
        return new InitContainersNested(-1, null);
    }

    public InitContainersNested<A> addNewInitContainerLike(Container item) {
        return new InitContainersNested(-1, item);
    }

    public InitContainersNested<A> setNewInitContainerLike(int index, Container item) {
        return new InitContainersNested(index, item);
    }

    public InitContainersNested<A> editInitContainer(int index) {
        if (this.initContainers.size() <= index) {
            throw new RuntimeException("Can't edit initContainers. Index exceeds size.");
        }
        return this.setNewInitContainerLike(index, this.buildInitContainer(index));
    }

    public InitContainersNested<A> editFirstInitContainer() {
        if (this.initContainers.size() == 0) {
            throw new RuntimeException("Can't edit first initContainers. The list is empty.");
        }
        return this.setNewInitContainerLike(0, this.buildInitContainer(0));
    }

    public InitContainersNested<A> editLastInitContainer() {
        int index = this.initContainers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last initContainers. The list is empty.");
        }
        return this.setNewInitContainerLike(index, this.buildInitContainer(index));
    }

    public InitContainersNested<A> editMatchingInitContainer(Predicate<ContainerBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.initContainers.size(); ++i) {
            if (!predicate.test(this.initContainers.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching initContainers. No match found.");
        }
        return this.setNewInitContainerLike(index, this.buildInitContainer(index));
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public A withNodeName(String nodeName) {
        this.nodeName = nodeName;
        return (A)((Object)this);
    }

    public boolean hasNodeName() {
        return this.nodeName != null;
    }

    public A addToNodeSelector(String key, String value) {
        if (this.nodeSelector == null && key != null && value != null) {
            this.nodeSelector = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.nodeSelector.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToNodeSelector(Map<String, String> map) {
        if (this.nodeSelector == null && map != null) {
            this.nodeSelector = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.nodeSelector.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromNodeSelector(String key) {
        if (this.nodeSelector == null) {
            return (A)((Object)this);
        }
        if (key != null && this.nodeSelector != null) {
            this.nodeSelector.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromNodeSelector(Map<String, String> map) {
        if (this.nodeSelector == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.nodeSelector == null) continue;
                this.nodeSelector.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, String> getNodeSelector() {
        return this.nodeSelector;
    }

    public <K, V> A withNodeSelector(Map<String, String> nodeSelector) {
        this.nodeSelector = nodeSelector == null ? null : new LinkedHashMap<String, String>(nodeSelector);
        return (A)((Object)this);
    }

    public boolean hasNodeSelector() {
        return this.nodeSelector != null;
    }

    public PodOS getOs() {
        return this.os;
    }

    public A withOs(PodOS os) {
        this.os = os;
        return (A)((Object)this);
    }

    public boolean hasOs() {
        return this.os != null;
    }

    public A withNewOs(String name) {
        return this.withOs(new PodOS(name));
    }

    public A addToOverhead(String key, Quantity value) {
        if (this.overhead == null && key != null && value != null) {
            this.overhead = new LinkedHashMap<String, Quantity>();
        }
        if (key != null && value != null) {
            this.overhead.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToOverhead(Map<String, Quantity> map) {
        if (this.overhead == null && map != null) {
            this.overhead = new LinkedHashMap<String, Quantity>();
        }
        if (map != null) {
            this.overhead.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromOverhead(String key) {
        if (this.overhead == null) {
            return (A)((Object)this);
        }
        if (key != null && this.overhead != null) {
            this.overhead.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromOverhead(Map<String, Quantity> map) {
        if (this.overhead == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.overhead == null) continue;
                this.overhead.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Quantity> getOverhead() {
        return this.overhead;
    }

    public <K, V> A withOverhead(Map<String, Quantity> overhead) {
        this.overhead = overhead == null ? null : new LinkedHashMap<String, Quantity>(overhead);
        return (A)((Object)this);
    }

    public boolean hasOverhead() {
        return this.overhead != null;
    }

    public String getPreemptionPolicy() {
        return this.preemptionPolicy;
    }

    public A withPreemptionPolicy(String preemptionPolicy) {
        this.preemptionPolicy = preemptionPolicy;
        return (A)((Object)this);
    }

    public boolean hasPreemptionPolicy() {
        return this.preemptionPolicy != null;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public A withPriority(Integer priority) {
        this.priority = priority;
        return (A)((Object)this);
    }

    public boolean hasPriority() {
        return this.priority != null;
    }

    public String getPriorityClassName() {
        return this.priorityClassName;
    }

    public A withPriorityClassName(String priorityClassName) {
        this.priorityClassName = priorityClassName;
        return (A)((Object)this);
    }

    public boolean hasPriorityClassName() {
        return this.priorityClassName != null;
    }

    public A addToReadinessGates(int index, PodReadinessGate item) {
        if (this.readinessGates == null) {
            this.readinessGates = new ArrayList<PodReadinessGate>();
        }
        this.readinessGates.add(index, item);
        return (A)((Object)this);
    }

    public A setToReadinessGates(int index, PodReadinessGate item) {
        if (this.readinessGates == null) {
            this.readinessGates = new ArrayList<PodReadinessGate>();
        }
        this.readinessGates.set(index, item);
        return (A)((Object)this);
    }

    public A addToReadinessGates(PodReadinessGate ... items) {
        if (this.readinessGates == null) {
            this.readinessGates = new ArrayList<PodReadinessGate>();
        }
        for (PodReadinessGate item : items) {
            this.readinessGates.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToReadinessGates(Collection<PodReadinessGate> items) {
        if (this.readinessGates == null) {
            this.readinessGates = new ArrayList<PodReadinessGate>();
        }
        for (PodReadinessGate item : items) {
            this.readinessGates.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromReadinessGates(PodReadinessGate ... items) {
        if (this.readinessGates == null) {
            return (A)((Object)this);
        }
        for (PodReadinessGate item : items) {
            this.readinessGates.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromReadinessGates(Collection<PodReadinessGate> items) {
        if (this.readinessGates == null) {
            return (A)((Object)this);
        }
        for (PodReadinessGate item : items) {
            this.readinessGates.remove(item);
        }
        return (A)((Object)this);
    }

    public List<PodReadinessGate> getReadinessGates() {
        return this.readinessGates;
    }

    public PodReadinessGate getReadinessGate(int index) {
        return this.readinessGates.get(index);
    }

    public PodReadinessGate getFirstReadinessGate() {
        return this.readinessGates.get(0);
    }

    public PodReadinessGate getLastReadinessGate() {
        return this.readinessGates.get(this.readinessGates.size() - 1);
    }

    public PodReadinessGate getMatchingReadinessGate(Predicate<PodReadinessGate> predicate) {
        for (PodReadinessGate item : this.readinessGates) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingReadinessGate(Predicate<PodReadinessGate> predicate) {
        for (PodReadinessGate item : this.readinessGates) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withReadinessGates(List<PodReadinessGate> readinessGates) {
        if (readinessGates != null) {
            this.readinessGates = new ArrayList<PodReadinessGate>();
            for (PodReadinessGate item : readinessGates) {
                this.addToReadinessGates(item);
            }
        } else {
            this.readinessGates = null;
        }
        return (A)((Object)this);
    }

    public A withReadinessGates(PodReadinessGate ... readinessGates) {
        if (this.readinessGates != null) {
            this.readinessGates.clear();
            this._visitables.remove((Object)"readinessGates");
        }
        if (readinessGates != null) {
            for (PodReadinessGate item : readinessGates) {
                this.addToReadinessGates(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasReadinessGates() {
        return this.readinessGates != null && !this.readinessGates.isEmpty();
    }

    public A addNewReadinessGate(String conditionType) {
        return this.addToReadinessGates(new PodReadinessGate(conditionType));
    }

    public A addToResourceClaims(int index, PodResourceClaim item) {
        if (this.resourceClaims == null) {
            this.resourceClaims = new ArrayList<PodResourceClaim>();
        }
        this.resourceClaims.add(index, item);
        return (A)((Object)this);
    }

    public A setToResourceClaims(int index, PodResourceClaim item) {
        if (this.resourceClaims == null) {
            this.resourceClaims = new ArrayList<PodResourceClaim>();
        }
        this.resourceClaims.set(index, item);
        return (A)((Object)this);
    }

    public A addToResourceClaims(PodResourceClaim ... items) {
        if (this.resourceClaims == null) {
            this.resourceClaims = new ArrayList<PodResourceClaim>();
        }
        for (PodResourceClaim item : items) {
            this.resourceClaims.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToResourceClaims(Collection<PodResourceClaim> items) {
        if (this.resourceClaims == null) {
            this.resourceClaims = new ArrayList<PodResourceClaim>();
        }
        for (PodResourceClaim item : items) {
            this.resourceClaims.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromResourceClaims(PodResourceClaim ... items) {
        if (this.resourceClaims == null) {
            return (A)((Object)this);
        }
        for (PodResourceClaim item : items) {
            this.resourceClaims.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromResourceClaims(Collection<PodResourceClaim> items) {
        if (this.resourceClaims == null) {
            return (A)((Object)this);
        }
        for (PodResourceClaim item : items) {
            this.resourceClaims.remove(item);
        }
        return (A)((Object)this);
    }

    public List<PodResourceClaim> getResourceClaims() {
        return this.resourceClaims;
    }

    public PodResourceClaim getResourceClaim(int index) {
        return this.resourceClaims.get(index);
    }

    public PodResourceClaim getFirstResourceClaim() {
        return this.resourceClaims.get(0);
    }

    public PodResourceClaim getLastResourceClaim() {
        return this.resourceClaims.get(this.resourceClaims.size() - 1);
    }

    public PodResourceClaim getMatchingResourceClaim(Predicate<PodResourceClaim> predicate) {
        for (PodResourceClaim item : this.resourceClaims) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingResourceClaim(Predicate<PodResourceClaim> predicate) {
        for (PodResourceClaim item : this.resourceClaims) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withResourceClaims(List<PodResourceClaim> resourceClaims) {
        if (resourceClaims != null) {
            this.resourceClaims = new ArrayList<PodResourceClaim>();
            for (PodResourceClaim item : resourceClaims) {
                this.addToResourceClaims(item);
            }
        } else {
            this.resourceClaims = null;
        }
        return (A)((Object)this);
    }

    public A withResourceClaims(PodResourceClaim ... resourceClaims) {
        if (this.resourceClaims != null) {
            this.resourceClaims.clear();
            this._visitables.remove((Object)"resourceClaims");
        }
        if (resourceClaims != null) {
            for (PodResourceClaim item : resourceClaims) {
                this.addToResourceClaims(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasResourceClaims() {
        return this.resourceClaims != null && !this.resourceClaims.isEmpty();
    }

    public A addNewResourceClaim(String name, String resourceClaimName, String resourceClaimTemplateName) {
        return this.addToResourceClaims(new PodResourceClaim(name, resourceClaimName, resourceClaimTemplateName));
    }

    public Long getResponseStartTimeoutSeconds() {
        return this.responseStartTimeoutSeconds;
    }

    public A withResponseStartTimeoutSeconds(Long responseStartTimeoutSeconds) {
        this.responseStartTimeoutSeconds = responseStartTimeoutSeconds;
        return (A)((Object)this);
    }

    public boolean hasResponseStartTimeoutSeconds() {
        return this.responseStartTimeoutSeconds != null;
    }

    public String getRestartPolicy() {
        return this.restartPolicy;
    }

    public A withRestartPolicy(String restartPolicy) {
        this.restartPolicy = restartPolicy;
        return (A)((Object)this);
    }

    public boolean hasRestartPolicy() {
        return this.restartPolicy != null;
    }

    public String getRuntimeClassName() {
        return this.runtimeClassName;
    }

    public A withRuntimeClassName(String runtimeClassName) {
        this.runtimeClassName = runtimeClassName;
        return (A)((Object)this);
    }

    public boolean hasRuntimeClassName() {
        return this.runtimeClassName != null;
    }

    public String getSchedulerName() {
        return this.schedulerName;
    }

    public A withSchedulerName(String schedulerName) {
        this.schedulerName = schedulerName;
        return (A)((Object)this);
    }

    public boolean hasSchedulerName() {
        return this.schedulerName != null;
    }

    public A addToSchedulingGates(int index, PodSchedulingGate item) {
        if (this.schedulingGates == null) {
            this.schedulingGates = new ArrayList<PodSchedulingGate>();
        }
        this.schedulingGates.add(index, item);
        return (A)((Object)this);
    }

    public A setToSchedulingGates(int index, PodSchedulingGate item) {
        if (this.schedulingGates == null) {
            this.schedulingGates = new ArrayList<PodSchedulingGate>();
        }
        this.schedulingGates.set(index, item);
        return (A)((Object)this);
    }

    public A addToSchedulingGates(PodSchedulingGate ... items) {
        if (this.schedulingGates == null) {
            this.schedulingGates = new ArrayList<PodSchedulingGate>();
        }
        for (PodSchedulingGate item : items) {
            this.schedulingGates.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToSchedulingGates(Collection<PodSchedulingGate> items) {
        if (this.schedulingGates == null) {
            this.schedulingGates = new ArrayList<PodSchedulingGate>();
        }
        for (PodSchedulingGate item : items) {
            this.schedulingGates.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromSchedulingGates(PodSchedulingGate ... items) {
        if (this.schedulingGates == null) {
            return (A)((Object)this);
        }
        for (PodSchedulingGate item : items) {
            this.schedulingGates.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromSchedulingGates(Collection<PodSchedulingGate> items) {
        if (this.schedulingGates == null) {
            return (A)((Object)this);
        }
        for (PodSchedulingGate item : items) {
            this.schedulingGates.remove(item);
        }
        return (A)((Object)this);
    }

    public List<PodSchedulingGate> getSchedulingGates() {
        return this.schedulingGates;
    }

    public PodSchedulingGate getSchedulingGate(int index) {
        return this.schedulingGates.get(index);
    }

    public PodSchedulingGate getFirstSchedulingGate() {
        return this.schedulingGates.get(0);
    }

    public PodSchedulingGate getLastSchedulingGate() {
        return this.schedulingGates.get(this.schedulingGates.size() - 1);
    }

    public PodSchedulingGate getMatchingSchedulingGate(Predicate<PodSchedulingGate> predicate) {
        for (PodSchedulingGate item : this.schedulingGates) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingSchedulingGate(Predicate<PodSchedulingGate> predicate) {
        for (PodSchedulingGate item : this.schedulingGates) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSchedulingGates(List<PodSchedulingGate> schedulingGates) {
        if (schedulingGates != null) {
            this.schedulingGates = new ArrayList<PodSchedulingGate>();
            for (PodSchedulingGate item : schedulingGates) {
                this.addToSchedulingGates(item);
            }
        } else {
            this.schedulingGates = null;
        }
        return (A)((Object)this);
    }

    public A withSchedulingGates(PodSchedulingGate ... schedulingGates) {
        if (this.schedulingGates != null) {
            this.schedulingGates.clear();
            this._visitables.remove((Object)"schedulingGates");
        }
        if (schedulingGates != null) {
            for (PodSchedulingGate item : schedulingGates) {
                this.addToSchedulingGates(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasSchedulingGates() {
        return this.schedulingGates != null && !this.schedulingGates.isEmpty();
    }

    public A addNewSchedulingGate(String name) {
        return this.addToSchedulingGates(new PodSchedulingGate(name));
    }

    public PodSecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public A withSecurityContext(PodSecurityContext securityContext) {
        this.securityContext = securityContext;
        return (A)((Object)this);
    }

    public boolean hasSecurityContext() {
        return this.securityContext != null;
    }

    public String getServiceAccount() {
        return this.serviceAccount;
    }

    public A withServiceAccount(String serviceAccount) {
        this.serviceAccount = serviceAccount;
        return (A)((Object)this);
    }

    public boolean hasServiceAccount() {
        return this.serviceAccount != null;
    }

    public String getServiceAccountName() {
        return this.serviceAccountName;
    }

    public A withServiceAccountName(String serviceAccountName) {
        this.serviceAccountName = serviceAccountName;
        return (A)((Object)this);
    }

    public boolean hasServiceAccountName() {
        return this.serviceAccountName != null;
    }

    public Boolean getSetHostnameAsFQDN() {
        return this.setHostnameAsFQDN;
    }

    public A withSetHostnameAsFQDN(Boolean setHostnameAsFQDN) {
        this.setHostnameAsFQDN = setHostnameAsFQDN;
        return (A)((Object)this);
    }

    public boolean hasSetHostnameAsFQDN() {
        return this.setHostnameAsFQDN != null;
    }

    public Boolean getShareProcessNamespace() {
        return this.shareProcessNamespace;
    }

    public A withShareProcessNamespace(Boolean shareProcessNamespace) {
        this.shareProcessNamespace = shareProcessNamespace;
        return (A)((Object)this);
    }

    public boolean hasShareProcessNamespace() {
        return this.shareProcessNamespace != null;
    }

    public String getSubdomain() {
        return this.subdomain;
    }

    public A withSubdomain(String subdomain) {
        this.subdomain = subdomain;
        return (A)((Object)this);
    }

    public boolean hasSubdomain() {
        return this.subdomain != null;
    }

    public Long getTerminationGracePeriodSeconds() {
        return this.terminationGracePeriodSeconds;
    }

    public A withTerminationGracePeriodSeconds(Long terminationGracePeriodSeconds) {
        this.terminationGracePeriodSeconds = terminationGracePeriodSeconds;
        return (A)((Object)this);
    }

    public boolean hasTerminationGracePeriodSeconds() {
        return this.terminationGracePeriodSeconds != null;
    }

    public Long getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    public A withTimeoutSeconds(Long timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
        return (A)((Object)this);
    }

    public boolean hasTimeoutSeconds() {
        return this.timeoutSeconds != null;
    }

    public A addToTolerations(int index, Toleration item) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        }
        this.tolerations.add(index, item);
        return (A)((Object)this);
    }

    public A setToTolerations(int index, Toleration item) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        }
        this.tolerations.set(index, item);
        return (A)((Object)this);
    }

    public A addToTolerations(Toleration ... items) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        }
        for (Toleration item : items) {
            this.tolerations.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToTolerations(Collection<Toleration> items) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        }
        for (Toleration item : items) {
            this.tolerations.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromTolerations(Toleration ... items) {
        if (this.tolerations == null) {
            return (A)((Object)this);
        }
        for (Toleration item : items) {
            this.tolerations.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromTolerations(Collection<Toleration> items) {
        if (this.tolerations == null) {
            return (A)((Object)this);
        }
        for (Toleration item : items) {
            this.tolerations.remove(item);
        }
        return (A)((Object)this);
    }

    public List<Toleration> getTolerations() {
        return this.tolerations;
    }

    public Toleration getToleration(int index) {
        return this.tolerations.get(index);
    }

    public Toleration getFirstToleration() {
        return this.tolerations.get(0);
    }

    public Toleration getLastToleration() {
        return this.tolerations.get(this.tolerations.size() - 1);
    }

    public Toleration getMatchingToleration(Predicate<Toleration> predicate) {
        for (Toleration item : this.tolerations) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingToleration(Predicate<Toleration> predicate) {
        for (Toleration item : this.tolerations) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTolerations(List<Toleration> tolerations) {
        if (tolerations != null) {
            this.tolerations = new ArrayList<Toleration>();
            for (Toleration item : tolerations) {
                this.addToTolerations(item);
            }
        } else {
            this.tolerations = null;
        }
        return (A)((Object)this);
    }

    public A withTolerations(Toleration ... tolerations) {
        if (this.tolerations != null) {
            this.tolerations.clear();
            this._visitables.remove((Object)"tolerations");
        }
        if (tolerations != null) {
            for (Toleration item : tolerations) {
                this.addToTolerations(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasTolerations() {
        return this.tolerations != null && !this.tolerations.isEmpty();
    }

    public A addNewToleration(String effect, String key, String operator, Long tolerationSeconds, String value) {
        return this.addToTolerations(new Toleration(effect, key, operator, tolerationSeconds, value));
    }

    public A addToTopologySpreadConstraints(int index, TopologySpreadConstraint item) {
        if (this.topologySpreadConstraints == null) {
            this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();
        }
        this.topologySpreadConstraints.add(index, item);
        return (A)((Object)this);
    }

    public A setToTopologySpreadConstraints(int index, TopologySpreadConstraint item) {
        if (this.topologySpreadConstraints == null) {
            this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();
        }
        this.topologySpreadConstraints.set(index, item);
        return (A)((Object)this);
    }

    public A addToTopologySpreadConstraints(TopologySpreadConstraint ... items) {
        if (this.topologySpreadConstraints == null) {
            this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();
        }
        for (TopologySpreadConstraint item : items) {
            this.topologySpreadConstraints.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToTopologySpreadConstraints(Collection<TopologySpreadConstraint> items) {
        if (this.topologySpreadConstraints == null) {
            this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();
        }
        for (TopologySpreadConstraint item : items) {
            this.topologySpreadConstraints.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromTopologySpreadConstraints(TopologySpreadConstraint ... items) {
        if (this.topologySpreadConstraints == null) {
            return (A)((Object)this);
        }
        for (TopologySpreadConstraint item : items) {
            this.topologySpreadConstraints.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromTopologySpreadConstraints(Collection<TopologySpreadConstraint> items) {
        if (this.topologySpreadConstraints == null) {
            return (A)((Object)this);
        }
        for (TopologySpreadConstraint item : items) {
            this.topologySpreadConstraints.remove(item);
        }
        return (A)((Object)this);
    }

    public List<TopologySpreadConstraint> getTopologySpreadConstraints() {
        return this.topologySpreadConstraints;
    }

    public TopologySpreadConstraint getTopologySpreadConstraint(int index) {
        return this.topologySpreadConstraints.get(index);
    }

    public TopologySpreadConstraint getFirstTopologySpreadConstraint() {
        return this.topologySpreadConstraints.get(0);
    }

    public TopologySpreadConstraint getLastTopologySpreadConstraint() {
        return this.topologySpreadConstraints.get(this.topologySpreadConstraints.size() - 1);
    }

    public TopologySpreadConstraint getMatchingTopologySpreadConstraint(Predicate<TopologySpreadConstraint> predicate) {
        for (TopologySpreadConstraint item : this.topologySpreadConstraints) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingTopologySpreadConstraint(Predicate<TopologySpreadConstraint> predicate) {
        for (TopologySpreadConstraint item : this.topologySpreadConstraints) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTopologySpreadConstraints(List<TopologySpreadConstraint> topologySpreadConstraints) {
        if (topologySpreadConstraints != null) {
            this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();
            for (TopologySpreadConstraint item : topologySpreadConstraints) {
                this.addToTopologySpreadConstraints(item);
            }
        } else {
            this.topologySpreadConstraints = null;
        }
        return (A)((Object)this);
    }

    public A withTopologySpreadConstraints(TopologySpreadConstraint ... topologySpreadConstraints) {
        if (this.topologySpreadConstraints != null) {
            this.topologySpreadConstraints.clear();
            this._visitables.remove((Object)"topologySpreadConstraints");
        }
        if (topologySpreadConstraints != null) {
            for (TopologySpreadConstraint item : topologySpreadConstraints) {
                this.addToTopologySpreadConstraints(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasTopologySpreadConstraints() {
        return this.topologySpreadConstraints != null && !this.topologySpreadConstraints.isEmpty();
    }

    public A addToVolumes(int index, Volume item) {
        if (this.volumes == null) {
            this.volumes = new ArrayList();
        }
        VolumeBuilder builder = new VolumeBuilder(item);
        if (index < 0 || index >= this.volumes.size()) {
            this._visitables.get((Object)"volumes").add(builder);
            this.volumes.add(builder);
        } else {
            this._visitables.get((Object)"volumes").add(builder);
            this.volumes.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToVolumes(int index, Volume item) {
        if (this.volumes == null) {
            this.volumes = new ArrayList();
        }
        VolumeBuilder builder = new VolumeBuilder(item);
        if (index < 0 || index >= this.volumes.size()) {
            this._visitables.get((Object)"volumes").add(builder);
            this.volumes.add(builder);
        } else {
            this._visitables.get((Object)"volumes").add(builder);
            this.volumes.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToVolumes(Volume ... items) {
        if (this.volumes == null) {
            this.volumes = new ArrayList();
        }
        for (Volume item : items) {
            VolumeBuilder builder = new VolumeBuilder(item);
            this._visitables.get((Object)"volumes").add(builder);
            this.volumes.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToVolumes(Collection<Volume> items) {
        if (this.volumes == null) {
            this.volumes = new ArrayList();
        }
        for (Volume item : items) {
            VolumeBuilder builder = new VolumeBuilder(item);
            this._visitables.get((Object)"volumes").add(builder);
            this.volumes.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromVolumes(Volume ... items) {
        if (this.volumes == null) {
            return (A)((Object)this);
        }
        for (Volume item : items) {
            VolumeBuilder builder = new VolumeBuilder(item);
            this._visitables.get((Object)"volumes").remove(builder);
            this.volumes.remove(builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromVolumes(Collection<Volume> items) {
        if (this.volumes == null) {
            return (A)((Object)this);
        }
        for (Volume item : items) {
            VolumeBuilder builder = new VolumeBuilder(item);
            this._visitables.get((Object)"volumes").remove(builder);
            this.volumes.remove(builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromVolumes(Predicate<VolumeBuilder> predicate) {
        if (this.volumes == null) {
            return (A)((Object)this);
        }
        Iterator<VolumeBuilder> each = this.volumes.iterator();
        List visitables = this._visitables.get((Object)"volumes");
        while (each.hasNext()) {
            VolumeBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Volume> buildVolumes() {
        return this.volumes != null ? RevisionSpecFluent.build(this.volumes) : null;
    }

    public Volume buildVolume(int index) {
        return this.volumes.get(index).build();
    }

    public Volume buildFirstVolume() {
        return this.volumes.get(0).build();
    }

    public Volume buildLastVolume() {
        return this.volumes.get(this.volumes.size() - 1).build();
    }

    public Volume buildMatchingVolume(Predicate<VolumeBuilder> predicate) {
        for (VolumeBuilder item : this.volumes) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingVolume(Predicate<VolumeBuilder> predicate) {
        for (VolumeBuilder item : this.volumes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withVolumes(List<Volume> volumes) {
        if (this.volumes != null) {
            this._visitables.get((Object)"volumes").clear();
        }
        if (volumes != null) {
            this.volumes = new ArrayList();
            for (Volume item : volumes) {
                this.addToVolumes(item);
            }
        } else {
            this.volumes = null;
        }
        return (A)((Object)this);
    }

    public A withVolumes(Volume ... volumes) {
        if (this.volumes != null) {
            this.volumes.clear();
            this._visitables.remove((Object)"volumes");
        }
        if (volumes != null) {
            for (Volume item : volumes) {
                this.addToVolumes(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasVolumes() {
        return this.volumes != null && !this.volumes.isEmpty();
    }

    public VolumesNested<A> addNewVolume() {
        return new VolumesNested(-1, null);
    }

    public VolumesNested<A> addNewVolumeLike(Volume item) {
        return new VolumesNested(-1, item);
    }

    public VolumesNested<A> setNewVolumeLike(int index, Volume item) {
        return new VolumesNested(index, item);
    }

    public VolumesNested<A> editVolume(int index) {
        if (this.volumes.size() <= index) {
            throw new RuntimeException("Can't edit volumes. Index exceeds size.");
        }
        return this.setNewVolumeLike(index, this.buildVolume(index));
    }

    public VolumesNested<A> editFirstVolume() {
        if (this.volumes.size() == 0) {
            throw new RuntimeException("Can't edit first volumes. The list is empty.");
        }
        return this.setNewVolumeLike(0, this.buildVolume(0));
    }

    public VolumesNested<A> editLastVolume() {
        int index = this.volumes.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last volumes. The list is empty.");
        }
        return this.setNewVolumeLike(index, this.buildVolume(index));
    }

    public VolumesNested<A> editMatchingVolume(Predicate<VolumeBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.volumes.size(); ++i) {
            if (!predicate.test(this.volumes.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching volumes. No match found.");
        }
        return this.setNewVolumeLike(index, this.buildVolume(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RevisionSpecFluent that = (RevisionSpecFluent)((Object)o);
        if (!Objects.equals(this.activeDeadlineSeconds, that.activeDeadlineSeconds)) {
            return false;
        }
        if (!Objects.equals(this.affinity, that.affinity)) {
            return false;
        }
        if (!Objects.equals(this.automountServiceAccountToken, that.automountServiceAccountToken)) {
            return false;
        }
        if (!Objects.equals(this.containerConcurrency, that.containerConcurrency)) {
            return false;
        }
        if (!Objects.equals(this.containers, that.containers)) {
            return false;
        }
        if (!Objects.equals(this.dnsConfig, that.dnsConfig)) {
            return false;
        }
        if (!Objects.equals(this.dnsPolicy, that.dnsPolicy)) {
            return false;
        }
        if (!Objects.equals(this.enableServiceLinks, that.enableServiceLinks)) {
            return false;
        }
        if (!Objects.equals(this.ephemeralContainers, that.ephemeralContainers)) {
            return false;
        }
        if (!Objects.equals(this.hostAliases, that.hostAliases)) {
            return false;
        }
        if (!Objects.equals(this.hostIPC, that.hostIPC)) {
            return false;
        }
        if (!Objects.equals(this.hostNetwork, that.hostNetwork)) {
            return false;
        }
        if (!Objects.equals(this.hostPID, that.hostPID)) {
            return false;
        }
        if (!Objects.equals(this.hostUsers, that.hostUsers)) {
            return false;
        }
        if (!Objects.equals(this.hostname, that.hostname)) {
            return false;
        }
        if (!Objects.equals(this.idleTimeoutSeconds, that.idleTimeoutSeconds)) {
            return false;
        }
        if (!Objects.equals(this.imagePullSecrets, that.imagePullSecrets)) {
            return false;
        }
        if (!Objects.equals(this.initContainers, that.initContainers)) {
            return false;
        }
        if (!Objects.equals(this.nodeName, that.nodeName)) {
            return false;
        }
        if (!Objects.equals(this.nodeSelector, that.nodeSelector)) {
            return false;
        }
        if (!Objects.equals(this.os, that.os)) {
            return false;
        }
        if (!Objects.equals(this.overhead, that.overhead)) {
            return false;
        }
        if (!Objects.equals(this.preemptionPolicy, that.preemptionPolicy)) {
            return false;
        }
        if (!Objects.equals(this.priority, that.priority)) {
            return false;
        }
        if (!Objects.equals(this.priorityClassName, that.priorityClassName)) {
            return false;
        }
        if (!Objects.equals(this.readinessGates, that.readinessGates)) {
            return false;
        }
        if (!Objects.equals(this.resourceClaims, that.resourceClaims)) {
            return false;
        }
        if (!Objects.equals(this.responseStartTimeoutSeconds, that.responseStartTimeoutSeconds)) {
            return false;
        }
        if (!Objects.equals(this.restartPolicy, that.restartPolicy)) {
            return false;
        }
        if (!Objects.equals(this.runtimeClassName, that.runtimeClassName)) {
            return false;
        }
        if (!Objects.equals(this.schedulerName, that.schedulerName)) {
            return false;
        }
        if (!Objects.equals(this.schedulingGates, that.schedulingGates)) {
            return false;
        }
        if (!Objects.equals(this.securityContext, that.securityContext)) {
            return false;
        }
        if (!Objects.equals(this.serviceAccount, that.serviceAccount)) {
            return false;
        }
        if (!Objects.equals(this.serviceAccountName, that.serviceAccountName)) {
            return false;
        }
        if (!Objects.equals(this.setHostnameAsFQDN, that.setHostnameAsFQDN)) {
            return false;
        }
        if (!Objects.equals(this.shareProcessNamespace, that.shareProcessNamespace)) {
            return false;
        }
        if (!Objects.equals(this.subdomain, that.subdomain)) {
            return false;
        }
        if (!Objects.equals(this.terminationGracePeriodSeconds, that.terminationGracePeriodSeconds)) {
            return false;
        }
        if (!Objects.equals(this.timeoutSeconds, that.timeoutSeconds)) {
            return false;
        }
        if (!Objects.equals(this.tolerations, that.tolerations)) {
            return false;
        }
        if (!Objects.equals(this.topologySpreadConstraints, that.topologySpreadConstraints)) {
            return false;
        }
        if (!Objects.equals(this.volumes, that.volumes)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.activeDeadlineSeconds, this.affinity, this.automountServiceAccountToken, this.containerConcurrency, this.containers, this.dnsConfig, this.dnsPolicy, this.enableServiceLinks, this.ephemeralContainers, this.hostAliases, this.hostIPC, this.hostNetwork, this.hostPID, this.hostUsers, this.hostname, this.idleTimeoutSeconds, this.imagePullSecrets, this.initContainers, this.nodeName, this.nodeSelector, this.os, this.overhead, this.preemptionPolicy, this.priority, this.priorityClassName, this.readinessGates, this.resourceClaims, this.responseStartTimeoutSeconds, this.restartPolicy, this.runtimeClassName, this.schedulerName, this.schedulingGates, this.securityContext, this.serviceAccount, this.serviceAccountName, this.setHostnameAsFQDN, this.shareProcessNamespace, this.subdomain, this.terminationGracePeriodSeconds, this.timeoutSeconds, this.tolerations, this.topologySpreadConstraints, this.volumes, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.activeDeadlineSeconds != null) {
            sb.append("activeDeadlineSeconds:");
            sb.append(this.activeDeadlineSeconds + ",");
        }
        if (this.affinity != null) {
            sb.append("affinity:");
            sb.append(this.affinity + ",");
        }
        if (this.automountServiceAccountToken != null) {
            sb.append("automountServiceAccountToken:");
            sb.append(this.automountServiceAccountToken + ",");
        }
        if (this.containerConcurrency != null) {
            sb.append("containerConcurrency:");
            sb.append(this.containerConcurrency + ",");
        }
        if (this.containers != null && !this.containers.isEmpty()) {
            sb.append("containers:");
            sb.append(this.containers + ",");
        }
        if (this.dnsConfig != null) {
            sb.append("dnsConfig:");
            sb.append(this.dnsConfig + ",");
        }
        if (this.dnsPolicy != null) {
            sb.append("dnsPolicy:");
            sb.append(this.dnsPolicy + ",");
        }
        if (this.enableServiceLinks != null) {
            sb.append("enableServiceLinks:");
            sb.append(this.enableServiceLinks + ",");
        }
        if (this.ephemeralContainers != null && !this.ephemeralContainers.isEmpty()) {
            sb.append("ephemeralContainers:");
            sb.append(this.ephemeralContainers + ",");
        }
        if (this.hostAliases != null && !this.hostAliases.isEmpty()) {
            sb.append("hostAliases:");
            sb.append(this.hostAliases + ",");
        }
        if (this.hostIPC != null) {
            sb.append("hostIPC:");
            sb.append(this.hostIPC + ",");
        }
        if (this.hostNetwork != null) {
            sb.append("hostNetwork:");
            sb.append(this.hostNetwork + ",");
        }
        if (this.hostPID != null) {
            sb.append("hostPID:");
            sb.append(this.hostPID + ",");
        }
        if (this.hostUsers != null) {
            sb.append("hostUsers:");
            sb.append(this.hostUsers + ",");
        }
        if (this.hostname != null) {
            sb.append("hostname:");
            sb.append(this.hostname + ",");
        }
        if (this.idleTimeoutSeconds != null) {
            sb.append("idleTimeoutSeconds:");
            sb.append(this.idleTimeoutSeconds + ",");
        }
        if (this.imagePullSecrets != null && !this.imagePullSecrets.isEmpty()) {
            sb.append("imagePullSecrets:");
            sb.append(this.imagePullSecrets + ",");
        }
        if (this.initContainers != null && !this.initContainers.isEmpty()) {
            sb.append("initContainers:");
            sb.append(this.initContainers + ",");
        }
        if (this.nodeName != null) {
            sb.append("nodeName:");
            sb.append(this.nodeName + ",");
        }
        if (this.nodeSelector != null && !this.nodeSelector.isEmpty()) {
            sb.append("nodeSelector:");
            sb.append(this.nodeSelector + ",");
        }
        if (this.os != null) {
            sb.append("os:");
            sb.append(this.os + ",");
        }
        if (this.overhead != null && !this.overhead.isEmpty()) {
            sb.append("overhead:");
            sb.append(this.overhead + ",");
        }
        if (this.preemptionPolicy != null) {
            sb.append("preemptionPolicy:");
            sb.append(this.preemptionPolicy + ",");
        }
        if (this.priority != null) {
            sb.append("priority:");
            sb.append(this.priority + ",");
        }
        if (this.priorityClassName != null) {
            sb.append("priorityClassName:");
            sb.append(this.priorityClassName + ",");
        }
        if (this.readinessGates != null && !this.readinessGates.isEmpty()) {
            sb.append("readinessGates:");
            sb.append(this.readinessGates + ",");
        }
        if (this.resourceClaims != null && !this.resourceClaims.isEmpty()) {
            sb.append("resourceClaims:");
            sb.append(this.resourceClaims + ",");
        }
        if (this.responseStartTimeoutSeconds != null) {
            sb.append("responseStartTimeoutSeconds:");
            sb.append(this.responseStartTimeoutSeconds + ",");
        }
        if (this.restartPolicy != null) {
            sb.append("restartPolicy:");
            sb.append(this.restartPolicy + ",");
        }
        if (this.runtimeClassName != null) {
            sb.append("runtimeClassName:");
            sb.append(this.runtimeClassName + ",");
        }
        if (this.schedulerName != null) {
            sb.append("schedulerName:");
            sb.append(this.schedulerName + ",");
        }
        if (this.schedulingGates != null && !this.schedulingGates.isEmpty()) {
            sb.append("schedulingGates:");
            sb.append(this.schedulingGates + ",");
        }
        if (this.securityContext != null) {
            sb.append("securityContext:");
            sb.append(this.securityContext + ",");
        }
        if (this.serviceAccount != null) {
            sb.append("serviceAccount:");
            sb.append(this.serviceAccount + ",");
        }
        if (this.serviceAccountName != null) {
            sb.append("serviceAccountName:");
            sb.append(this.serviceAccountName + ",");
        }
        if (this.setHostnameAsFQDN != null) {
            sb.append("setHostnameAsFQDN:");
            sb.append(this.setHostnameAsFQDN + ",");
        }
        if (this.shareProcessNamespace != null) {
            sb.append("shareProcessNamespace:");
            sb.append(this.shareProcessNamespace + ",");
        }
        if (this.subdomain != null) {
            sb.append("subdomain:");
            sb.append(this.subdomain + ",");
        }
        if (this.terminationGracePeriodSeconds != null) {
            sb.append("terminationGracePeriodSeconds:");
            sb.append(this.terminationGracePeriodSeconds + ",");
        }
        if (this.timeoutSeconds != null) {
            sb.append("timeoutSeconds:");
            sb.append(this.timeoutSeconds + ",");
        }
        if (this.tolerations != null && !this.tolerations.isEmpty()) {
            sb.append("tolerations:");
            sb.append(this.tolerations + ",");
        }
        if (this.topologySpreadConstraints != null && !this.topologySpreadConstraints.isEmpty()) {
            sb.append("topologySpreadConstraints:");
            sb.append(this.topologySpreadConstraints + ",");
        }
        if (this.volumes != null && !this.volumes.isEmpty()) {
            sb.append("volumes:");
            sb.append(this.volumes + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withAutomountServiceAccountToken() {
        return this.withAutomountServiceAccountToken(true);
    }

    public A withEnableServiceLinks() {
        return this.withEnableServiceLinks(true);
    }

    public A withHostIPC() {
        return this.withHostIPC(true);
    }

    public A withHostNetwork() {
        return this.withHostNetwork(true);
    }

    public A withHostPID() {
        return this.withHostPID(true);
    }

    public A withHostUsers() {
        return this.withHostUsers(true);
    }

    public A withSetHostnameAsFQDN() {
        return this.withSetHostnameAsFQDN(true);
    }

    public A withShareProcessNamespace() {
        return this.withShareProcessNamespace(true);
    }

    public class VolumesNested<N>
    extends VolumeFluent<VolumesNested<N>>
    implements Nested<N> {
        VolumeBuilder builder;
        int index;

        VolumesNested(int index, Volume item) {
            this.index = index;
            this.builder = new VolumeBuilder((VolumeFluent)this, item);
        }

        public N and() {
            return (N)RevisionSpecFluent.this.setToVolumes(this.index, this.builder.build());
        }

        public N endVolume() {
            return this.and();
        }
    }

    public class InitContainersNested<N>
    extends ContainerFluent<InitContainersNested<N>>
    implements Nested<N> {
        ContainerBuilder builder;
        int index;

        InitContainersNested(int index, Container item) {
            this.index = index;
            this.builder = new ContainerBuilder((ContainerFluent)this, item);
        }

        public N and() {
            return (N)RevisionSpecFluent.this.setToInitContainers(this.index, this.builder.build());
        }

        public N endInitContainer() {
            return this.and();
        }
    }

    public class ImagePullSecretsNested<N>
    extends LocalObjectReferenceFluent<ImagePullSecretsNested<N>>
    implements Nested<N> {
        LocalObjectReferenceBuilder builder;
        int index;

        ImagePullSecretsNested(int index, LocalObjectReference item) {
            this.index = index;
            this.builder = new LocalObjectReferenceBuilder((LocalObjectReferenceFluent)this, item);
        }

        public N and() {
            return (N)RevisionSpecFluent.this.setToImagePullSecrets(this.index, this.builder.build());
        }

        public N endImagePullSecret() {
            return this.and();
        }
    }

    public class ContainersNested<N>
    extends ContainerFluent<ContainersNested<N>>
    implements Nested<N> {
        ContainerBuilder builder;
        int index;

        ContainersNested(int index, Container item) {
            this.index = index;
            this.builder = new ContainerBuilder((ContainerFluent)this, item);
        }

        public N and() {
            return (N)RevisionSpecFluent.this.setToContainers(this.index, this.builder.build());
        }

        public N endContainer() {
            return this.and();
        }
    }
}

