/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.knative.flows.v1;

import io.fabric8.knative.duck.v1.Destination;
import io.fabric8.knative.duck.v1.DestinationBuilder;
import io.fabric8.knative.duck.v1.DestinationFluent;
import io.fabric8.knative.flows.v1.ParallelBranch;
import io.fabric8.knative.flows.v1.ParallelBranchBuilder;
import io.fabric8.knative.flows.v1.ParallelBranchFluent;
import io.fabric8.knative.flows.v1.ParallelSpec;
import io.fabric8.knative.messaging.v1.ChannelTemplateSpec;
import io.fabric8.knative.messaging.v1.ChannelTemplateSpecBuilder;
import io.fabric8.knative.messaging.v1.ChannelTemplateSpecFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ParallelSpecFluent<A extends ParallelSpecFluent<A>>
extends BaseFluent<A> {
    private ArrayList<ParallelBranchBuilder> branches = new ArrayList();
    private ChannelTemplateSpecBuilder channelTemplate;
    private DestinationBuilder reply;
    private Map<String, Object> additionalProperties;

    public ParallelSpecFluent() {
    }

    public ParallelSpecFluent(ParallelSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ParallelSpec instance) {
        ParallelSpec parallelSpec = instance = instance != null ? instance : new ParallelSpec();
        if (instance != null) {
            this.withBranches(instance.getBranches());
            this.withChannelTemplate(instance.getChannelTemplate());
            this.withReply(instance.getReply());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToBranches(int index, ParallelBranch item) {
        if (this.branches == null) {
            this.branches = new ArrayList();
        }
        ParallelBranchBuilder builder = new ParallelBranchBuilder(item);
        if (index < 0 || index >= this.branches.size()) {
            this._visitables.get((Object)"branches").add(builder);
            this.branches.add(builder);
        } else {
            this._visitables.get((Object)"branches").add(builder);
            this.branches.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToBranches(int index, ParallelBranch item) {
        if (this.branches == null) {
            this.branches = new ArrayList();
        }
        ParallelBranchBuilder builder = new ParallelBranchBuilder(item);
        if (index < 0 || index >= this.branches.size()) {
            this._visitables.get((Object)"branches").add(builder);
            this.branches.add(builder);
        } else {
            this._visitables.get((Object)"branches").add(builder);
            this.branches.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToBranches(ParallelBranch ... items) {
        if (this.branches == null) {
            this.branches = new ArrayList();
        }
        for (ParallelBranch item : items) {
            ParallelBranchBuilder builder = new ParallelBranchBuilder(item);
            this._visitables.get((Object)"branches").add(builder);
            this.branches.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToBranches(Collection<ParallelBranch> items) {
        if (this.branches == null) {
            this.branches = new ArrayList();
        }
        for (ParallelBranch item : items) {
            ParallelBranchBuilder builder = new ParallelBranchBuilder(item);
            this._visitables.get((Object)"branches").add(builder);
            this.branches.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromBranches(ParallelBranch ... items) {
        if (this.branches == null) {
            return (A)((Object)this);
        }
        for (ParallelBranch item : items) {
            ParallelBranchBuilder builder = new ParallelBranchBuilder(item);
            this._visitables.get((Object)"branches").remove((Object)builder);
            this.branches.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromBranches(Collection<ParallelBranch> items) {
        if (this.branches == null) {
            return (A)((Object)this);
        }
        for (ParallelBranch item : items) {
            ParallelBranchBuilder builder = new ParallelBranchBuilder(item);
            this._visitables.get((Object)"branches").remove((Object)builder);
            this.branches.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromBranches(Predicate<ParallelBranchBuilder> predicate) {
        if (this.branches == null) {
            return (A)((Object)this);
        }
        Iterator<ParallelBranchBuilder> each = this.branches.iterator();
        List visitables = this._visitables.get((Object)"branches");
        while (each.hasNext()) {
            ParallelBranchBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<ParallelBranch> buildBranches() {
        return this.branches != null ? ParallelSpecFluent.build(this.branches) : null;
    }

    public ParallelBranch buildBranch(int index) {
        return this.branches.get(index).build();
    }

    public ParallelBranch buildFirstBranch() {
        return this.branches.get(0).build();
    }

    public ParallelBranch buildLastBranch() {
        return this.branches.get(this.branches.size() - 1).build();
    }

    public ParallelBranch buildMatchingBranch(Predicate<ParallelBranchBuilder> predicate) {
        for (ParallelBranchBuilder item : this.branches) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingBranch(Predicate<ParallelBranchBuilder> predicate) {
        for (ParallelBranchBuilder item : this.branches) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withBranches(List<ParallelBranch> branches) {
        if (this.branches != null) {
            this._visitables.get((Object)"branches").clear();
        }
        if (branches != null) {
            this.branches = new ArrayList();
            for (ParallelBranch item : branches) {
                this.addToBranches(item);
            }
        } else {
            this.branches = null;
        }
        return (A)((Object)this);
    }

    public A withBranches(ParallelBranch ... branches) {
        if (this.branches != null) {
            this.branches.clear();
            this._visitables.remove((Object)"branches");
        }
        if (branches != null) {
            for (ParallelBranch item : branches) {
                this.addToBranches(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasBranches() {
        return this.branches != null && !this.branches.isEmpty();
    }

    public BranchesNested<A> addNewBranch() {
        return new BranchesNested(-1, null);
    }

    public BranchesNested<A> addNewBranchLike(ParallelBranch item) {
        return new BranchesNested(-1, item);
    }

    public BranchesNested<A> setNewBranchLike(int index, ParallelBranch item) {
        return new BranchesNested(index, item);
    }

    public BranchesNested<A> editBranch(int index) {
        if (this.branches.size() <= index) {
            throw new RuntimeException("Can't edit branches. Index exceeds size.");
        }
        return this.setNewBranchLike(index, this.buildBranch(index));
    }

    public BranchesNested<A> editFirstBranch() {
        if (this.branches.size() == 0) {
            throw new RuntimeException("Can't edit first branches. The list is empty.");
        }
        return this.setNewBranchLike(0, this.buildBranch(0));
    }

    public BranchesNested<A> editLastBranch() {
        int index = this.branches.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last branches. The list is empty.");
        }
        return this.setNewBranchLike(index, this.buildBranch(index));
    }

    public BranchesNested<A> editMatchingBranch(Predicate<ParallelBranchBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.branches.size(); ++i) {
            if (!predicate.test(this.branches.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching branches. No match found.");
        }
        return this.setNewBranchLike(index, this.buildBranch(index));
    }

    public ChannelTemplateSpec buildChannelTemplate() {
        return this.channelTemplate != null ? this.channelTemplate.build() : null;
    }

    public A withChannelTemplate(ChannelTemplateSpec channelTemplate) {
        this._visitables.remove((Object)"channelTemplate");
        if (channelTemplate != null) {
            this.channelTemplate = new ChannelTemplateSpecBuilder(channelTemplate);
            this._visitables.get((Object)"channelTemplate").add(this.channelTemplate);
        } else {
            this.channelTemplate = null;
            this._visitables.get((Object)"channelTemplate").remove((Object)this.channelTemplate);
        }
        return (A)((Object)this);
    }

    public boolean hasChannelTemplate() {
        return this.channelTemplate != null;
    }

    public A withNewChannelTemplate(String apiVersion, String kind, Object spec) {
        return this.withChannelTemplate(new ChannelTemplateSpec(apiVersion, kind, spec));
    }

    public ChannelTemplateNested<A> withNewChannelTemplate() {
        return new ChannelTemplateNested(null);
    }

    public ChannelTemplateNested<A> withNewChannelTemplateLike(ChannelTemplateSpec item) {
        return new ChannelTemplateNested(item);
    }

    public ChannelTemplateNested<A> editChannelTemplate() {
        return this.withNewChannelTemplateLike(Optional.ofNullable(this.buildChannelTemplate()).orElse(null));
    }

    public ChannelTemplateNested<A> editOrNewChannelTemplate() {
        return this.withNewChannelTemplateLike(Optional.ofNullable(this.buildChannelTemplate()).orElse(new ChannelTemplateSpecBuilder().build()));
    }

    public ChannelTemplateNested<A> editOrNewChannelTemplateLike(ChannelTemplateSpec item) {
        return this.withNewChannelTemplateLike(Optional.ofNullable(this.buildChannelTemplate()).orElse(item));
    }

    public Destination buildReply() {
        return this.reply != null ? this.reply.build() : null;
    }

    public A withReply(Destination reply) {
        this._visitables.remove((Object)"reply");
        if (reply != null) {
            this.reply = new DestinationBuilder(reply);
            this._visitables.get((Object)"reply").add(this.reply);
        } else {
            this.reply = null;
            this._visitables.get((Object)"reply").remove((Object)this.reply);
        }
        return (A)((Object)this);
    }

    public boolean hasReply() {
        return this.reply != null;
    }

    public ReplyNested<A> withNewReply() {
        return new ReplyNested(null);
    }

    public ReplyNested<A> withNewReplyLike(Destination item) {
        return new ReplyNested(item);
    }

    public ReplyNested<A> editReply() {
        return this.withNewReplyLike(Optional.ofNullable(this.buildReply()).orElse(null));
    }

    public ReplyNested<A> editOrNewReply() {
        return this.withNewReplyLike(Optional.ofNullable(this.buildReply()).orElse(new DestinationBuilder().build()));
    }

    public ReplyNested<A> editOrNewReplyLike(Destination item) {
        return this.withNewReplyLike(Optional.ofNullable(this.buildReply()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ParallelSpecFluent that = (ParallelSpecFluent)((Object)o);
        if (!Objects.equals(this.branches, that.branches)) {
            return false;
        }
        if (!Objects.equals((Object)this.channelTemplate, (Object)that.channelTemplate)) {
            return false;
        }
        if (!Objects.equals((Object)this.reply, (Object)that.reply)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.branches, this.channelTemplate, this.reply, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.branches != null && !this.branches.isEmpty()) {
            sb.append("branches:");
            sb.append(this.branches + ",");
        }
        if (this.channelTemplate != null) {
            sb.append("channelTemplate:");
            sb.append(this.channelTemplate + ",");
        }
        if (this.reply != null) {
            sb.append("reply:");
            sb.append(this.reply + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ReplyNested<N>
    extends DestinationFluent<ReplyNested<N>>
    implements Nested<N> {
        DestinationBuilder builder;

        ReplyNested(Destination item) {
            this.builder = new DestinationBuilder(this, item);
        }

        public N and() {
            return (N)ParallelSpecFluent.this.withReply(this.builder.build());
        }

        public N endReply() {
            return this.and();
        }
    }

    public class ChannelTemplateNested<N>
    extends ChannelTemplateSpecFluent<ChannelTemplateNested<N>>
    implements Nested<N> {
        ChannelTemplateSpecBuilder builder;

        ChannelTemplateNested(ChannelTemplateSpec item) {
            this.builder = new ChannelTemplateSpecBuilder(this, item);
        }

        public N and() {
            return (N)ParallelSpecFluent.this.withChannelTemplate(this.builder.build());
        }

        public N endChannelTemplate() {
            return this.and();
        }
    }

    public class BranchesNested<N>
    extends ParallelBranchFluent<BranchesNested<N>>
    implements Nested<N> {
        ParallelBranchBuilder builder;
        int index;

        BranchesNested(int index, ParallelBranch item) {
            this.index = index;
            this.builder = new ParallelBranchBuilder(this, item);
        }

        public N and() {
            return (N)ParallelSpecFluent.this.setToBranches(this.index, this.builder.build());
        }

        public N endBranch() {
            return this.and();
        }
    }
}

