/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.knative.eventing.v1;

import io.fabric8.knative.duck.v1.Addressable;
import io.fabric8.knative.duck.v1.AddressableBuilder;
import io.fabric8.knative.duck.v1.AddressableFluent;
import io.fabric8.knative.duck.v1.AppliedEventPolicyRef;
import io.fabric8.knative.duck.v1.AppliedEventPolicyRefBuilder;
import io.fabric8.knative.duck.v1.AppliedEventPolicyRefFluent;
import io.fabric8.knative.eventing.v1.BrokerStatus;
import io.fabric8.knative.pkg.apis.Condition;
import io.fabric8.knative.pkg.apis.ConditionBuilder;
import io.fabric8.knative.pkg.apis.ConditionFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class BrokerStatusFluent<A extends BrokerStatusFluent<A>>
extends BaseFluent<A> {
    private AddressableBuilder address;
    private ArrayList<AddressableBuilder> addresses = new ArrayList();
    private Map<String, String> annotations;
    private ArrayList<ConditionBuilder> conditions = new ArrayList();
    private String deadLetterSinkAudience;
    private String deadLetterSinkCACerts;
    private String deadLetterSinkUri;
    private Long observedGeneration;
    private ArrayList<AppliedEventPolicyRefBuilder> policies = new ArrayList();
    private Map<String, Object> additionalProperties;

    public BrokerStatusFluent() {
    }

    public BrokerStatusFluent(BrokerStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(BrokerStatus instance) {
        BrokerStatus brokerStatus = instance = instance != null ? instance : new BrokerStatus();
        if (instance != null) {
            this.withAddress(instance.getAddress());
            this.withAddresses(instance.getAddresses());
            this.withAnnotations(instance.getAnnotations());
            this.withConditions(instance.getConditions());
            this.withDeadLetterSinkAudience(instance.getDeadLetterSinkAudience());
            this.withDeadLetterSinkCACerts(instance.getDeadLetterSinkCACerts());
            this.withDeadLetterSinkUri(instance.getDeadLetterSinkUri());
            this.withObservedGeneration(instance.getObservedGeneration());
            this.withPolicies(instance.getPolicies());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Addressable buildAddress() {
        return this.address != null ? this.address.build() : null;
    }

    public A withAddress(Addressable address) {
        this._visitables.remove((Object)"address");
        if (address != null) {
            this.address = new AddressableBuilder(address);
            this._visitables.get((Object)"address").add(this.address);
        } else {
            this.address = null;
            this._visitables.get((Object)"address").remove((Object)this.address);
        }
        return (A)((Object)this);
    }

    public boolean hasAddress() {
        return this.address != null;
    }

    public A withNewAddress(String cACerts, String audience, String name, String url) {
        return this.withAddress(new Addressable(cACerts, audience, name, url));
    }

    public AddressNested<A> withNewAddress() {
        return new AddressNested(null);
    }

    public AddressNested<A> withNewAddressLike(Addressable item) {
        return new AddressNested(item);
    }

    public AddressNested<A> editAddress() {
        return this.withNewAddressLike(Optional.ofNullable(this.buildAddress()).orElse(null));
    }

    public AddressNested<A> editOrNewAddress() {
        return this.withNewAddressLike(Optional.ofNullable(this.buildAddress()).orElse(new AddressableBuilder().build()));
    }

    public AddressNested<A> editOrNewAddressLike(Addressable item) {
        return this.withNewAddressLike(Optional.ofNullable(this.buildAddress()).orElse(item));
    }

    public A addToAddresses(int index, Addressable item) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        AddressableBuilder builder = new AddressableBuilder(item);
        if (index < 0 || index >= this.addresses.size()) {
            this._visitables.get((Object)"addresses").add(builder);
            this.addresses.add(builder);
        } else {
            this._visitables.get((Object)"addresses").add(builder);
            this.addresses.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToAddresses(int index, Addressable item) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        AddressableBuilder builder = new AddressableBuilder(item);
        if (index < 0 || index >= this.addresses.size()) {
            this._visitables.get((Object)"addresses").add(builder);
            this.addresses.add(builder);
        } else {
            this._visitables.get((Object)"addresses").add(builder);
            this.addresses.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToAddresses(Addressable ... items) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        for (Addressable item : items) {
            AddressableBuilder builder = new AddressableBuilder(item);
            this._visitables.get((Object)"addresses").add(builder);
            this.addresses.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToAddresses(Collection<Addressable> items) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        for (Addressable item : items) {
            AddressableBuilder builder = new AddressableBuilder(item);
            this._visitables.get((Object)"addresses").add(builder);
            this.addresses.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAddresses(Addressable ... items) {
        if (this.addresses == null) {
            return (A)((Object)this);
        }
        for (Addressable item : items) {
            AddressableBuilder builder = new AddressableBuilder(item);
            this._visitables.get((Object)"addresses").remove((Object)builder);
            this.addresses.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromAddresses(Collection<Addressable> items) {
        if (this.addresses == null) {
            return (A)((Object)this);
        }
        for (Addressable item : items) {
            AddressableBuilder builder = new AddressableBuilder(item);
            this._visitables.get((Object)"addresses").remove((Object)builder);
            this.addresses.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromAddresses(Predicate<AddressableBuilder> predicate) {
        if (this.addresses == null) {
            return (A)((Object)this);
        }
        Iterator<AddressableBuilder> each = this.addresses.iterator();
        List visitables = this._visitables.get((Object)"addresses");
        while (each.hasNext()) {
            AddressableBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Addressable> buildAddresses() {
        return this.addresses != null ? BrokerStatusFluent.build(this.addresses) : null;
    }

    public Addressable buildAddress(int index) {
        return this.addresses.get(index).build();
    }

    public Addressable buildFirstAddress() {
        return this.addresses.get(0).build();
    }

    public Addressable buildLastAddress() {
        return this.addresses.get(this.addresses.size() - 1).build();
    }

    public Addressable buildMatchingAddress(Predicate<AddressableBuilder> predicate) {
        for (AddressableBuilder item : this.addresses) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingAddress(Predicate<AddressableBuilder> predicate) {
        for (AddressableBuilder item : this.addresses) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withAddresses(List<Addressable> addresses) {
        if (this.addresses != null) {
            this._visitables.get((Object)"addresses").clear();
        }
        if (addresses != null) {
            this.addresses = new ArrayList();
            for (Addressable item : addresses) {
                this.addToAddresses(item);
            }
        } else {
            this.addresses = null;
        }
        return (A)((Object)this);
    }

    public A withAddresses(Addressable ... addresses) {
        if (this.addresses != null) {
            this.addresses.clear();
            this._visitables.remove((Object)"addresses");
        }
        if (addresses != null) {
            for (Addressable item : addresses) {
                this.addToAddresses(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasAddresses() {
        return this.addresses != null && !this.addresses.isEmpty();
    }

    public A addNewAddress(String cACerts, String audience, String name, String url) {
        return this.addToAddresses(new Addressable(cACerts, audience, name, url));
    }

    public AddressesNested<A> addNewAddress() {
        return new AddressesNested(-1, null);
    }

    public AddressesNested<A> addNewAddressLike(Addressable item) {
        return new AddressesNested(-1, item);
    }

    public AddressesNested<A> setNewAddressLike(int index, Addressable item) {
        return new AddressesNested(index, item);
    }

    public AddressesNested<A> editAddress(int index) {
        if (this.addresses.size() <= index) {
            throw new RuntimeException("Can't edit addresses. Index exceeds size.");
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    public AddressesNested<A> editFirstAddress() {
        if (this.addresses.size() == 0) {
            throw new RuntimeException("Can't edit first addresses. The list is empty.");
        }
        return this.setNewAddressLike(0, this.buildAddress(0));
    }

    public AddressesNested<A> editLastAddress() {
        int index = this.addresses.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last addresses. The list is empty.");
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    public AddressesNested<A> editMatchingAddress(Predicate<AddressableBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.addresses.size(); ++i) {
            if (!predicate.test(this.addresses.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching addresses. No match found.");
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    public A addToAnnotations(String key, String value) {
        if (this.annotations == null && key != null && value != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.annotations.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAnnotations(Map<String, String> map) {
        if (this.annotations == null && map != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.annotations.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAnnotations(String key) {
        if (this.annotations == null) {
            return (A)((Object)this);
        }
        if (key != null && this.annotations != null) {
            this.annotations.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAnnotations(Map<String, String> map) {
        if (this.annotations == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.annotations == null) continue;
                this.annotations.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    public <K, V> A withAnnotations(Map<String, String> annotations) {
        this.annotations = annotations == null ? null : new LinkedHashMap<String, String>(annotations);
        return (A)((Object)this);
    }

    public boolean hasAnnotations() {
        return this.annotations != null;
    }

    public A addToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        ConditionBuilder builder = new ConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        ConditionBuilder builder = new ConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToConditions(Condition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromConditions(Condition ... items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove((Object)builder);
            this.conditions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove((Object)builder);
            this.conditions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromConditions(Predicate<ConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        Iterator<ConditionBuilder> each = this.conditions.iterator();
        List visitables = this._visitables.get((Object)"conditions");
        while (each.hasNext()) {
            ConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Condition> buildConditions() {
        return this.conditions != null ? BrokerStatusFluent.build(this.conditions) : null;
    }

    public Condition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public Condition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public Condition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    public Condition buildMatchingCondition(Predicate<ConditionBuilder> predicate) {
        for (ConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<ConditionBuilder> predicate) {
        for (ConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<Condition> conditions) {
        if (this.conditions != null) {
            this._visitables.get((Object)"conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)((Object)this);
    }

    public A withConditions(Condition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove((Object)"conditions");
        }
        if (conditions != null) {
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public ConditionsNested<A> addNewCondition() {
        return new ConditionsNested(-1, null);
    }

    public ConditionsNested<A> addNewConditionLike(Condition item) {
        return new ConditionsNested(-1, item);
    }

    public ConditionsNested<A> setNewConditionLike(int index, Condition item) {
        return new ConditionsNested(index, item);
    }

    public ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    public ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editMatchingCondition(Predicate<ConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public String getDeadLetterSinkAudience() {
        return this.deadLetterSinkAudience;
    }

    public A withDeadLetterSinkAudience(String deadLetterSinkAudience) {
        this.deadLetterSinkAudience = deadLetterSinkAudience;
        return (A)((Object)this);
    }

    public boolean hasDeadLetterSinkAudience() {
        return this.deadLetterSinkAudience != null;
    }

    public String getDeadLetterSinkCACerts() {
        return this.deadLetterSinkCACerts;
    }

    public A withDeadLetterSinkCACerts(String deadLetterSinkCACerts) {
        this.deadLetterSinkCACerts = deadLetterSinkCACerts;
        return (A)((Object)this);
    }

    public boolean hasDeadLetterSinkCACerts() {
        return this.deadLetterSinkCACerts != null;
    }

    public String getDeadLetterSinkUri() {
        return this.deadLetterSinkUri;
    }

    public A withDeadLetterSinkUri(String deadLetterSinkUri) {
        this.deadLetterSinkUri = deadLetterSinkUri;
        return (A)((Object)this);
    }

    public boolean hasDeadLetterSinkUri() {
        return this.deadLetterSinkUri != null;
    }

    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return (A)((Object)this);
    }

    public boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    public A addToPolicies(int index, AppliedEventPolicyRef item) {
        if (this.policies == null) {
            this.policies = new ArrayList();
        }
        AppliedEventPolicyRefBuilder builder = new AppliedEventPolicyRefBuilder(item);
        if (index < 0 || index >= this.policies.size()) {
            this._visitables.get((Object)"policies").add(builder);
            this.policies.add(builder);
        } else {
            this._visitables.get((Object)"policies").add(builder);
            this.policies.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToPolicies(int index, AppliedEventPolicyRef item) {
        if (this.policies == null) {
            this.policies = new ArrayList();
        }
        AppliedEventPolicyRefBuilder builder = new AppliedEventPolicyRefBuilder(item);
        if (index < 0 || index >= this.policies.size()) {
            this._visitables.get((Object)"policies").add(builder);
            this.policies.add(builder);
        } else {
            this._visitables.get((Object)"policies").add(builder);
            this.policies.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToPolicies(AppliedEventPolicyRef ... items) {
        if (this.policies == null) {
            this.policies = new ArrayList();
        }
        for (AppliedEventPolicyRef item : items) {
            AppliedEventPolicyRefBuilder builder = new AppliedEventPolicyRefBuilder(item);
            this._visitables.get((Object)"policies").add(builder);
            this.policies.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToPolicies(Collection<AppliedEventPolicyRef> items) {
        if (this.policies == null) {
            this.policies = new ArrayList();
        }
        for (AppliedEventPolicyRef item : items) {
            AppliedEventPolicyRefBuilder builder = new AppliedEventPolicyRefBuilder(item);
            this._visitables.get((Object)"policies").add(builder);
            this.policies.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromPolicies(AppliedEventPolicyRef ... items) {
        if (this.policies == null) {
            return (A)((Object)this);
        }
        for (AppliedEventPolicyRef item : items) {
            AppliedEventPolicyRefBuilder builder = new AppliedEventPolicyRefBuilder(item);
            this._visitables.get((Object)"policies").remove((Object)builder);
            this.policies.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromPolicies(Collection<AppliedEventPolicyRef> items) {
        if (this.policies == null) {
            return (A)((Object)this);
        }
        for (AppliedEventPolicyRef item : items) {
            AppliedEventPolicyRefBuilder builder = new AppliedEventPolicyRefBuilder(item);
            this._visitables.get((Object)"policies").remove((Object)builder);
            this.policies.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromPolicies(Predicate<AppliedEventPolicyRefBuilder> predicate) {
        if (this.policies == null) {
            return (A)((Object)this);
        }
        Iterator<AppliedEventPolicyRefBuilder> each = this.policies.iterator();
        List visitables = this._visitables.get((Object)"policies");
        while (each.hasNext()) {
            AppliedEventPolicyRefBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<AppliedEventPolicyRef> buildPolicies() {
        return this.policies != null ? BrokerStatusFluent.build(this.policies) : null;
    }

    public AppliedEventPolicyRef buildPolicy(int index) {
        return this.policies.get(index).build();
    }

    public AppliedEventPolicyRef buildFirstPolicy() {
        return this.policies.get(0).build();
    }

    public AppliedEventPolicyRef buildLastPolicy() {
        return this.policies.get(this.policies.size() - 1).build();
    }

    public AppliedEventPolicyRef buildMatchingPolicy(Predicate<AppliedEventPolicyRefBuilder> predicate) {
        for (AppliedEventPolicyRefBuilder item : this.policies) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingPolicy(Predicate<AppliedEventPolicyRefBuilder> predicate) {
        for (AppliedEventPolicyRefBuilder item : this.policies) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withPolicies(List<AppliedEventPolicyRef> policies) {
        if (this.policies != null) {
            this._visitables.get((Object)"policies").clear();
        }
        if (policies != null) {
            this.policies = new ArrayList();
            for (AppliedEventPolicyRef item : policies) {
                this.addToPolicies(item);
            }
        } else {
            this.policies = null;
        }
        return (A)((Object)this);
    }

    public A withPolicies(AppliedEventPolicyRef ... policies) {
        if (this.policies != null) {
            this.policies.clear();
            this._visitables.remove((Object)"policies");
        }
        if (policies != null) {
            for (AppliedEventPolicyRef item : policies) {
                this.addToPolicies(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasPolicies() {
        return this.policies != null && !this.policies.isEmpty();
    }

    public A addNewPolicy(String apiVersion, String name) {
        return this.addToPolicies(new AppliedEventPolicyRef(apiVersion, name));
    }

    public PoliciesNested<A> addNewPolicy() {
        return new PoliciesNested(-1, null);
    }

    public PoliciesNested<A> addNewPolicyLike(AppliedEventPolicyRef item) {
        return new PoliciesNested(-1, item);
    }

    public PoliciesNested<A> setNewPolicyLike(int index, AppliedEventPolicyRef item) {
        return new PoliciesNested(index, item);
    }

    public PoliciesNested<A> editPolicy(int index) {
        if (this.policies.size() <= index) {
            throw new RuntimeException("Can't edit policies. Index exceeds size.");
        }
        return this.setNewPolicyLike(index, this.buildPolicy(index));
    }

    public PoliciesNested<A> editFirstPolicy() {
        if (this.policies.size() == 0) {
            throw new RuntimeException("Can't edit first policies. The list is empty.");
        }
        return this.setNewPolicyLike(0, this.buildPolicy(0));
    }

    public PoliciesNested<A> editLastPolicy() {
        int index = this.policies.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last policies. The list is empty.");
        }
        return this.setNewPolicyLike(index, this.buildPolicy(index));
    }

    public PoliciesNested<A> editMatchingPolicy(Predicate<AppliedEventPolicyRefBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.policies.size(); ++i) {
            if (!predicate.test(this.policies.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching policies. No match found.");
        }
        return this.setNewPolicyLike(index, this.buildPolicy(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BrokerStatusFluent that = (BrokerStatusFluent)((Object)o);
        if (!Objects.equals((Object)this.address, (Object)that.address)) {
            return false;
        }
        if (!Objects.equals(this.addresses, that.addresses)) {
            return false;
        }
        if (!Objects.equals(this.annotations, that.annotations)) {
            return false;
        }
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.deadLetterSinkAudience, that.deadLetterSinkAudience)) {
            return false;
        }
        if (!Objects.equals(this.deadLetterSinkCACerts, that.deadLetterSinkCACerts)) {
            return false;
        }
        if (!Objects.equals(this.deadLetterSinkUri, that.deadLetterSinkUri)) {
            return false;
        }
        if (!Objects.equals(this.observedGeneration, that.observedGeneration)) {
            return false;
        }
        if (!Objects.equals(this.policies, that.policies)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.address, this.addresses, this.annotations, this.conditions, this.deadLetterSinkAudience, this.deadLetterSinkCACerts, this.deadLetterSinkUri, this.observedGeneration, this.policies, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.address != null) {
            sb.append("address:");
            sb.append(this.address + ",");
        }
        if (this.addresses != null && !this.addresses.isEmpty()) {
            sb.append("addresses:");
            sb.append(this.addresses + ",");
        }
        if (this.annotations != null && !this.annotations.isEmpty()) {
            sb.append("annotations:");
            sb.append(this.annotations + ",");
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.deadLetterSinkAudience != null) {
            sb.append("deadLetterSinkAudience:");
            sb.append(this.deadLetterSinkAudience + ",");
        }
        if (this.deadLetterSinkCACerts != null) {
            sb.append("deadLetterSinkCACerts:");
            sb.append(this.deadLetterSinkCACerts + ",");
        }
        if (this.deadLetterSinkUri != null) {
            sb.append("deadLetterSinkUri:");
            sb.append(this.deadLetterSinkUri + ",");
        }
        if (this.observedGeneration != null) {
            sb.append("observedGeneration:");
            sb.append(this.observedGeneration + ",");
        }
        if (this.policies != null && !this.policies.isEmpty()) {
            sb.append("policies:");
            sb.append(this.policies + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class PoliciesNested<N>
    extends AppliedEventPolicyRefFluent<PoliciesNested<N>>
    implements Nested<N> {
        AppliedEventPolicyRefBuilder builder;
        int index;

        PoliciesNested(int index, AppliedEventPolicyRef item) {
            this.index = index;
            this.builder = new AppliedEventPolicyRefBuilder(this, item);
        }

        public N and() {
            return (N)BrokerStatusFluent.this.setToPolicies(this.index, this.builder.build());
        }

        public N endPolicy() {
            return this.and();
        }
    }

    public class ConditionsNested<N>
    extends ConditionFluent<ConditionsNested<N>>
    implements Nested<N> {
        ConditionBuilder builder;
        int index;

        ConditionsNested(int index, Condition item) {
            this.index = index;
            this.builder = new ConditionBuilder(this, item);
        }

        public N and() {
            return (N)BrokerStatusFluent.this.setToConditions(this.index, this.builder.build());
        }

        public N endCondition() {
            return this.and();
        }
    }

    public class AddressesNested<N>
    extends AddressableFluent<AddressesNested<N>>
    implements Nested<N> {
        AddressableBuilder builder;
        int index;

        AddressesNested(int index, Addressable item) {
            this.index = index;
            this.builder = new AddressableBuilder(this, item);
        }

        public N and() {
            return (N)BrokerStatusFluent.this.setToAddresses(this.index, this.builder.build());
        }

        public N endAddress() {
            return this.and();
        }
    }

    public class AddressNested<N>
    extends AddressableFluent<AddressNested<N>>
    implements Nested<N> {
        AddressableBuilder builder;

        AddressNested(Addressable item) {
            this.builder = new AddressableBuilder(this, item);
        }

        public N and() {
            return (N)BrokerStatusFluent.this.withAddress(this.builder.build());
        }

        public N endAddress() {
            return this.and();
        }
    }
}

