/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.javascript;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.ajax4jsf.javascript.ScriptString;
import org.ajax4jsf.javascript.ScriptStringBase;
import org.ajax4jsf.javascript.ScriptUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSFunction
extends ScriptStringBase
implements ScriptString {
    private String name;
    private List<Object> parameters = new ArrayList<Object>();

    public JSFunction(String name, Object ... parameters) {
        this.name = name;
        this.parameters.addAll(Arrays.asList(parameters));
    }

    public JSFunction addParameter(Object parameter) {
        this.getParameters().add(parameter);
        return this;
    }

    @Override
    public void appendScript(StringBuffer functionString) {
        functionString.append(this.name).append('(');
        boolean first = true;
        List<Object> parameters = this.getParameters();
        if (null != parameters) {
            for (Object element : parameters) {
                if (!first) {
                    functionString.append(',');
                }
                if (null != element) {
                    functionString.append(ScriptUtils.toScript(element));
                } else {
                    functionString.append("null");
                }
                first = false;
            }
        }
        functionString.append(")");
    }

    public List<Object> getParameters() {
        return this.parameters;
    }
}

