/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.util;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.NoSuchElementException;
import org.richfaces.cdk.CdkException;
import org.richfaces.cdk.model.InvalidNameException;
import org.richfaces.cdk.util.Strings;

public final class PropertyUtils {
    private PropertyUtils() {
    }

    public static String methodToName(String methodName) throws InvalidNameException {
        if (null != methodName) {
            if (methodName.length() > 3 && Character.isUpperCase(methodName.charAt(3)) && (methodName.startsWith("set") || methodName.startsWith("get"))) {
                return Strings.firstToLowerCase(methodName.substring(3));
            }
            if (methodName.length() > 2 && Character.isUpperCase(methodName.charAt(2)) && methodName.startsWith("is")) {
                return Strings.firstToLowerCase(methodName.substring(2));
            }
        }
        throw new InvalidNameException("Method name " + methodName + " is not valid bean property getter or setter");
    }

    public static void setPropertyValue(Object bean, String propertyName, Object newValue) {
        PropertyDescriptor propertyDescriptor = PropertyUtils.getPropertyDescriptor(bean, propertyName);
        if (null != propertyDescriptor.getWriteMethod()) {
            try {
                propertyDescriptor.getWriteMethod().invoke(bean, newValue);
            }
            catch (Exception e) {
                throw new CdkException("Cannot set new value for bean property " + bean.getClass().getName() + "#" + propertyName, (Throwable)e);
            }
        } else {
            throw new CdkException("Bean property not writable " + bean.getClass().getName() + "#" + propertyName);
        }
    }

    public static PropertyDescriptor getPropertyDescriptor(Object bean, String propertyName) {
        PropertyDescriptor[] properties;
        try {
            properties = Introspector.getBeanInfo(bean.getClass()).getPropertyDescriptors();
        }
        catch (IntrospectionException e) {
            throw new CdkException((Throwable)e);
        }
        for (PropertyDescriptor propertyDescriptor : properties) {
            if (!propertyName.equals(propertyDescriptor.getName())) continue;
            return propertyDescriptor;
        }
        throw new NoSuchElementException("Bean property " + propertyName + " not found in class " + bean.getClass().getName());
    }
}

