/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.templatecompiler.statements;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.List;
import org.richfaces.cdk.Logger;
import org.richfaces.cdk.generate.freemarker.FreeMarkerRenderer;
import org.richfaces.cdk.templatecompiler.ELParser;
import org.richfaces.cdk.templatecompiler.TemplateModel;
import org.richfaces.cdk.templatecompiler.builder.model.JavaField;
import org.richfaces.cdk.templatecompiler.builder.model.JavaImport;
import org.richfaces.cdk.templatecompiler.builder.model.RequireImports;
import org.richfaces.cdk.templatecompiler.builder.model.Variables;
import org.richfaces.cdk.templatecompiler.el.ParsingException;
import org.richfaces.cdk.templatecompiler.el.types.TypesFactory;
import org.richfaces.cdk.templatecompiler.statements.FreeMarkerTemplateStatementBase;
import org.richfaces.cdk.templatecompiler.statements.HelperMethod;
import org.richfaces.cdk.templatecompiler.statements.TemplateStatement;
import org.richfaces.cdk.templatecompiler.statements.TypedTemplateStatement;

public class ScriptOptionStatement
extends FreeMarkerTemplateStatementBase {
    private String name;
    private String defaultValue;
    private TypedTemplateStatement value;
    private String wrapper;
    private ELParser parser;
    private Logger logger;

    @Inject
    public ScriptOptionStatement(@TemplateModel FreeMarkerRenderer renderer, ELParser parser, Logger logger) {
        super(renderer, "script-option");
        this.parser = parser;
        this.logger = logger;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setValueExpression(String valueExpression) {
        try {
            this.value = this.parser.parse(valueExpression, (Variables)this, TypesFactory.OBJECT_TYPE);
        }
        catch (ParsingException e) {
            this.logger.error((CharSequence)("Error parse scriptOption value expression: " + valueExpression), (Throwable)e);
        }
    }

    public void setWrapper(String wrapper) {
        this.wrapper = wrapper;
    }

    @Override
    public List<TemplateStatement> getStatements() {
        return this.value != null ? Collections.singletonList(this.value) : Collections.emptyList();
    }

    public String getName() {
        return this.name;
    }

    public TypedTemplateStatement getValue() {
        return this.value;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getWrapper() {
        return this.wrapper;
    }

    @Override
    public Iterable<JavaField> getRequiredFields() {
        return Iterables.concat(super.getRequiredFields(), (Iterable)((Iterable)TemplateStatement.FIELDS_TRANSFORM.apply((Object)this.value)));
    }

    @Override
    public Iterable<JavaImport> getRequiredImports() {
        return Iterables.concat(super.getRequiredImports(), (Iterable)((Iterable)RequireImports.IMPORTS_TRANSFORM.apply((Object)this.value)));
    }

    @Override
    public Iterable<HelperMethod> getRequiredMethods() {
        return Iterables.concat(super.getRequiredMethods(), (Iterable)((Iterable)METHODS_TRANSFORM.apply((Object)this.value)));
    }
}

